/*                                                                
**  Copyright (C) 1996,2007  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* pset.c
**/

#include <unistd.h>
#include <stdlib.h>

#include "pfile.h"
#include "putil.h"
#include "ptemplat.h"
#include "parameter.h"

#include <string.h>

#define MAXARGV 1024

int
main(int argc, char *argv[])
{
  ParamFile	  pfile;
  Parameter 	**params;

  if ( argc <= 1 ) {
    fprintf(stdout, "usage: pset pfile [param1[=value] param2 ...]\n");
    exit(1);
  }

  if ( (pfile = paramopen(argv[1], NULL, 0, "rwL")) == NULL ) {
    fprintf(stderr, "pset: can't open parameter file : %s\n", argv[1]);
    exit(1);
  }

  memset( paramToolName, 0, PARAMTOOLNAMELEN);
  if ( strrchr( argv[1], '/' ) ) 
    strncpy( paramToolName, strrchr(argv[1], '/'), PARAMTOOLNAMELEN-1 );
  else
    strncpy( paramToolName, argv[1],  PARAMTOOLNAMELEN-1);


  if ( argc == 2 ) {
    for ( params = pfile->psets->param; *params; params++ ) {
      if ( TypeIndex((*params)->ptype) == CommentType ) continue;
      
      ParamSetX(pfile, (*params)->pname, StringType, NULL);
    }
  } else {
    char tok[SZ_PFLINE];
    char *xargv[MAXARGV];
    int xargc=0;
    ParamList *alist;

    if ( argv[2][0] == '-' ) {
      while ( 1 ) {
	if ( PSkipWhite(stdin) == -1 ) break;
	if ( PReadTok(stdin, tok, SZ_PFLINE) == -1 ) break;
	xargv[xargc++] = CXCNewString(tok);
      }
      if( (alist = ParamFileArgs(pfile->psets, &xargv[0], xargc)) 
	  == NULL ) {
	fprintf( stderr, paramerrstr());
	fprintf( stderr,"\n");
	exit(1);
      }
    }
    else{
      if( (alist = ParamFileArgs(pfile->psets, &argv[2], argc - 2)) 
	  == NULL ) {
	fprintf( stderr, paramerrstr());
	fprintf( stderr,"\n");
	exit(1);
      }
    }

    for ( params = alist->param; *params; params++ )
      pputstr(pfile, (*params)->pname, (*params)->pvalue.value);
  }

  paramclose(pfile);
  return 0;
}



