### an aggregatee class for selecting with a rectangle

use parent 'MatrixBitmapAreaSelectorAgg';

use 'GFX-Tools-Buffer::matrix';

sub new {
    my ($class, $x, $y, $width, $height) = @_;

    $self = { x => $x, y => $y, width => $width, height => $height,
	      areas => undef, };

    bless $self, $class;

};

sub selectArea {
  my ($self, $bitmapmatrixobj, $matrixareaobj) = @_;

  my $matrix = $bitmapmatrixobj->getMatrix;
  my $resultmatrix = matrix->new($self->{height}, $self->{width});

  for (my $j = $self->{y}; $j < $self->{y} + $self->{height}; $j++) {
    for (my $i = $self->{x}; $i < $self->{x} + $self->{width}; $i++) {
      $resultmatrix->setAtIndex($j - $self->{height}, $i - $self->{width}, $matrix->indexOf($j, $i));
    }
  }
    
  my $resultobj = MatrixBitmap->new;
  $resultobj->setMatrix($resultmatrix);

  return $resultobj;
}

1;
