use strict;
use Test;
BEGIN { plan tests => 10 }

use Convert::DUDE qw(:all);
use Unicode::String qw(utf16);

# taken from ietf-idn-dude-02.txt, embeded in UTF16
my @todo = (
    "\x00\x33\x5e\x74\x00\x62\x7d\x44\x91\xd1\x51\x6b\x51\x48\x75\x1f" => 'xdx8whx8tgz7ug863f6s5kuduwxh',
    "\x5B\x89\x5B\xA4\x59\x48\x7F\x8E\x60\x75\x00\x2D\x00\x77\x00\x69\x00\x74\x00\x68\x00\x2D\x00\x73\x00\x75\x00\x70\x00\x65\x00\x72\x00\x2D\x00\x6D\x00\x6F\x00\x6E\x00\x6B\x00\x65\x00\x79\x00\x73" => 'x58jupu8nuy6gt99m-yssctqtptn-tmgftfth-trcbfqtnk',
    "\x00\x6D\x00\x61\x00\x6A\x00\x69\x30\x67\x00\x6B\x00\x6F\x00\x69\x30\x59\x30\x8B\x00\x35\x79\xD2\x52\x4D" => 'pnmdvssqvssnegvsva7cvs5qz38hu53r',
    "\x30\xD1\x30\xD5\x30\xA3\x30\xFC\x00\x64\x00\x65\x30\xEB\x30\xF3\x30\xD0" => 'vs5bezgxrvs3ibvs2qtiud',
    "\x30\x5D\x30\x6E\x30\xB9\x30\xD4\x30\xFC\x30\xC9\x30\x67" => 'vsvpvd7hypuivf4q',
);

while (my($utf16, $dude) = splice(@todo, 0, 2)) {
eval {    my $utf8 = utf16($utf16)->utf8;
    ok(dude_encode($utf8) eq $dude);
    ok(dude_decode($dude) eq $utf8);
      };

}


