Summary: Displays who is logged in to local network machines.
Name: rwho
Version: 0.17
Release: 22.gnupro.1
License: BSD
Group: System Environment/Daemons
Source: ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/netkit-rwho-%{version}.tar.gz
Source1: rwhod.init
Patch0: netkit-rwho-0.15-alpha.patch
Patch1: netkit-rwho-0.17-bug22014.patch
Patch2: rwho-0.17-fixbcast.patch
Patch3: rwho-0.17-fixhostname.patch
Patch4: netkit-rwho-0.17-strip.patch
Patch10000: netkit-rwho-0.17-cross.patch
Requires: /sbin/chkconfig /etc/init.d
BuildRoot: %{_tmppath}/%{name}-root

%description
The rwho command displays output similar to the output of the who
command (it shows who is logged in) for all machines on the local
network running the rwho daemon.

Install the rwho command if you need to keep track of the users who
are logged in to your local network.

%prep
%setup -q -n netkit-rwho-%{version}
%patch0 -p1 -b .alpha
%patch1 -p1 -b .bug22014
%patch2 -p1 -b .fixbcast
%patch3 -p1 -b .fixhostname
%patch4 -p1 -b .strip
%if "%{_arch}" != %{_build_arch}
%patch10000 -p1 -b .cross
%endif

%build
%if "%{_arch}" != %{_build_arch}
export bsd_signal_cflags=""
export snprintf_implementation_libs=""
%endif
sh configure --with-c-compiler=%{__cc}
%if "%{_arch}" == %{_build_arch}
%ifarch s390 s390x
%{__perl} -pi -e '
    s,^CC=.*$,CC=cc,;
    s,-O2,\$(RPM_OPT_FLAGS) -fPIC,;
    s,^LDFLAGS=,LDFLAGS=-pie,;
    s,^BINDIR=.*$,BINDIR=%{_bindir},;
    s,^MANDIR=.*$,MANDIR=%{_mandir},;
    s,^SBINDIR=.*$,SBINDIR=%{_sbindir},;
    ' MCONFIG
%else
%{__perl} -pi -e '
    s,^CC=.*$,CC=cc,;
    s,-O2,\$(RPM_OPT_FLAGS) -fpic,;
    s,^LDFLAGS=,LDFLAGS=-pie,;
    s,^BINDIR=.*$,BINDIR=%{_bindir},;
    s,^MANDIR=.*$,MANDIR=%{_mandir},;
    s,^SBINDIR=.*$,SBINDIR=%{_sbindir},;
    ' MCONFIG
%endif
%else
%{__perl} -pi -e '
    s,^CC=.*$,CC=%{__cc},;
    s,-O2,\$(RPM_OPT_FLAGS) -fpic,;
    s,^BINDIR=.*$,BINDIR=%{_bindir},;
    s,^MANDIR=.*$,MANDIR=%{_mandir},;
    s,^SBINDIR=.*$,SBINDIR=%{_sbindir},;
    ' MCONFIG
%endif
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man{1,8}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}/etc/rc.d/init.d
mkdir -p ${RPM_BUILD_ROOT}/var/spool/rwho

make INSTALLROOT=${RPM_BUILD_ROOT} install
make INSTALLROOT=${RPM_BUILD_ROOT} install -C ruptime

install -m 755 $RPM_SOURCE_DIR/rwhod.init ${RPM_BUILD_ROOT}/etc/rc.d/init.d/rwhod

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
/sbin/chkconfig --add rwhod

%preun
if [ $1 = 0 ]; then
    /sbin/chkconfig --del rwhod
fi

%files
%defattr(-,root,root)
%{_bindir}/ruptime
%{_mandir}/man1/ruptime.1*
%{_bindir}/rwho
%{_mandir}/man1/rwho.1*

%{_sbindir}/rwhod
%{_mandir}/man8/rwhod.8*
/var/spool/rwho
%config /etc/rc.d/init.d/rwhod

%changelog
* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed May 12 2004 Phil Knirsch <pknirsch@redhat.com> 0.17-21
- Enabled PIE for server and application.

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Wed Dec 11 2002 Tim Powers <timp@redhat.com> 0.17-17
- rebuild on all arches

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jun 19 2002 Phil Knirsch <pknirsch@redhat.com> 0.17-15
- Don't forcibly strip binaries

* Tue Jun 04 2002 Phil Knirsch <pknirsch@redhat.com>
- bumped release number and rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Apr  4 2001 Jakub Jelinek <jakub@redhat.com>
- don't let configure to guess compiler, it can pick up egcs

* Tue Feb 13 2001 Preston Brown <pbrown@redhat.com>
- hostname was getting null terminated incorrectly.  fixed. (#27419)

* Mon Feb  5 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- i18nize init script (#26083)

* Fri Feb  2 2001 Preston Brown <pbrown@redhat.com>
- don't bcast on virtual interfaces (#20435).  Patch from dwagoner@interTrust.com; thanks.

* Wed Dec 27 2000 Jeff Johnson <jhbj@redhat.com>
- use glibc's <protocols/rwhod.h>, internal version broken on alpha (#22014).

* Thu Aug 10 2000 Bill Nottingham <notting@redhat.com>
- fix broken init script

* Sat Aug 05 2000 Bill Nottingham <notting@redhat.com>
- condrestart fixes

* Thu Jul 20 2000 Bill Nottingham <notting@redhat.com>
- move initscript back

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Mon Jul 10 2000 Preston Brown <pbrown@redhat.com>
- move initscript

* Sun Jun 18 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.
- update to 0.17.

* Mon Feb  7 2000 Jeff Johnson <jbj@redhat.com>
- compress man pages.

* Tue Dec 21 1999 Jeff Johnson <jbj@redhat.com>
- update to 0.16.

* Thu Sep 09 1999 Preston Brown <pbrown@redhat.com>
- postun should have been preun.

* Thu Aug 26 1999 Jeff Johnson <jbj@redhat.com>
- fix unaligned trap on alpha.
- update to 0.15.

* Mon Aug 16 1999 Bill Nottingham <notting@redhat.com>
- initscript munging

* Fri Apr  9 1999 Jeff Johnson <jbj@redhat.com>
- add ruptime (#2023)

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 22)

* Mon Mar 15 1999 Jeff Johnson <jbj@redhat.com>
- compile for 6.0.

* Tue May 05 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Sat May 02 1998 Cristian Gafton <gafton@redhat.com>
- enhanced initscripts

* Mon Nov 03 1997 Donnie Barnes <djb@redhat.com>
- added /var/spool/rwho

* Fri Oct 31 1997 Donnie Barnes <djb@redhat.com>
- fixed init script

* Tue Oct 21 1997 Erik Troan <ewt@redhat.com>
- added an init script
- uses chkconfig
- uses %attr tags

* Tue Jul 15 1997 Erik Troan <ewt@redhat.com>
- initial build
