'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) extfileselectionbox.n 1.21 94/12/17 16:04:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.HS iwidgets::extfileselectionbox iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::extfileselectionbox \- Create and manipulate a file selection box widget
.SH SYNOPSIS
\fBiwidgets::extfileselectionbox\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- iwidgets::Extfileselectionbox
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
activeBackground   background         borderWidth         cursor
foreground         highlightColor     highlightThickness  insertBackground
insertBorderWidth  insertOffTime      insertOnTime        insertWidth
selectBackground   selectBorderWidth  selectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBpopupCursor\fR	\fBtextBackground\fR	\fBtextFont\fR
.fi
.LP
See the "combobox" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelFont\fR
.fi
.LP
See the "labeledwidget" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBsashCursor\fR
.fi
.LP
See the "panedwindow" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget class manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBtextBackground\fR	\fBtextFont\fR
.fi
.LP
See the "scrolledlistbox" widget manual entry for details on the above
associated options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBautomount\fR
Class:	\fBAutomount\fR
Command-Line Switch:	\fB-automount\fR
.fi
.IP
Specifies a list of directory prefixes to ignore. Typically, this
option would be used as follows:
    -automount {export tmp_mnt}
.LP
.nf
Name:	\fBchildSitePos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-childsitepos\fR
.fi
.IP
Specifies the position of the child site in the extended fileselection 
box: \fBn\fR, \fBs\fR, \fBe\fR, \fBw\fR, \fBtop\fR, or \fBbottom\fR.  
The default is s.
.LP
.nf
Name:	\fBdirectory\fR
Class:	\fBDirectory\fR
Command-Line Switch:	\fB-directory\fR
.fi
.IP
Specifies the initial default directory.  The default is the present 
working directory.
.LP
.nf
Name:	\fBdirSearchCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-dirsearchcommand\fR
.fi
.IP
Specifies a Tcl command to be executed to perform a directory search.
The command will receive the current working directory and filter
mask as arguments.  The command should return a list of files which
will be placed into the directory list.
.LP
.nf
Name:	\fBdirsLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-dirslabel\fR
.fi
.IP
Specifies the text of the label for the directory list.  The default is
"Directories".
.LP
.nf
Name:	\fBdirsOn\fR
Class:	\fBDirsOn\fR
Command-Line Switch:	\fB-dirson\fR
.fi
.IP
Specifies whether or not to display the directory list.  The
value may be given in any of the forms acceptable to \fBTcl_GetBoolean\fR.
The default is true.
.LP
.nf
Name:	\fBfileSearchCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-filesearchcommand\fR
.fi
.IP
Specifies a Tcl command to be executed to perform a file search.
The command will receive the current working directory and filter
mask as arguments.  The command should return a list of files which
will be placed into the file list.
.LP
.nf
Name:	\fBfilesLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-fileslabel\fR
.fi
.IP
Specifies the text of the label for the files list.  The default is "Files".
.LP
.nf
Name:	\fBfilesOn\fR
Class:	\fBFilesOn\fR
Command-Line Switch:	\fB-fileson\fR
.fi
.IP
Specifies whether or not to display the files list.  The
value may be given in any of the forms acceptable to \fBTcl_GetBoolean\fR.
The default is true.
.LP
.nf
Name:	\fBfileType\fR
Class:	\fBFileType\fR
Command-Line Switch:	\fB-filetype\fR
.fi
.IP
Specify the type of files which may appear in the file list: \fBregular\fR,
\fBdirectory\fR, or \fBany\fR.  The default is regular.
.LP
.nf
Name:	\fBfilterCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-filtercommand\fR
.fi
.IP
Specifies a Tcl command to be executed upon hitting the Return key
in the filter combobox widget.  
.LP
.nf
Name:	\fBfilterLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-filterlabel\fR
.fi
.IP
Specifies the text of the label for the filter combobox.  The default is
"Filter".
.LP
.nf
Name:	\fBfilterOn\fR
Class:	\fBFilterOn\fR
Command-Line Switch:	\fB-filteron\fR
.fi
.IP
Specifies whether or not to display the filter combobox.  The
value may be given in any of the forms acceptable to \fBTcl_GetBoolean\fR.
The default is true.
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the height of the selection box.  The value may be specified in 
any of the forms acceptable to Tk_GetPixels.  The default is 300 pixels.
.LP
.nf
Name:	\fBinvalid\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-invalid\fR
.fi
.IP
Command to be executed should the filter contents be proven 
invalid.  The default is {bell}.
.LP
.nf
Name:	\fBmask\fR
Class:	\fBMask\fR
Command-Line Switch:	\fB-mask\fR
.fi
.IP
Specifies the initial file mask string.  The default is "*".
.LP
.nf
Name:	\fBnoMatchString\fR
Class:	\fBNoMatchString\fR
Command-Line Switch:	\fB-nomatchstring\fR
.fi
.IP
Specifies the string to be displayed in the files list should no files
match the mask.  The default is "".
.LP
.nf
Name:	\fBselectDirCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-selectdirommand\fR
.fi
.IP
Specifies a Tcl command to be executed following selection of a 
directory in the directory list.
.LP
.nf
Name:	\fBselectFileCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-selectfileommand\fR
.fi
.IP
Specifies a Tcl command to be executed following selection of a 
file in the files list.
.LP
.nf
Name:	\fBselectionCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-selectioncommand\fR
.fi
.IP
Specifies a Tcl command to be executed upon hitting the Return key
in the selection combobox widget.  
.LP
.nf
Name:	\fBselectionLabel\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-selectionlabel\fR
.fi
.IP
Specifies the text of the label for the selection combobox.  The default
is "Selection".
.LP
.nf
Name:	\fBselectionOn\fR
Class:	\fBSelectionOn\fR
Command-Line Switch:	\fB-selectionon\fR
.fi
.IP
Specifies whether or not to display the selection combobox.  The
value may be given in any of the forms acceptable to \fBTcl_GetBoolean\fR.
The default is true.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the width of the selection box.  The value may be specified in 
any of the forms acceptable to Tk_GetPixels.  The default is 350 pixels.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::extfileselectionbox\fR command creates an extended file 
selection box which is slightly different than the fileselectionbox widget.
The differences are mostly cosmetic in that the listboxes are 
within a panedwindow and the entryfields for the filter and selection
have been replaced by comboboxes.  Other than that the interface is
practically the same.

.SH "METHODS"
.PP
The \fBiwidgets::extfileselectionbox\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for extfileselectionbox widgets:

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::extfileselectionbox\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the child site widget path name.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::extfileselectionbox\fR
command.
.TP
\fIpathName \fBfilter\fR
Update the current contents of the extended file selection box based 
on the current filter combobox value.
.TP
\fIpathName \fBget\fR
Returns the current value of the selection combobox widget.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBdirs\fR
Class:	\fBScrolledlistbox\fR
.fi
.IP
The dirs component is the directory list box for the extended fileselection 
box. See the "scrolledlistbox" widget manual entry for details on the dirs 
component item.
.LP
.nf
Name:	\fBfiles\fR
Class:	\fBScrolledlistbox\fR
.fi
.IP
The files component is the file list box for the extended fileselection box.
See the "scrolledlistbox" widget manual entry for details on the files
component item.
.LP
.nf
Name:	\fBfilter\fR
Class:	\fBCombobox\fR
.fi
.IP
The filter component is the field for user input of the filter value.
See the "combobox" widget manual entry for details on the filter 
component item.
.LP
.nf
Name:	\fBselection\fR
Class:	\fBCombobox\fR
.fi
.IP
The selection component is the field for user input of the currently
selected file value.  See the "combobox" widget manual entry for details 
on the selection component item.
.fi

.SH EXAMPLE
.DS
package require Iwidgets 4.0
iwidgets::extfileselectionbox .fsb
pack .fsb -padx 10 -pady 10 -fill both -expand yes 
.DE
.SH AUTHOR(S)
Mark L. Ulferts
.DE
Anthony Parent
.SH KEYWORDS
extfileselectionbox, widget
