/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of IO.xs. Do not edit this file, edit IO.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "IO.xs"
/*
 * Copyright (c) 1997-8 Graham Barr <gbarr@pobox.com>. All rights reserved.
 * This program is free software; you can redistribute it and/or
 * modify it under the same terms as Perl itself.
 */

#define PERL_EXT_IO

#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#define PERLIO_NOT_STDIO 1
#include "perl.h"
#include "XSUB.h"
#include "poll.h"
#ifdef I_UNISTD
#  include <unistd.h>
#endif
#if defined(I_FCNTL) || defined(HAS_FCNTL)
#  include <fcntl.h>
#endif

#ifndef SIOCATMARK
#   ifdef I_SYS_SOCKIO
#       include <sys/sockio.h>
#   endif
#endif

#ifdef PerlIO
#if defined(MACOS_TRADITIONAL) && defined(USE_SFIO)
#define PERLIO_IS_STDIO 1
#undef setbuf
#undef setvbuf
#define setvbuf		_stdsetvbuf
#define setbuf(f,b)	( __sf_setbuf(f,b) )
#endif
typedef int SysRet;
typedef PerlIO * InputStream;
typedef PerlIO * OutputStream;
#else
#define PERLIO_IS_STDIO 1
typedef int SysRet;
typedef FILE * InputStream;
typedef FILE * OutputStream;
#endif

#define MY_start_subparse(fmt,flags) start_subparse(fmt,flags)

#ifndef gv_stashpvn
#define gv_stashpvn(str,len,flags) gv_stashpv(str,flags)
#endif

static int
not_here(char *s)
{
    croak("%s not implemented on this architecture", s);
    return -1;
}


#ifndef PerlIO
#define PerlIO_fileno(f) fileno(f)
#endif

static int
io_blocking(pTHX_ InputStream f, int block)
{
#if defined(HAS_FCNTL)
    int RETVAL;
    if(!f) {
	errno = EBADF;
	return -1;
    }
    RETVAL = fcntl(PerlIO_fileno(f), F_GETFL, 0);
    if (RETVAL >= 0) {
	int mode = RETVAL;
#ifdef O_NONBLOCK
	/* POSIX style */
#if defined(O_NDELAY) && O_NDELAY != O_NONBLOCK
	/* Ooops has O_NDELAY too - make sure we don't
	 * get SysV behaviour by mistake. */

	/* E.g. In UNICOS and UNICOS/mk a F_GETFL returns an O_NDELAY
	 * after a successful F_SETFL of an O_NONBLOCK. */
	RETVAL = RETVAL & (O_NONBLOCK | O_NDELAY) ? 0 : 1;

	if (block >= 0) {
	    if ((mode & O_NDELAY) || ((block == 0) && !(mode & O_NONBLOCK))) {
	        int ret;
	        mode = (mode & ~O_NDELAY) | O_NONBLOCK;
	        ret = fcntl(PerlIO_fileno(f),F_SETFL,mode);
	        if(ret < 0)
		    RETVAL = ret;
	    }
	    else
              if ((mode & O_NDELAY) || ((block > 0) && (mode & O_NONBLOCK))) {
	        int ret;
	        mode &= ~(O_NONBLOCK | O_NDELAY);
	        ret = fcntl(PerlIO_fileno(f),F_SETFL,mode);
	        if(ret < 0)
		    RETVAL = ret;
              }
	}
#else
	/* Standard POSIX */
	RETVAL = RETVAL & O_NONBLOCK ? 0 : 1;

	if ((block == 0) && !(mode & O_NONBLOCK)) {
	    int ret;
	    mode |= O_NONBLOCK;
	    ret = fcntl(PerlIO_fileno(f),F_SETFL,mode);
	    if(ret < 0)
		RETVAL = ret;
	 }
	else if ((block > 0) && (mode & O_NONBLOCK)) {
	    int ret;
	    mode &= ~O_NONBLOCK;
	    ret = fcntl(PerlIO_fileno(f),F_SETFL,mode);
	    if(ret < 0)
		RETVAL = ret;
	 }
#endif
#else
	/* Not POSIX - better have O_NDELAY or we can't cope.
	 * for BSD-ish machines this is an acceptable alternative
	 * for SysV we can't tell "would block" from EOF but that is
	 * the way SysV is...
	 */
	RETVAL = RETVAL & O_NDELAY ? 0 : 1;

	if ((block == 0) && !(mode & O_NDELAY)) {
	    int ret;
	    mode |= O_NDELAY;
	    ret = fcntl(PerlIO_fileno(f),F_SETFL,mode);
	    if(ret < 0)
		RETVAL = ret;
	 }
	else if ((block > 0) && (mode & O_NDELAY)) {
	    int ret;
	    mode &= ~O_NDELAY;
	    ret = fcntl(PerlIO_fileno(f),F_SETFL,mode);
	    if(ret < 0)
		RETVAL = ret;
	 }
#endif
    }
    return RETVAL;
#else
    return -1;
#endif
}

#line 162 "IO.c"
XS(XS_IO__Seekable_getpos); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Seekable_getpos)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: IO::Seekable::getpos(handle)");
    {
	InputStream	handle = IoIFP(sv_2io(ST(0)));
#line 158 "IO.xs"
	if (handle) {
#ifdef PerlIO
	    ST(0) = sv_2mortal(newSV(0));
	    if (PerlIO_getpos(handle, ST(0)) != 0) {
		ST(0) = &PL_sv_undef;
	    }
#else
	    if (fgetpos(handle, &pos)) {
		ST(0) = &PL_sv_undef;
	    } else {
		ST(0) = sv_2mortal(newSVpv((char*)&pos, sizeof(Fpos_t)));
	    }
#endif
	}
	else {
	    ST(0) = &PL_sv_undef;
	    errno = EINVAL;
	}
#line 190 "IO.c"
    }
    XSRETURN(1);
}

XS(XS_IO__Seekable_setpos); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Seekable_setpos)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: IO::Seekable::setpos(handle, pos)");
    {
	InputStream	handle = IoIFP(sv_2io(ST(0)));
	SV *	pos = ST(1);
	SysRet	RETVAL;
#line 182 "IO.xs"
	if (handle) {
#ifdef PerlIO
	    RETVAL = PerlIO_setpos(handle, pos);
#else
	    char *p;
	    STRLEN len;
	    if ((p = SvPV(pos,len)) && len == sizeof(Fpos_t)) {
		RETVAL = fsetpos(handle, (Fpos_t*)p);
	    }
	    else {
		RETVAL = -1;
		errno = EINVAL;
	    }
#endif
	}
	else {
	    RETVAL = -1;
	    errno = EINVAL;
	}
#line 225 "IO.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_IO__File_new_tmpfile); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__File_new_tmpfile)
{
    dXSARGS;
    if (items < 0 || items > 1)
	Perl_croak(aTHX_ "Usage: IO::File::new_tmpfile(packname = \"IO::File\")");
    {
	char *	packname;
#line 210 "IO.xs"
	OutputStream fp;
	GV *gv;
#line 248 "IO.c"

	if (items < 1)
	    packname = "IO::File";
	else {
	    packname = (char *)SvPV_nolen(ST(0));
	}
#line 213 "IO.xs"
#ifdef PerlIO
	fp = PerlIO_tmpfile();
#else
	fp = tmpfile();
#endif
	gv = (GV*)SvREFCNT_inc(newGVgen(packname));
	hv_delete(GvSTASH(gv), GvNAME(gv), GvNAMELEN(gv), G_DISCARD);
	if (do_open(gv, "+>&", 3, FALSE, 0, 0, fp)) {
	    ST(0) = sv_2mortal(newRV((SV*)gv));
	    sv_bless(ST(0), gv_stashpv(packname, TRUE));
	    SvREFCNT_dec(gv);   /* undo increment in newRV() */
	}
	else {
	    ST(0) = &PL_sv_undef;
	    SvREFCNT_dec(gv);
	}
#line 272 "IO.c"
    }
    XSRETURN(1);
}

XS(XS_IO__Poll__poll); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Poll__poll)
{
    dXSARGS;
    if (items < 1)
	Perl_croak(aTHX_ "Usage: IO::Poll::_poll(timeout, ...)");
    SP -= items;
    {
	int	timeout = (int)SvIV(ST(0));
#line 236 "IO.xs"
{
#ifdef HAS_POLL
    int nfd = (items - 1) / 2;
    SV *tmpsv = NEWSV(999,nfd * sizeof(struct pollfd));
    struct pollfd *fds = (struct pollfd *)SvPVX(tmpsv);
    int i,j,ret;
    for(i=1, j=0  ; j < nfd ; j++) {
	fds[j].fd = SvIV(ST(i));
	i++;
	fds[j].events = (short)SvIV(ST(i));
	i++;
	fds[j].revents = 0;
    }
    if((ret = poll(fds,nfd,timeout)) >= 0) {
	for(i=1, j=0 ; j < nfd ; j++) {
	    sv_setiv(ST(i), fds[j].fd); i++;
	    sv_setiv(ST(i), fds[j].revents); i++;
	}
    }
    SvREFCNT_dec(tmpsv);
    XSRETURN_IV(ret);
#else
	not_here("IO::Poll::poll");
#endif
}
#line 312 "IO.c"
	PUTBACK;
	return;
    }
}

XS(XS_IO__Handle_blocking); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Handle_blocking)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: IO::Handle::blocking(handle, blk=-1)");
    {
	InputStream	handle = IoIFP(sv_2io(ST(0)));
	int	blk;

	if (items < 2)
	    blk = -1;
	else {
	    blk = (int)SvIV(ST(1));
	}
#line 270 "IO.xs"
{
    int ret = io_blocking(aTHX_ handle, items == 1 ? -1 : blk ? 1 : 0);
    if(ret >= 0)
	XSRETURN_IV(ret);
    else
	XSRETURN_UNDEF;
}
#line 341 "IO.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_IO__Handle_ungetc); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Handle_ungetc)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: IO::Handle::ungetc(handle, c)");
    {
	InputStream	handle = IoIFP(sv_2io(ST(0)));
	int	c = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 285 "IO.xs"
	if (handle)
#ifdef PerlIO
	    RETVAL = PerlIO_ungetc(handle, c);
#else
	    RETVAL = ungetc(c, handle);
#endif
	else {
	    RETVAL = -1;
	    errno = EINVAL;
	}
#line 368 "IO.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_IO__Handle_error); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Handle_error)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: IO::Handle::error(handle)");
    {
	InputStream	handle = IoIFP(sv_2io(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 302 "IO.xs"
	if (handle)
#ifdef PerlIO
	    RETVAL = PerlIO_error(handle);
#else
	    RETVAL = ferror(handle);
#endif
	else {
	    RETVAL = -1;
	    errno = EINVAL;
	}
#line 395 "IO.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_IO__Handle_clearerr); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Handle_clearerr)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: IO::Handle::clearerr(handle)");
    {
	InputStream	handle = IoIFP(sv_2io(ST(0)));
	int	RETVAL;
	dXSTARG;
#line 319 "IO.xs"
	if (handle) {
#ifdef PerlIO
	    PerlIO_clearerr(handle);
#else
	    clearerr(handle);
#endif
	    RETVAL = 0;
	}
	else {
	    RETVAL = -1;
	    errno = EINVAL;
	}
#line 424 "IO.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_IO__Handle_untaint); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Handle_untaint)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: IO::Handle::untaint(handle)");
    {
	SV *	handle = ST(0);
	int	RETVAL;
	dXSTARG;
#line 338 "IO.xs"
#ifdef IOf_UNTAINT
	IO * io;
	io = sv_2io(handle);
	if (io) {
	    IoFLAGS(io) |= IOf_UNTAINT;
	    RETVAL = 0;
	}
        else {
#endif
	    RETVAL = -1;
	    errno = EINVAL;
#ifdef IOf_UNTAINT
	}
#endif
#line 455 "IO.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_IO__Handle_flush); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Handle_flush)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: IO::Handle::flush(handle)");
    {
	OutputStream	handle = IoOFP(sv_2io(ST(0)));
	SysRet	RETVAL;
#line 359 "IO.xs"
	if (handle)
#ifdef PerlIO
	    RETVAL = PerlIO_flush(handle);
#else
	    RETVAL = Fflush(handle);
#endif
	else {
	    RETVAL = -1;
	    errno = EINVAL;
	}
#line 481 "IO.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_IO__Handle_setbuf); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Handle_setbuf)
{
    dXSARGS;
    if (items < 1)
	Perl_croak(aTHX_ "Usage: IO::Handle::setbuf(handle, ...)");
    {
	OutputStream	handle = IoOFP(sv_2io(ST(0)));
#line 376 "IO.xs"
	if (handle)
#ifdef PERLIO_IS_STDIO
        {
	    char *buf = items == 2 && SvPOK(ST(1)) ?
	      sv_grow(ST(1), BUFSIZ) : 0;
	    setbuf(handle, buf);
	}
#else
	    not_here("IO::Handle::setbuf");
#endif
#line 512 "IO.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_IO__Handle_setvbuf); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Handle_setvbuf)
{
    dXSARGS;
    {
	SysRet	RETVAL;
#line 390 "IO.xs"
	if (items != 4)
            Perl_croak(aTHX_ "Usage: IO::Handle::setvbuf(handle, buf, type, size)");
#if defined(PERLIO_IS_STDIO) && defined(_IOFBF) && defined(HAS_SETVBUF)
    {
        OutputStream	handle = 0;
	char *		buf = SvPOK(ST(1)) ? sv_grow(ST(1), SvIV(ST(3))) : 0;
	int		type;
	int		size;

	if (items == 4) {
	    handle = IoOFP(sv_2io(ST(0)));
	    buf    = SvPOK(ST(1)) ? sv_grow(ST(1), SvIV(ST(3))) : 0;
	    type   = (int)SvIV(ST(2));
	    size   = (int)SvIV(ST(3));
	}
	if (!handle)			/* Try input stream. */
	    handle = IoIFP(sv_2io(ST(0)));
	if (items == 4 && handle)
	    RETVAL = setvbuf(handle, buf, type, size);
	else {
	    RETVAL = -1;
	    errno = EINVAL;
	}
    }
#else
	RETVAL = (SysRet) not_here("IO::Handle::setvbuf");
#endif
#line 551 "IO.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_IO__Handle_sync); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Handle_sync)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: IO::Handle::sync(handle)");
    {
	OutputStream	handle = IoOFP(sv_2io(ST(0)));
	SysRet	RETVAL;
#line 425 "IO.xs"
#ifdef HAS_FSYNC
	if(handle)
	    RETVAL = fsync(PerlIO_fileno(handle));
	else {
	    RETVAL = -1;
	    errno = EINVAL;
	}
#else
	RETVAL = (SysRet) not_here("IO::Handle::sync");
#endif
#line 583 "IO.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_IO__Socket_sockatmark); /* prototype to pass -Wmissing-prototypes */
XS(XS_IO__Socket_sockatmark)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: IO::Socket::sockatmark(sock)");
    {
	InputStream	sock = IoIFP(sv_2io(ST(0)));
#line 446 "IO.xs"
     int fd;
#line 605 "IO.c"
	SysRet	RETVAL;
#line 448 "IO.xs"
   {
     fd = PerlIO_fileno(sock);
#ifdef HAS_SOCKATMARK
     RETVAL = sockatmark(fd);
#else
     {
       int flag = 0;
#   ifdef SIOCATMARK
#     if defined(NETWARE) || defined(WIN32)
       if (ioctl(fd, SIOCATMARK, (void*)&flag) != 0)
#     else
       if (ioctl(fd, SIOCATMARK, &flag) != 0)
#     endif
	 XSRETURN_UNDEF;
#   else
       not_here("IO::Socket::atmark");
#   endif
       RETVAL = flag;
     }
#endif
   }
#line 629 "IO.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_IO); /* prototype to pass -Wmissing-prototypes */
XS(boot_IO)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("IO::Seekable::getpos", XS_IO__Seekable_getpos, file);
        newXS("IO::Seekable::setpos", XS_IO__Seekable_setpos, file);
        newXS("IO::File::new_tmpfile", XS_IO__File_new_tmpfile, file);
        newXS("IO::Poll::_poll", XS_IO__Poll__poll, file);
        newXSproto("IO::Handle::blocking", XS_IO__Handle_blocking, file, "$;$");
        newXS("IO::Handle::ungetc", XS_IO__Handle_ungetc, file);
        newXS("IO::Handle::error", XS_IO__Handle_error, file);
        newXS("IO::Handle::clearerr", XS_IO__Handle_clearerr, file);
        newXS("IO::Handle::untaint", XS_IO__Handle_untaint, file);
        newXS("IO::Handle::flush", XS_IO__Handle_flush, file);
        newXS("IO::Handle::setbuf", XS_IO__Handle_setbuf, file);
        newXS("IO::Handle::setvbuf", XS_IO__Handle_setvbuf, file);
        newXS("IO::Handle::sync", XS_IO__Handle_sync, file);
        newXSproto("IO::Socket::sockatmark", XS_IO__Socket_sockatmark, file, "$");

    /* Initialisation Section */

#line 473 "IO.xs"
{
    HV *stash;
    /*
     * constant subs for IO::Poll
     */
    stash = gv_stashpvn("IO::Poll", 8, TRUE);
#ifdef	POLLIN
	newCONSTSUB(stash,"POLLIN",newSViv(POLLIN));
#endif
#ifdef	POLLPRI
        newCONSTSUB(stash,"POLLPRI", newSViv(POLLPRI));
#endif
#ifdef	POLLOUT
        newCONSTSUB(stash,"POLLOUT", newSViv(POLLOUT));
#endif
#ifdef	POLLRDNORM
        newCONSTSUB(stash,"POLLRDNORM", newSViv(POLLRDNORM));
#endif
#ifdef	POLLWRNORM
        newCONSTSUB(stash,"POLLWRNORM", newSViv(POLLWRNORM));
#endif
#ifdef	POLLRDBAND
        newCONSTSUB(stash,"POLLRDBAND", newSViv(POLLRDBAND));
#endif
#ifdef	POLLWRBAND
        newCONSTSUB(stash,"POLLWRBAND", newSViv(POLLWRBAND));
#endif
#ifdef	POLLNORM
        newCONSTSUB(stash,"POLLNORM", newSViv(POLLNORM));
#endif
#ifdef	POLLERR
        newCONSTSUB(stash,"POLLERR", newSViv(POLLERR));
#endif
#ifdef	POLLHUP
        newCONSTSUB(stash,"POLLHUP", newSViv(POLLHUP));
#endif
#ifdef	POLLNVAL
        newCONSTSUB(stash,"POLLNVAL", newSViv(POLLNVAL));
#endif
    /*
     * constant subs for IO::Handle
     */
    stash = gv_stashpvn("IO::Handle", 10, TRUE);
#ifdef _IOFBF
        newCONSTSUB(stash,"_IOFBF", newSViv(_IOFBF));
#endif
#ifdef _IOLBF
        newCONSTSUB(stash,"_IOLBF", newSViv(_IOLBF));
#endif
#ifdef _IONBF
        newCONSTSUB(stash,"_IONBF", newSViv(_IONBF));
#endif
#ifdef SEEK_SET
        newCONSTSUB(stash,"SEEK_SET", newSViv(SEEK_SET));
#endif
#ifdef SEEK_CUR
        newCONSTSUB(stash,"SEEK_CUR", newSViv(SEEK_CUR));
#endif
#ifdef SEEK_END
        newCONSTSUB(stash,"SEEK_END", newSViv(SEEK_END));
#endif
}

#line 733 "IO.c"

    /* End of Initialisation Section */

    XSRETURN_YES;
}

