/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of POSIX.xs. Do not edit this file, edit POSIX.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "POSIX.xs"
#define PERL_EXT_POSIX

#ifdef NETWARE
	#define _POSIX_
	/*
	 * Ideally this should be somewhere down in the includes
	 * but putting it in other places is giving compiler errors.
	 * Also here I am unable to check for HAS_UNAME since it wouldn't have
	 * yet come into the file at this stage - sgp 18th Oct 2000
	 */
	#include <sys/utsname.h>
#endif	/* NETWARE */

#define PERL_NO_GET_CONTEXT

#include "EXTERN.h"
#define PERLIO_NOT_STDIO 1
#include "perl.h"
#include "XSUB.h"
#if defined(PERL_IMPLICIT_SYS)
#  undef signal
#  undef open
#  undef setmode
#  define open PerlLIO_open3
#endif
#include <ctype.h>
#ifdef I_DIRENT    /* XXX maybe better to just rely on perl.h? */
#include <dirent.h>
#endif
#include <errno.h>
#ifdef I_FLOAT
#include <float.h>
#endif
#ifdef I_LIMITS
#include <limits.h>
#endif
#include <locale.h>
#include <math.h>
#ifdef I_PWD
#include <pwd.h>
#endif
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>

#ifdef I_STDDEF
#include <stddef.h>
#endif

#ifdef I_UNISTD
#include <unistd.h>
#endif

/* XXX This comment is just to make I_TERMIO and I_SGTTY visible to 
   metaconfig for future extension writers.  We don't use them in POSIX.
   (This is really sneaky :-)  --AD
*/
#if defined(I_TERMIOS)
#include <termios.h>
#endif
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#ifndef __ultrix__
#include <string.h>
#endif
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#ifdef I_UNISTD
#include <unistd.h>
#endif
#ifdef MACOS_TRADITIONAL
#undef fdopen
#endif
#include <fcntl.h>

#ifdef HAS_TZNAME
#  if !defined(WIN32) && !defined(__CYGWIN__) && !defined(NETWARE) && !defined(__UWIN__)
extern char *tzname[];
#  endif
#else
#if !defined(WIN32) && !defined(__UWIN__) || (defined(__MINGW32__) && !defined(tzname))
char *tzname[] = { "" , "" };
#endif
#endif

#if defined(__VMS) && !defined(__POSIX_SOURCE)
#  include <libdef.h>       /* LIB$_INVARG constant */
#  include <lib$routines.h> /* prototype for lib$ediv() */
#  include <starlet.h>      /* prototype for sys$gettim() */
#  if DECC_VERSION < 50000000
#    define pid_t int       /* old versions of DECC miss this in types.h */
#  endif

#  undef mkfifo
#  define mkfifo(a,b) (not_here("mkfifo"),-1)
#  define tzset() not_here("tzset")

#if ((__VMS_VER >= 70000000) && (__DECC_VER >= 50200000)) || (__CRTL_VER >= 70000000)
#    define HAS_TZNAME  /* shows up in VMS 7.0 or Dec C 5.6 */
#    include <utsname.h>
#  endif /* __VMS_VER >= 70000000 or Dec C 5.6 */

   /* The POSIX notion of ttyname() is better served by getname() under VMS */
   static char ttnambuf[64];
#  define ttyname(fd) (isatty(fd) > 0 ? getname(fd,ttnambuf,0) : NULL)

   /* The non-POSIX CRTL times() has void return type, so we just get the
      current time directly */
   clock_t vms_times(struct tms *bufptr) {
	dTHX;
	clock_t retval;
	/* Get wall time and convert to 10 ms intervals to
	 * produce the return value that the POSIX standard expects */
#  if defined(__DECC) && defined (__ALPHA)
#    include <ints.h>
	uint64 vmstime;
	_ckvmssts(sys$gettim(&vmstime));
	vmstime /= 100000;
	retval = vmstime & 0x7fffffff;
#  else
	/* (Older hw or ccs don't have an atomic 64-bit type, so we
	 * juggle 32-bit ints (and a float) to produce a time_t result
	 * with minimal loss of information.) */
	long int vmstime[2],remainder,divisor = 100000;
	_ckvmssts(sys$gettim((unsigned long int *)vmstime));
	vmstime[1] &= 0x7fff;  /* prevent overflow in EDIV */
	_ckvmssts(lib$ediv(&divisor,vmstime,(long int *)&retval,&remainder));
#  endif
	/* Fill in the struct tms using the CRTL routine . . .*/
	times((tbuffer_t *)bufptr);
	return (clock_t) retval;
   }
#  define times(t) vms_times(t)
#else
#if defined (__CYGWIN__)
#    define tzname _tzname
#endif
#if defined (WIN32) || defined (NETWARE)
#  undef mkfifo
#  define mkfifo(a,b) not_here("mkfifo")
#  define ttyname(a) (char*)not_here("ttyname")
#  define sigset_t long
#  define pid_t long
#  ifdef __BORLANDC__
#    define tzname _tzname
#  endif
#  ifdef _MSC_VER
#    define mode_t short
#  endif
#  ifdef __MINGW32__
#    define mode_t short
#    ifndef tzset
#      define tzset()		not_here("tzset")
#    endif
#    ifndef _POSIX_OPEN_MAX
#      define _POSIX_OPEN_MAX	FOPEN_MAX	/* XXX bogus ? */
#    endif
#  endif
#  define sigaction(a,b,c)	not_here("sigaction")
#  define sigpending(a)		not_here("sigpending")
#  define sigprocmask(a,b,c)	not_here("sigprocmask")
#  define sigsuspend(a)		not_here("sigsuspend")
#  define sigemptyset(a)	not_here("sigemptyset")
#  define sigaddset(a,b)	not_here("sigaddset")
#  define sigdelset(a,b)	not_here("sigdelset")
#  define sigfillset(a)		not_here("sigfillset")
#  define sigismember(a,b)	not_here("sigismember")
#ifndef NETWARE
#  undef setuid
#  undef setgid
#  define setuid(a)		not_here("setuid")
#  define setgid(a)		not_here("setgid")
#endif	/* NETWARE */
#else

#  ifndef HAS_MKFIFO
#    if defined(OS2) || defined(MACOS_TRADITIONAL)
#      define mkfifo(a,b) not_here("mkfifo")
#    else	/* !( defined OS2 ) */ 
#      ifndef mkfifo
#        define mkfifo(path, mode) (mknod((path), (mode) | S_IFIFO, 0))
#      endif
#    endif
#  endif /* !HAS_MKFIFO */

#  ifdef MACOS_TRADITIONAL
#    define ttyname(a) (char*)not_here("ttyname")
#    define tzset() not_here("tzset")
#  else
#    include <grp.h>
#    include <sys/times.h>
#    ifdef HAS_UNAME
#      include <sys/utsname.h>
#    endif
#    include <sys/wait.h>
#  endif
#  ifdef I_UTIME
#    include <utime.h>
#  endif
#endif /* WIN32 || NETWARE */
#endif /* __VMS */

typedef int SysRet;
typedef long SysRetLong;
typedef sigset_t* POSIX__SigSet;
typedef HV* POSIX__SigAction;
#ifdef I_TERMIOS
typedef struct termios* POSIX__Termios;
#else /* Define termios types to int, and call not_here for the functions.*/
#define POSIX__Termios int
#define speed_t int
#define tcflag_t int
#define cc_t int
#define cfgetispeed(x) not_here("cfgetispeed")
#define cfgetospeed(x) not_here("cfgetospeed")
#define tcdrain(x) not_here("tcdrain")
#define tcflush(x,y) not_here("tcflush")
#define tcsendbreak(x,y) not_here("tcsendbreak")
#define cfsetispeed(x,y) not_here("cfsetispeed")
#define cfsetospeed(x,y) not_here("cfsetospeed")
#define ctermid(x) (char *) not_here("ctermid")
#define tcflow(x,y) not_here("tcflow")
#define tcgetattr(x,y) not_here("tcgetattr")
#define tcsetattr(x,y,z) not_here("tcsetattr")
#endif

/* Possibly needed prototypes */
char *cuserid (char *);
#ifndef WIN32
double strtod (const char *, char **);
long strtol (const char *, char **, int);
unsigned long strtoul (const char *, char **, int);
#endif

#ifndef HAS_CUSERID
#define cuserid(a) (char *) not_here("cuserid")
#endif
#ifndef HAS_DIFFTIME
#ifndef difftime
#define difftime(a,b) not_here("difftime")
#endif
#endif
#ifndef HAS_FPATHCONF
#define fpathconf(f,n) 	(SysRetLong) not_here("fpathconf")
#endif
#ifndef HAS_MKTIME
#define mktime(a) not_here("mktime")
#endif
#ifndef HAS_NICE
#define nice(a) not_here("nice")
#endif
#ifndef HAS_PATHCONF
#define pathconf(f,n) 	(SysRetLong) not_here("pathconf")
#endif
#ifndef HAS_SYSCONF
#define sysconf(n) 	(SysRetLong) not_here("sysconf")
#endif
#ifndef HAS_READLINK
#define readlink(a,b,c) not_here("readlink")
#endif
#ifndef HAS_SETPGID
#define setpgid(a,b) not_here("setpgid")
#endif
#ifndef HAS_SETSID
#define setsid() not_here("setsid")
#endif
#ifndef HAS_STRCOLL
#define strcoll(s1,s2) not_here("strcoll")
#endif
#ifndef HAS_STRTOD
#define strtod(s1,s2) not_here("strtod")
#endif
#ifndef HAS_STRTOL
#define strtol(s1,s2,b) not_here("strtol")
#endif
#ifndef HAS_STRTOUL
#define strtoul(s1,s2,b) not_here("strtoul")
#endif
#ifndef HAS_STRXFRM
#define strxfrm(s1,s2,n) not_here("strxfrm")
#endif
#ifndef HAS_TCGETPGRP
#define tcgetpgrp(a) not_here("tcgetpgrp")
#endif
#ifndef HAS_TCSETPGRP
#define tcsetpgrp(a,b) not_here("tcsetpgrp")
#endif
#ifndef HAS_TIMES
#ifndef NETWARE
#define times(a) not_here("times")
#endif	/* NETWARE */
#endif
#ifndef HAS_UNAME
#define uname(a) not_here("uname")
#endif
#ifndef HAS_WAITPID
#define waitpid(a,b,c) not_here("waitpid")
#endif

#ifndef HAS_MBLEN
#ifndef mblen
#define mblen(a,b) not_here("mblen")
#endif
#endif
#ifndef HAS_MBSTOWCS
#define mbstowcs(s, pwcs, n) not_here("mbstowcs")
#endif
#ifndef HAS_MBTOWC
#define mbtowc(pwc, s, n) not_here("mbtowc")
#endif
#ifndef HAS_WCSTOMBS
#define wcstombs(s, pwcs, n) not_here("wcstombs")
#endif
#ifndef HAS_WCTOMB
#define wctomb(s, wchar) not_here("wcstombs")
#endif
#if !defined(HAS_MBLEN) && !defined(HAS_MBSTOWCS) && !defined(HAS_MBTOWC) && !defined(HAS_WCSTOMBS) && !defined(HAS_WCTOMB)
/* If we don't have these functions, then we wouldn't have gotten a typedef
   for wchar_t, the wide character type.  Defining wchar_t allows the
   functions referencing it to compile.  Its actual type is then meaningless,
   since without the above functions, all sections using it end up calling
   not_here() and croak.  --Kaveh Ghazi (ghazi@noc.rutgers.edu) 9/18/94. */
#ifndef wchar_t
#define wchar_t char
#endif
#endif

#ifndef HAS_LOCALECONV
#define localeconv() not_here("localeconv")
#endif

#ifdef HAS_LONG_DOUBLE
#  if LONG_DOUBLESIZE > NVSIZE
#    undef HAS_LONG_DOUBLE  /* XXX until we figure out how to use them */
#  endif
#endif

#ifndef HAS_LONG_DOUBLE
#ifdef LDBL_MAX
#undef LDBL_MAX
#endif
#ifdef LDBL_MIN
#undef LDBL_MIN
#endif
#ifdef LDBL_EPSILON
#undef LDBL_EPSILON
#endif
#endif

/* Background: in most systems the low byte of the wait status
 * is the signal (the lowest 7 bits) and the coredump flag is
 * the eight bit, and the second lowest byte is the exit status.
 * BeOS bucks the trend and has the bytes in different order.
 * See beos/beos.c for how the reality is bent even in BeOS
 * to follow the traditional.  However, to make the POSIX
 * wait W*() macros to work in BeOS, we need to unbend the
 * reality back in place. --jhi */
#ifdef __BEOS__
#    define WMUNGE(x) (((x) & 0xFF00) >> 8 | ((x) & 0x00FF) << 8)
#else
#    define WMUNGE(x) (x)
#endif

static int
not_here(char *s)
{
    croak("POSIX::%s not implemented on this architecture", s);
    return -1;
}

#include "const-c.inc"

/* These were implemented in the old "constant" subroutine. They are actually
   macros that take an integer argument and return an integer result.  */
static int
int_macro_int (const char *name, STRLEN len, IV *arg_result) {
  /* Initially switch on the length of the name.  */
  /* This code has been edited from a "constant" function generated by:

use ExtUtils::Constant qw (constant_types C_constant XS_constant);

my $types = {map {($_, 1)} qw(IV)};
my @names = (qw(S_ISBLK S_ISCHR S_ISDIR S_ISFIFO S_ISREG WEXITSTATUS WIFEXITED
	       WIFSIGNALED WIFSTOPPED WSTOPSIG WTERMSIG));

print constant_types(); # macro defs
foreach (C_constant ("POSIX", 'int_macro_int', 'IV', $types, undef, 5, @names) ) {
    print $_, "\n"; # C constant subs
}
print "#### XS Section:\n";
print XS_constant ("POSIX", $types);
__END__
   */

  switch (len) {
  case 7:
    /* Names all of length 7.  */
    /* S_ISBLK S_ISCHR S_ISDIR S_ISREG */
    /* Offset 5 gives the best switch position.  */
    switch (name[5]) {
    case 'E':
      if (memEQ(name, "S_ISREG", 7)) {
      /*                    ^       */
#ifdef S_ISREG
        *arg_result = S_ISREG(*arg_result);
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'H':
      if (memEQ(name, "S_ISCHR", 7)) {
      /*                    ^       */
#ifdef S_ISCHR
        *arg_result = S_ISCHR(*arg_result);
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'I':
      if (memEQ(name, "S_ISDIR", 7)) {
      /*                    ^       */
#ifdef S_ISDIR
        *arg_result = S_ISDIR(*arg_result);
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'L':
      if (memEQ(name, "S_ISBLK", 7)) {
      /*                    ^       */
#ifdef S_ISBLK
        *arg_result = S_ISBLK(*arg_result);
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    }
    break;
  case 8:
    /* Names all of length 8.  */
    /* S_ISFIFO WSTOPSIG WTERMSIG */
    /* Offset 3 gives the best switch position.  */
    switch (name[3]) {
    case 'O':
      if (memEQ(name, "WSTOPSIG", 8)) {
      /*                  ^          */
#ifdef WSTOPSIG
        int i = *arg_result;
        *arg_result = WSTOPSIG(WMUNGE(i));
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'R':
      if (memEQ(name, "WTERMSIG", 8)) {
      /*                  ^          */
#ifdef WTERMSIG
        int i = *arg_result;
        *arg_result = WTERMSIG(WMUNGE(i));
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'S':
      if (memEQ(name, "S_ISFIFO", 8)) {
      /*                  ^          */
#ifdef S_ISFIFO
        *arg_result = S_ISFIFO(*arg_result);
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    }
    break;
  case 9:
    if (memEQ(name, "WIFEXITED", 9)) {
#ifdef WIFEXITED
      int i = *arg_result;
      *arg_result = WIFEXITED(WMUNGE(i));
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 10:
    if (memEQ(name, "WIFSTOPPED", 10)) {
#ifdef WIFSTOPPED
      int i = *arg_result;
      *arg_result = WIFSTOPPED(WMUNGE(i));
      return PERL_constant_ISIV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 11:
    /* Names all of length 11.  */
    /* WEXITSTATUS WIFSIGNALED */
    /* Offset 1 gives the best switch position.  */
    switch (name[1]) {
    case 'E':
      if (memEQ(name, "WEXITSTATUS", 11)) {
      /*                ^                */
#ifdef WEXITSTATUS
	int i = *arg_result;
        *arg_result = WEXITSTATUS(WMUNGE(i));
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    case 'I':
      if (memEQ(name, "WIFSIGNALED", 11)) {
      /*                ^                */
#ifdef WIFSIGNALED
	int i = *arg_result;
        *arg_result = WIFSIGNALED(WMUNGE(i));
        return PERL_constant_ISIV;
#else
        return PERL_constant_NOTDEF;
#endif
      }
      break;
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static void
restore_sigmask(pTHX_ SV *osset_sv)
{
     /* Fortunately, restoring the signal mask can't fail, because
      * there's nothing we can do about it if it does -- we're not
      * supposed to return -1 from sigaction unless the disposition
      * was unaffected.
      */
     sigset_t *ossetp = (sigset_t *) SvPV_nolen( osset_sv );
     (void)sigprocmask(SIG_SETMASK, ossetp, (sigset_t *)0);
}

#line 570 "POSIX.c"
XS(XS_POSIX__SigSet_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_new)
{
    dXSARGS;
    {
	char *	packname;
	POSIX__SigSet	RETVAL;

	if (items < 1)
	    packname = "POSIX::SigSet";
	else {
	    packname = (char *)SvPV_nolen(ST(0));
	}
#line 566 "POSIX.xs"
	{
	    int i;
	    New(0, RETVAL, 1, sigset_t);
	    sigemptyset(RETVAL);
	    for (i = 1; i < items; i++)
		sigaddset(RETVAL, SvIV(ST(i)));
	}
#line 592 "POSIX.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "POSIX::SigSet", (void*)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__SigSet_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::SigSet::DESTROY(sigset)");
    {
	POSIX__SigSet	sigset;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "sigset is not a reference");
#line 580 "POSIX.xs"
	Safefree(sigset);
#line 616 "POSIX.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_POSIX__SigSet_addset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_addset)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::SigSet::addset(sigset, sig)");
    {
	POSIX__SigSet	sigset;
	int	sig = (int)SvIV(ST(1));
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "sigset is not of type POSIX::SigSet");

	RETVAL = sigaddset(sigset, sig);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX__SigSet_delset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_delset)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::SigSet::delset(sigset, sig)");
    {
	POSIX__SigSet	sigset;
	int	sig = (int)SvIV(ST(1));
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "sigset is not of type POSIX::SigSet");

	RETVAL = sigdelset(sigset, sig);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX__SigSet_emptyset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_emptyset)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::SigSet::emptyset(sigset)");
    {
	POSIX__SigSet	sigset;
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "sigset is not of type POSIX::SigSet");

	RETVAL = sigemptyset(sigset);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX__SigSet_fillset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_fillset)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::SigSet::fillset(sigset)");
    {
	POSIX__SigSet	sigset;
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "sigset is not of type POSIX::SigSet");

	RETVAL = sigfillset(sigset);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX__SigSet_ismember); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_ismember)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::SigSet::ismember(sigset, sig)");
    {
	POSIX__SigSet	sigset;
	int	sig = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "sigset is not of type POSIX::SigSet");

	RETVAL = sigismember(sigset, sig);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_new)
{
    dXSARGS;
    {
	char *	packname;
	POSIX__Termios	RETVAL;

	if (items < 1)
	    packname = "POSIX::Termios";
	else {
	    packname = (char *)SvPV_nolen(ST(0));
	}
#line 612 "POSIX.xs"
	{
#ifdef I_TERMIOS
	    New(0, RETVAL, 1, struct termios);
#else
	    not_here("termios");
        RETVAL = 0;
#endif
	}
#line 786 "POSIX.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "POSIX::Termios", (void*)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::DESTROY(termios_ref)");
    {
	POSIX__Termios	termios_ref;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not a reference");
#line 627 "POSIX.xs"
#ifdef I_TERMIOS
	Safefree(termios_ref);
#else
	    not_here("termios");
#endif
#line 814 "POSIX.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_POSIX__Termios_getattr); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getattr)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::getattr(termios_ref, fd = 0)");
    {
	POSIX__Termios	termios_ref;
	int	fd;
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");

	if (items < 2)
	    fd = 0;
	else {
	    fd = (int)SvIV(ST(1));
	}
#line 638 "POSIX.xs"
	RETVAL = tcgetattr(fd, termios_ref);
#line 844 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_setattr); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setattr)
{
    dXSARGS;
    if (items < 1 || items > 3)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::setattr(termios_ref, fd = 0, optional_actions = 0)");
    {
	POSIX__Termios	termios_ref;
	int	fd;
	int	optional_actions;
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");

	if (items < 2)
	    fd = 0;
	else {
	    fd = (int)SvIV(ST(1));
	}

	if (items < 3)
	    optional_actions = 0;
	else {
	    optional_actions = (int)SvIV(ST(2));
	}
#line 648 "POSIX.xs"
	RETVAL = tcsetattr(fd, optional_actions, termios_ref);
#line 888 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_getispeed); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getispeed)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::getispeed(termios_ref)");
    {
	POSIX__Termios	termios_ref;
	speed_t	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");

	RETVAL = cfgetispeed(termios_ref);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_getospeed); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getospeed)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::getospeed(termios_ref)");
    {
	POSIX__Termios	termios_ref;
	speed_t	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");

	RETVAL = cfgetospeed(termios_ref);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_getiflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getiflag)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::getiflag(termios_ref)");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 664 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	RETVAL = termios_ref->c_iflag;
#else
     not_here("getiflag");
     RETVAL = 0;
#endif
#line 972 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_getoflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getoflag)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::getoflag(termios_ref)");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 677 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	RETVAL = termios_ref->c_oflag;
#else
     not_here("getoflag");
     RETVAL = 0;
#endif
#line 1002 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_getcflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getcflag)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::getcflag(termios_ref)");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 690 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	RETVAL = termios_ref->c_cflag;
#else
     not_here("getcflag");
     RETVAL = 0;
#endif
#line 1032 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_getlflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getlflag)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::getlflag(termios_ref)");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 703 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	RETVAL = termios_ref->c_lflag;
#else
     not_here("getlflag");
     RETVAL = 0;
#endif
#line 1062 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_getcc); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getcc)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::getcc(termios_ref, ccix)");
    {
	POSIX__Termios	termios_ref;
	int	ccix = (int)SvIV(ST(1));
	cc_t	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 717 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	if (ccix >= NCCS)
	    croak("Bad getcc subscript");
	RETVAL = termios_ref->c_cc[ccix];
#else
     not_here("getcc");
     RETVAL = 0;
#endif
#line 1095 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_setispeed); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setispeed)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::setispeed(termios_ref, speed)");
    {
	POSIX__Termios	termios_ref;
	speed_t	speed = (speed_t)SvIV(ST(1));
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");

	RETVAL = cfsetispeed(termios_ref, speed);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_setospeed); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setospeed)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::setospeed(termios_ref, speed)");
    {
	POSIX__Termios	termios_ref;
	speed_t	speed = (speed_t)SvIV(ST(1));
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");

	RETVAL = cfsetospeed(termios_ref, speed);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX__Termios_setiflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setiflag)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::setiflag(termios_ref, iflag)");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	iflag = (tcflag_t)SvIV(ST(1));

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 743 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	termios_ref->c_iflag = iflag;
#else
	    not_here("setiflag");
#endif
#line 1183 "POSIX.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_POSIX__Termios_setoflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setoflag)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::setoflag(termios_ref, oflag)");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	oflag = (tcflag_t)SvIV(ST(1));

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 754 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	termios_ref->c_oflag = oflag;
#else
	    not_here("setoflag");
#endif
#line 1210 "POSIX.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_POSIX__Termios_setcflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setcflag)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::setcflag(termios_ref, cflag)");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	cflag = (tcflag_t)SvIV(ST(1));

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 765 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	termios_ref->c_cflag = cflag;
#else
	    not_here("setcflag");
#endif
#line 1237 "POSIX.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_POSIX__Termios_setlflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setlflag)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::setlflag(termios_ref, lflag)");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	lflag = (tcflag_t)SvIV(ST(1));

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 776 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	termios_ref->c_lflag = lflag;
#else
	    not_here("setlflag");
#endif
#line 1264 "POSIX.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_POSIX__Termios_setcc); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setcc)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: POSIX::Termios::setcc(termios_ref, ccix, cc)");
    {
	POSIX__Termios	termios_ref;
	int	ccix = (int)SvIV(ST(1));
	cc_t	cc = (cc_t)SvIV(ST(2));

	if (sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "termios_ref is not of type POSIX::Termios");
#line 788 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	if (ccix >= NCCS)
	    croak("Bad setcc subscript");
	termios_ref->c_cc[ccix] = cc;
#else
	    not_here("setcc");
#endif
#line 1294 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


/* INCLUDE:  Including 'const-xs.inc' from 'POSIX.xs' */

XS(XS_POSIX_constant); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_constant)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::constant(sv)");
    SP -= items;
    {
#line 4 "const-xs.inc"
#ifdef dXSTARG
	dXSTARG; /* Faster if we have it.  */
#else
	dTARGET;
#endif
	STRLEN		len;
        int		type;
	IV		iv;
	NV		nv;
	/* const char	*pv;	Uncomment this if you need to return PVs */
#line 1321 "POSIX.c"
	SV *	sv = ST(0);
	const char *	s = SvPV(sv, len);
#line 18 "const-xs.inc"
	type = constant(aTHX_ s, len, &iv, &nv);
      /* Return 1 or 2 items. First is error message, or undef if no error.
           Second, if present, is found value */
        switch (type) {
        case PERL_constant_NOTFOUND:
          sv = sv_2mortal(newSVpvf("%s is not a valid POSIX macro", s));
          PUSHs(sv);
          break;
        case PERL_constant_NOTDEF:
          sv = sv_2mortal(newSVpvf(
	    "Your vendor has not defined POSIX macro %s, used", s));
          PUSHs(sv);
          break;
        case PERL_constant_ISIV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHi(iv);
          break;
	/* Uncomment this if you need to return NOs
        case PERL_constant_ISNO:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_no);
          break; */
        case PERL_constant_ISNV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHn(nv);
          break;
	/* Uncomment this if you need to return PVs
        case PERL_constant_ISPV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, strlen(pv));
          break; */
	/* Uncomment this if you need to return PVNs
        case PERL_constant_ISPVN:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, iv);
          break; */
	/* Uncomment this if you need to return SVs
        case PERL_constant_ISSV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
          break; */
	/* Uncomment this if you need to return UNDEFs
        case PERL_constant_ISUNDEF:
          break; */
        case PERL_constant_ISUV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHu((UV)iv);
          break;
        case PERL_constant_ISYES:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_yes);
          break;
        default:
          sv = sv_2mortal(newSVpvf(
	    "Unexpected return type %d while processing POSIX macro %s, used",
               type, s));
          PUSHs(sv);
        }
#line 1391 "POSIX.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'POSIX.xs' from 'const-xs.inc' */

XS(XS_POSIX_int_macro_int); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_int_macro_int)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::int_macro_int(sv, iv)");
    SP -= items;
    {
#line 804 "POSIX.xs"
	dXSTARG;
	STRLEN		len;
        int		type;
#line 1412 "POSIX.c"
	SV *	sv = ST(0);
	const char *	s = SvPV(sv, len);
	IV	iv = (IV)SvIV(ST(1));
#line 812 "POSIX.xs"
        /* Change this to int_macro_int(s, len, &iv, &nv);
           if you need to return both NVs and IVs */
	type = int_macro_int(s, len, &iv);
      /* Return 1 or 2 items. First is error message, or undef if no error.
           Second, if present, is found value */
        switch (type) {
        case PERL_constant_NOTFOUND:
          sv = sv_2mortal(newSVpvf("%s is not a valid POSIX macro", s));
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
          break;
        case PERL_constant_NOTDEF:
          sv = sv_2mortal(newSVpvf(
	    "Your vendor has not defined POSIX macro %s, used", s));
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
          break;
        case PERL_constant_ISIV:
          PUSHi(iv);
          break;
        default:
          sv = sv_2mortal(newSVpvf(
	    "Unexpected return type %d while processing POSIX macro %s, used",
               type, s));
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
        }
#line 1447 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_isalnum); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isalnum)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::isalnum(charstring)");
    {
	SV *	charstring = ST(0);
#line 847 "POSIX.xs"
	STRLEN	len;
#line 1463 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 849 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isalnum(*s))
		RETVAL = 0;
#line 1472 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_isalpha); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isalpha)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::isalpha(charstring)");
    {
	SV *	charstring = ST(0);
#line 861 "POSIX.xs"
	STRLEN	len;
#line 1488 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 863 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isalpha(*s))
		RETVAL = 0;
#line 1497 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_iscntrl); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_iscntrl)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::iscntrl(charstring)");
    {
	SV *	charstring = ST(0);
#line 875 "POSIX.xs"
	STRLEN	len;
#line 1513 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 877 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!iscntrl(*s))
		RETVAL = 0;
#line 1522 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_isdigit); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isdigit)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::isdigit(charstring)");
    {
	SV *	charstring = ST(0);
#line 889 "POSIX.xs"
	STRLEN	len;
#line 1538 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 891 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isdigit(*s))
		RETVAL = 0;
#line 1547 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_isgraph); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isgraph)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::isgraph(charstring)");
    {
	SV *	charstring = ST(0);
#line 903 "POSIX.xs"
	STRLEN	len;
#line 1563 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 905 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isgraph(*s))
		RETVAL = 0;
#line 1572 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_islower); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_islower)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::islower(charstring)");
    {
	SV *	charstring = ST(0);
#line 917 "POSIX.xs"
	STRLEN	len;
#line 1588 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 919 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!islower(*s))
		RETVAL = 0;
#line 1597 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_isprint); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isprint)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::isprint(charstring)");
    {
	SV *	charstring = ST(0);
#line 931 "POSIX.xs"
	STRLEN	len;
#line 1613 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 933 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isprint(*s))
		RETVAL = 0;
#line 1622 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_ispunct); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ispunct)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::ispunct(charstring)");
    {
	SV *	charstring = ST(0);
#line 945 "POSIX.xs"
	STRLEN	len;
#line 1638 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 947 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!ispunct(*s))
		RETVAL = 0;
#line 1647 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_isspace); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isspace)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::isspace(charstring)");
    {
	SV *	charstring = ST(0);
#line 959 "POSIX.xs"
	STRLEN	len;
#line 1663 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 961 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isspace(*s))
		RETVAL = 0;
#line 1672 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_isupper); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isupper)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::isupper(charstring)");
    {
	SV *	charstring = ST(0);
#line 973 "POSIX.xs"
	STRLEN	len;
#line 1688 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 975 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isupper(*s))
		RETVAL = 0;
#line 1697 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_isxdigit); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isxdigit)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::isxdigit(charstring)");
    {
	SV *	charstring = ST(0);
#line 987 "POSIX.xs"
	STRLEN	len;
#line 1713 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 989 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isxdigit(*s))
		RETVAL = 0;
#line 1722 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_open); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_open)
{
    dXSARGS;
    if (items < 1 || items > 3)
	Perl_croak(aTHX_ "Usage: POSIX::open(filename, flags = O_RDONLY, mode = 0666)");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	int	flags;
	Mode_t	mode;
	SysRet	RETVAL;

	if (items < 2)
	    flags = O_RDONLY;
	else {
	    flags = (int)SvIV(ST(1));
	}

	if (items < 3)
	    mode = 0666;
	else {
	    mode = (Mode_t)SvNV(ST(2));
	}
#line 1003 "POSIX.xs"
	if (flags & (O_APPEND|O_CREAT|O_TRUNC|O_RDWR|O_WRONLY|O_EXCL))
	    TAINT_PROPER("open");
	RETVAL = open(filename, flags, mode);
#line 1755 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_localeconv); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_localeconv)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::localeconv()");
    {
	HV *	RETVAL;
#line 1013 "POSIX.xs"
#ifdef HAS_LOCALECONV
	struct lconv *lcbuf;
	RETVAL = newHV();
	sv_2mortal((SV*)RETVAL);
	if ((lcbuf = localeconv())) {
	    /* the strings */
	    if (lcbuf->decimal_point && *lcbuf->decimal_point)
		hv_store(RETVAL, "decimal_point", 13,
		    newSVpv(lcbuf->decimal_point, 0), 0);
	    if (lcbuf->thousands_sep && *lcbuf->thousands_sep)
		hv_store(RETVAL, "thousands_sep", 13,
		    newSVpv(lcbuf->thousands_sep, 0), 0);
#ifndef NO_LOCALECONV_GROUPING
	    if (lcbuf->grouping && *lcbuf->grouping)
		hv_store(RETVAL, "grouping", 8,
		    newSVpv(lcbuf->grouping, 0), 0);
#endif
	    if (lcbuf->int_curr_symbol && *lcbuf->int_curr_symbol)
		hv_store(RETVAL, "int_curr_symbol", 15,
		    newSVpv(lcbuf->int_curr_symbol, 0), 0);
	    if (lcbuf->currency_symbol && *lcbuf->currency_symbol)
		hv_store(RETVAL, "currency_symbol", 15,
		    newSVpv(lcbuf->currency_symbol, 0), 0);
	    if (lcbuf->mon_decimal_point && *lcbuf->mon_decimal_point)
		hv_store(RETVAL, "mon_decimal_point", 17,
		    newSVpv(lcbuf->mon_decimal_point, 0), 0);
#ifndef NO_LOCALECONV_MON_THOUSANDS_SEP
	    if (lcbuf->mon_thousands_sep && *lcbuf->mon_thousands_sep)
		hv_store(RETVAL, "mon_thousands_sep", 17,
		    newSVpv(lcbuf->mon_thousands_sep, 0), 0);
#endif                    
#ifndef NO_LOCALECONV_MON_GROUPING
	    if (lcbuf->mon_grouping && *lcbuf->mon_grouping)
		hv_store(RETVAL, "mon_grouping", 12,
		    newSVpv(lcbuf->mon_grouping, 0), 0);
#endif
	    if (lcbuf->positive_sign && *lcbuf->positive_sign)
		hv_store(RETVAL, "positive_sign", 13,
		    newSVpv(lcbuf->positive_sign, 0), 0);
	    if (lcbuf->negative_sign && *lcbuf->negative_sign)
		hv_store(RETVAL, "negative_sign", 13,
		    newSVpv(lcbuf->negative_sign, 0), 0);
	    /* the integers */
	    if (lcbuf->int_frac_digits != CHAR_MAX)
		hv_store(RETVAL, "int_frac_digits", 15,
		    newSViv(lcbuf->int_frac_digits), 0);
	    if (lcbuf->frac_digits != CHAR_MAX)
		hv_store(RETVAL, "frac_digits", 11,
		    newSViv(lcbuf->frac_digits), 0);
	    if (lcbuf->p_cs_precedes != CHAR_MAX)
		hv_store(RETVAL, "p_cs_precedes", 13,
		    newSViv(lcbuf->p_cs_precedes), 0);
	    if (lcbuf->p_sep_by_space != CHAR_MAX)
		hv_store(RETVAL, "p_sep_by_space", 14,
		    newSViv(lcbuf->p_sep_by_space), 0);
	    if (lcbuf->n_cs_precedes != CHAR_MAX)
		hv_store(RETVAL, "n_cs_precedes", 13,
		    newSViv(lcbuf->n_cs_precedes), 0);
	    if (lcbuf->n_sep_by_space != CHAR_MAX)
		hv_store(RETVAL, "n_sep_by_space", 14,
		    newSViv(lcbuf->n_sep_by_space), 0);
	    if (lcbuf->p_sign_posn != CHAR_MAX)
		hv_store(RETVAL, "p_sign_posn", 11,
		    newSViv(lcbuf->p_sign_posn), 0);
	    if (lcbuf->n_sign_posn != CHAR_MAX)
		hv_store(RETVAL, "n_sign_posn", 11,
		    newSViv(lcbuf->n_sign_posn), 0);
	}
#else
	localeconv(); /* A stub to call not_here(). */
#endif
#line 1847 "POSIX.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_POSIX_setlocale); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setlocale)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: POSIX::setlocale(category, locale = 0)");
    {
	int	category = (int)SvIV(ST(0));
	char *	locale;
	char *	RETVAL;
	dXSTARG;

	if (items < 2)
	    locale = 0;
	else {
	    locale = (char *)SvPV_nolen(ST(1));
	}
#line 1092 "POSIX.xs"
	RETVAL = setlocale(category, locale);
	if (RETVAL) {
#ifdef USE_LOCALE_CTYPE
	    if (category == LC_CTYPE
#ifdef LC_ALL
		|| category == LC_ALL
#endif
		)
	    {
		char *newctype;
#ifdef LC_ALL
		if (category == LC_ALL)
		    newctype = setlocale(LC_CTYPE, NULL);
		else
#endif
		    newctype = RETVAL;
		new_ctype(newctype);
	    }
#endif /* USE_LOCALE_CTYPE */
#ifdef USE_LOCALE_COLLATE
	    if (category == LC_COLLATE
#ifdef LC_ALL
		|| category == LC_ALL
#endif
		)
	    {
		char *newcoll;
#ifdef LC_ALL
		if (category == LC_ALL)
		    newcoll = setlocale(LC_COLLATE, NULL);
		else
#endif
		    newcoll = RETVAL;
		new_collate(newcoll);
	    }
#endif /* USE_LOCALE_COLLATE */
#ifdef USE_LOCALE_NUMERIC
	    if (category == LC_NUMERIC
#ifdef LC_ALL
		|| category == LC_ALL
#endif
		)
	    {
		char *newnum;
#ifdef LC_ALL
		if (category == LC_ALL)
		    newnum = setlocale(LC_NUMERIC, NULL);
		else
#endif
		    newnum = RETVAL;
		new_numeric(newnum);
	    }
#endif /* USE_LOCALE_NUMERIC */
	}
#line 1926 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_POSIX_acos); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_acos)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::acos(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = acos(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_asin); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_asin)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::asin(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = asin(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_atan); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_atan)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::atan(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = atan(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_ceil); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ceil)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::ceil(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = ceil(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_cosh); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_cosh)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::cosh(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = cosh(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_floor); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_floor)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::floor(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = floor(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_fmod); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_fmod)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::fmod(x, y)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	y = (NV)SvNV(ST(1));
	NV	RETVAL;
	dXSTARG;

	RETVAL = fmod(x, y);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_frexp); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_frexp)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::frexp(x)");
    SP -= items;
    {
	NV	x = (NV)SvNV(ST(0));
#line 1183 "POSIX.xs"
	int expvar;
	/* (We already know stack is long enough.) */
	PUSHs(sv_2mortal(newSVnv(frexp(x,&expvar))));
	PUSHs(sv_2mortal(newSViv(expvar)));
#line 2066 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_ldexp); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ldexp)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::ldexp(x, exp)");
    {
	NV	x = (NV)SvNV(ST(0));
	int	exp = (int)SvIV(ST(1));
	NV	RETVAL;
	dXSTARG;

	RETVAL = ldexp(x, exp);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_log10); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_log10)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::log10(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = log10(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_modf); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_modf)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::modf(x)");
    SP -= items;
    {
	NV	x = (NV)SvNV(ST(0));
#line 1201 "POSIX.xs"
	NV intvar;
	/* (We already know stack is long enough.) */
	PUSHs(sv_2mortal(newSVnv(Perl_modf(x,&intvar))));
	PUSHs(sv_2mortal(newSVnv(intvar)));
#line 2121 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_sinh); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sinh)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::sinh(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = sinh(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_tan); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tan)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::tan(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = tan(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_tanh); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tanh)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::tanh(x)");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = tanh(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_sigaction); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sigaction)
{
    dXSARGS;
    if (items < 2 || items > 3)
	Perl_croak(aTHX_ "Usage: POSIX::sigaction(sig, optaction, oldaction = 0)");
    {
	int	sig = (int)SvIV(ST(0));
	SV *	optaction = ST(1);
	POSIX__SigAction	oldaction;
	SysRet	RETVAL;

	if (items < 3)
	    oldaction = 0;
	else {
	    if (SvROK(ST(2)) && SvTYPE(SvRV(ST(2)))==SVt_PVHV)
		oldaction = (HV*)SvRV(ST(2));
	    else
		Perl_croak(aTHX_ "oldaction is not a hash reference");
	}
#line 1224 "POSIX.xs"
#if defined(WIN32) || defined(NETWARE)
	RETVAL = not_here("sigaction");
#else

	{
	    POSIX__SigAction action;
	    GV *siggv = gv_fetchpv("SIG", TRUE, SVt_PVHV);
	    struct sigaction act;
	    struct sigaction oact;
	    sigset_t sset;
	    SV *osset_sv;
	    sigset_t osset;
	    POSIX__SigSet sigset;
	    SV** svp;
	    SV** sigsvp;
	    if (sig == 0 && SvPOK(ST(0))) {
	        char *s = SvPVX(ST(0));
		int i = whichsig(s);

	        if (i < 0 && memEQ(s, "SIG", 3))
		    i = whichsig(s + 3);
	        if (i < 0) {
	            if (ckWARN(WARN_SIGNAL))
		        Perl_warner(aTHX_ packWARN(WARN_SIGNAL),
                                    "No such signal: SIG%s", s);
	            XSRETURN_UNDEF;
		}
	        else
		    sig = i;
            }
	    sigsvp = hv_fetch(GvHVn(siggv),
			      PL_sig_name[sig],
			      strlen(PL_sig_name[sig]),
			      TRUE);

	    /* Check optaction and set action */
	    if(SvTRUE(optaction)) {
		if(sv_isa(optaction, "POSIX::SigAction"))
			action = (HV*)SvRV(optaction);
		else
			croak("action is not of type POSIX::SigAction");
	    }
	    else {
		action=0;
	    }

	    /* sigaction() is supposed to look atomic. In particular, any
	     * signal handler invoked during a sigaction() call should
	     * see either the old or the new disposition, and not something
	     * in between. We use sigprocmask() to make it so.
	     */
	    sigfillset(&sset);
	    RETVAL=sigprocmask(SIG_BLOCK, &sset, &osset);
	    if(RETVAL == -1)
               XSRETURN_UNDEF;
	    ENTER;
	    /* Restore signal mask no matter how we exit this block. */
	    osset_sv = newSVpv((char *)(&osset), sizeof(sigset_t));
	    SAVEFREESV( osset_sv );
	    SAVEDESTRUCTOR_X(restore_sigmask, osset_sv);

	    RETVAL=-1; /* In case both oldaction and action are 0. */

	    /* Remember old disposition if desired. */
	    if (oldaction) {
		svp = hv_fetch(oldaction, "HANDLER", 7, TRUE);
		if(!svp)
		    croak("Can't supply an oldaction without a HANDLER");
		if(SvTRUE(*sigsvp)) { /* TBD: what if "0"? */
			sv_setsv(*svp, *sigsvp);
		}
		else {
			sv_setpv(*svp, "DEFAULT");
		}
		RETVAL = sigaction(sig, (struct sigaction *)0, & oact);
		if(RETVAL == -1)
                   XSRETURN_UNDEF;
		/* Get back the mask. */
		svp = hv_fetch(oldaction, "MASK", 4, TRUE);
		if (sv_isa(*svp, "POSIX::SigSet")) {
		    IV tmp = SvIV((SV*)SvRV(*svp));
		    sigset = INT2PTR(sigset_t*, tmp);
		}
		else {
		    New(0, sigset, 1, sigset_t);
		    sv_setptrobj(*svp, sigset, "POSIX::SigSet");
		}
		*sigset = oact.sa_mask;

		/* Get back the flags. */
		svp = hv_fetch(oldaction, "FLAGS", 5, TRUE);
		sv_setiv(*svp, oact.sa_flags);

		/* Get back whether the old handler used safe signals. */
		svp = hv_fetch(oldaction, "SAFE", 4, TRUE);
		sv_setiv(*svp, oact.sa_handler == PL_csighandlerp);
	    }

	    if (action) {
		/* Safe signals use "csighandler", which vectors through the
		   PL_sighandlerp pointer when it's safe to do so.
		   (BTW, "csighandler" is very different from "sighandler".) */
		svp = hv_fetch(action, "SAFE", 4, FALSE);
		act.sa_handler = (*svp && SvTRUE(*svp))
				 ? PL_csighandlerp : PL_sighandlerp;

		/* Vector new Perl handler through %SIG.
		   (The core signal handlers read %SIG to dispatch.) */
		svp = hv_fetch(action, "HANDLER", 7, FALSE);
		if (!svp)
		    croak("Can't supply an action without a HANDLER");
		sv_setsv(*sigsvp, *svp);

		/* This call actually calls sigaction() with almost the
		   right settings, including appropriate interpretation
		   of DEFAULT and IGNORE.  However, why are we doing
		   this when we're about to do it again just below?  XXX */
		mg_set(*sigsvp);

		/* And here again we duplicate -- DEFAULT/IGNORE checking. */
		if(SvPOK(*svp)) {
			char *s=SvPVX(*svp);
			if(strEQ(s,"IGNORE")) {
				act.sa_handler = SIG_IGN;
			}
			else if(strEQ(s,"DEFAULT")) {
				act.sa_handler = SIG_DFL;
			}
		}

		/* Set up any desired mask. */
		svp = hv_fetch(action, "MASK", 4, FALSE);
		if (svp && sv_isa(*svp, "POSIX::SigSet")) {
		    IV tmp = SvIV((SV*)SvRV(*svp));
		    sigset = INT2PTR(sigset_t*, tmp);
		    act.sa_mask = *sigset;
		}
		else
		    sigemptyset(& act.sa_mask);

		/* Set up any desired flags. */
		svp = hv_fetch(action, "FLAGS", 5, FALSE);
		act.sa_flags = svp ? SvIV(*svp) : 0;

		/* Don't worry about cleaning up *sigsvp if this fails,
		 * because that means we tried to disposition a
		 * nonblockable signal, in which case *sigsvp is
		 * essentially meaningless anyway.
		 */
		RETVAL = sigaction(sig, & act, (struct sigaction *)0);
               if(RETVAL == -1)
                   XSRETURN_UNDEF;
	    }

	    LEAVE;
	}
#endif
#line 2356 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_sigpending); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sigpending)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::sigpending(sigset)");
    {
	POSIX__SigSet	sigset;
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "sigset is not of type POSIX::SigSet");

	RETVAL = sigpending(sigset);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_sigprocmask); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sigprocmask)
{
    dXSARGS;
    if (items < 2 || items > 3)
	Perl_croak(aTHX_ "Usage: POSIX::sigprocmask(how, sigset, oldsigset = 0)");
    {
	int	how = (int)SvIV(ST(0));
	POSIX__SigSet	sigset;
	POSIX__SigSet	oldsigset;
	SysRet	RETVAL;

	if (sv_derived_from(ST(1), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "sigset is not of type POSIX::SigSet");
#line 1396 "POSIX.xs"
	if ( items < 3 ) {
	    oldsigset = 0;
	}
	else if (sv_derived_from(ST(2), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    oldsigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else {
	    New(0, oldsigset, 1, sigset_t);
	    sigemptyset(oldsigset);
	    sv_setref_pv(ST(2), "POSIX::SigSet", (void*)oldsigset);
	}
#line 2428 "POSIX.c"

	RETVAL = sigprocmask(how, sigset, oldsigset);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_sigsuspend); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sigsuspend)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::sigsuspend(signal_mask)");
    {
	POSIX__SigSet	signal_mask;
	SysRet	RETVAL;

	if (sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    signal_mask = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "signal_mask is not of type POSIX::SigSet");

	RETVAL = sigsuspend(signal_mask);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX__exit); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__exit)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::_exit(status)");
    {
	int	status = (int)SvIV(ST(0));

	_exit(status);
    }
    XSRETURN_EMPTY;
}

XS(XS_POSIX_close); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_close)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::close(fd)");
    {
	int	fd = (int)SvIV(ST(0));
	SysRet	RETVAL;

	RETVAL = close(fd);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_dup); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_dup)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::dup(fd)");
    {
	int	fd = (int)SvIV(ST(0));
	SysRet	RETVAL;

	RETVAL = dup(fd);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_dup2); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_dup2)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::dup2(fd1, fd2)");
    {
	int	fd1 = (int)SvIV(ST(0));
	int	fd2 = (int)SvIV(ST(1));
	SysRet	RETVAL;

	RETVAL = dup2(fd1, fd2);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_lseek); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_lseek)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: POSIX::lseek(fd, offset, whence)");
    {
	int	fd = (int)SvIV(ST(0));
	Off_t	offset = (Off_t)SvNV(ST(1));
	int	whence = (int)SvIV(ST(2));
	SV *	RETVAL;
#line 1436 "POSIX.xs"
	Off_t pos = PerlLIO_lseek(fd, offset, whence);
	RETVAL = sizeof(Off_t) > sizeof(IV)
		 ? newSVnv((NV)pos) : newSViv((IV)pos);
#line 2567 "POSIX.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_POSIX_nice); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_nice)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::nice(incr)");
    SP -= items;
    {
	int	incr = (int)SvIV(ST(0));
#line 1446 "POSIX.xs"
	errno = 0;
	if ((incr = nice(incr)) != -1 || errno == 0) {
	    if (incr == 0)
		XPUSHs(sv_2mortal(newSVpvn("0 but true", 10)));
	    else
		XPUSHs(sv_2mortal(newSViv(incr)));
	}
#line 2591 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_pipe); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_pipe)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::pipe()");
   PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1457 "POSIX.xs"
	int fds[2];
	if (pipe(fds) != -1) {
	    EXTEND(SP,2);
	    PUSHs(sv_2mortal(newSViv(fds[0])));
	    PUSHs(sv_2mortal(newSViv(fds[1])));
	}
#line 2613 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_read); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_read)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: POSIX::read(fd, buffer, nbytes)");
    {
#line 1467 "POSIX.xs"
        SV *sv_buffer = SvROK(ST(1)) ? SvRV(ST(1)) : ST(1);
#line 2628 "POSIX.c"
	int	fd = (int)SvIV(ST(0));
	size_t	nbytes = (size_t)SvUV(ST(2));
	char *	buffer = sv_grow( sv_buffer, nbytes+1 );
	SysRet	RETVAL;

	RETVAL = read(fd, buffer, nbytes);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
#line 1473 "POSIX.xs"
        if (RETVAL >= 0) {
            SvCUR(sv_buffer) = RETVAL;
            SvPOK_only(sv_buffer);
            *SvEND(sv_buffer) = '\0';
            SvTAINTED_on(sv_buffer);
        }
#line 2649 "POSIX.c"
    }
    XSRETURN(1);
}

XS(XS_POSIX_setpgid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setpgid)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::setpgid(pid, pgid)");
    {
	pid_t	pid = (pid_t)SvNV(ST(0));
	pid_t	pgid = (pid_t)SvNV(ST(1));
	SysRet	RETVAL;

	RETVAL = setpgid(pid, pgid);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_setsid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setsid)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::setsid()");
    {
	pid_t	RETVAL;
	dXSTARG;

	RETVAL = setsid();
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_tcgetpgrp); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcgetpgrp)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::tcgetpgrp(fd)");
    {
	int	fd = (int)SvIV(ST(0));
	pid_t	RETVAL;
	dXSTARG;

	RETVAL = tcgetpgrp(fd);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_tcsetpgrp); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcsetpgrp)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::tcsetpgrp(fd, pgrp_id)");
    {
	int	fd = (int)SvIV(ST(0));
	pid_t	pgrp_id = (pid_t)SvNV(ST(1));
	SysRet	RETVAL;

	RETVAL = tcsetpgrp(fd, pgrp_id);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_uname); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_uname)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::uname()");
   PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1500 "POSIX.xs"
#ifdef HAS_UNAME
	struct utsname buf;
	if (uname(&buf) >= 0) {
	    EXTEND(SP, 5);
	    PUSHs(sv_2mortal(newSVpv(buf.sysname, 0)));
	    PUSHs(sv_2mortal(newSVpv(buf.nodename, 0)));
	    PUSHs(sv_2mortal(newSVpv(buf.release, 0)));
	    PUSHs(sv_2mortal(newSVpv(buf.version, 0)));
	    PUSHs(sv_2mortal(newSVpv(buf.machine, 0)));
	}
#else
	uname((char *) 0); /* A stub to call not_here(). */
#endif
#line 2756 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_write); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_write)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: POSIX::write(fd, buffer, nbytes)");
    {
	int	fd = (int)SvIV(ST(0));
	char *	buffer = (char *)SvPV_nolen(ST(1));
	size_t	nbytes = (size_t)SvUV(ST(2));
	SysRet	RETVAL;

	RETVAL = write(fd, buffer, nbytes);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_tmpnam); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tmpnam)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::tmpnam()");
    {
#line 1523 "POSIX.xs"
	STRLEN i;
	int len;
#line 2796 "POSIX.c"
	SV *	RETVAL;
#line 1526 "POSIX.xs"
	RETVAL = newSVpvn("", 0);
	SvGROW(RETVAL, L_tmpnam);
	len = strlen(tmpnam(SvPV(RETVAL, i)));
	SvCUR_set(RETVAL, len);
#line 2803 "POSIX.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_POSIX_abort); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_abort)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::abort()");
    {

	abort();
    }
    XSRETURN_EMPTY;
}

XS(XS_POSIX_mblen); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mblen)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::mblen(s, n)");
    {
	char *	s = (char *)SvPV_nolen(ST(0));
	size_t	n = (size_t)SvUV(ST(1));
	int	RETVAL;
	dXSTARG;

	RETVAL = mblen(s, n);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_mbstowcs); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mbstowcs)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: POSIX::mbstowcs(s, pwcs, n)");
    {
	wchar_t *	s = (wchar_t *)SvPV_nolen(ST(0));
	char *	pwcs = (char *)SvPV_nolen(ST(1));
	size_t	n = (size_t)SvUV(ST(2));
	size_t	RETVAL;
	dXSTARG;

	RETVAL = mbstowcs(s, pwcs, n);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_mbtowc); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mbtowc)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: POSIX::mbtowc(pwc, s, n)");
    {
	wchar_t *	pwc = (wchar_t *)SvPV_nolen(ST(0));
	char *	s = (char *)SvPV_nolen(ST(1));
	size_t	n = (size_t)SvUV(ST(2));
	int	RETVAL;
	dXSTARG;

	RETVAL = mbtowc(pwc, s, n);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_wcstombs); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_wcstombs)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: POSIX::wcstombs(s, pwcs, n)");
    {
	char *	s = (char *)SvPV_nolen(ST(0));
	wchar_t *	pwcs = (wchar_t *)SvPV_nolen(ST(1));
	size_t	n = (size_t)SvUV(ST(2));
	int	RETVAL;
	dXSTARG;

	RETVAL = wcstombs(s, pwcs, n);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_wctomb); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_wctomb)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::wctomb(s, wchar)");
    {
	char *	s = (char *)SvPV_nolen(ST(0));
	wchar_t	wchar = (wchar_t)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

	RETVAL = wctomb(s, wchar);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_strcoll); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strcoll)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::strcoll(s1, s2)");
    {
	char *	s1 = (char *)SvPV_nolen(ST(0));
	char *	s2 = (char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

	RETVAL = strcoll(s1, s2);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_strtod); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strtod)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::strtod(str)");
    SP -= items;
    {
	char *	str = (char *)SvPV_nolen(ST(0));
#line 1573 "POSIX.xs"
	double num;
	char *unparsed;
#line 2946 "POSIX.c"
#line 1576 "POSIX.xs"
	SET_NUMERIC_LOCAL();
	num = strtod(str, &unparsed);
	PUSHs(sv_2mortal(newSVnv(num)));
	if (GIMME == G_ARRAY) {
	    EXTEND(SP, 1);
	    if (unparsed)
		PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
	    else
		PUSHs(&PL_sv_undef);
	}
#line 2958 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_strtol); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strtol)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: POSIX::strtol(str, base = 0)");
    SP -= items;
    {
	char *	str = (char *)SvPV_nolen(ST(0));
	int	base;
#line 1592 "POSIX.xs"
	long num;
	char *unparsed;
#line 2977 "POSIX.c"

	if (items < 2)
	    base = 0;
	else {
	    base = (int)SvIV(ST(1));
	}
#line 1595 "POSIX.xs"
	num = strtol(str, &unparsed, base);
#if IVSIZE <= LONGSIZE
	if (num < IV_MIN || num > IV_MAX)
	    PUSHs(sv_2mortal(newSVnv((double)num)));
	else
#endif
	    PUSHs(sv_2mortal(newSViv((IV)num)));
	if (GIMME == G_ARRAY) {
	    EXTEND(SP, 1);
	    if (unparsed)
		PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
	    else
		PUSHs(&PL_sv_undef);
	}
#line 2999 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_strtoul); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strtoul)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: POSIX::strtoul(str, base = 0)");
    SP -= items;
    {
	char *	str = (char *)SvPV_nolen(ST(0));
	int	base;
#line 1615 "POSIX.xs"
	unsigned long num;
	char *unparsed;
#line 3018 "POSIX.c"

	if (items < 2)
	    base = 0;
	else {
	    base = (int)SvIV(ST(1));
	}
#line 1618 "POSIX.xs"
	num = strtoul(str, &unparsed, base);
#if IVSIZE <= LONGSIZE
	if (num > IV_MAX)
	    PUSHs(sv_2mortal(newSVnv((double)num)));
	else
#endif
	    PUSHs(sv_2mortal(newSViv((IV)num)));
	if (GIMME == G_ARRAY) {
	    EXTEND(SP, 1);
	    if (unparsed)
		PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
	    else
		PUSHs(&PL_sv_undef);
	}
#line 3040 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_strxfrm); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strxfrm)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::strxfrm(src)");
    {
	SV *	src = ST(0);
#line 1637 "POSIX.xs"
	{
          STRLEN srclen;
          STRLEN dstlen;
          char *p = SvPV(src,srclen);
          srclen++;
          ST(0) = sv_2mortal(NEWSV(800,srclen*4+1));
          dstlen = strxfrm(SvPVX(ST(0)), p, (size_t)srclen);
          if (dstlen > srclen) {
              dstlen++;
              SvGROW(ST(0), dstlen);
              strxfrm(SvPVX(ST(0)), p, (size_t)dstlen);
              dstlen--;
          }
          SvCUR(ST(0)) = dstlen;
	    SvPOK_only(ST(0));
	}
#line 3071 "POSIX.c"
    }
    XSRETURN(1);
}

XS(XS_POSIX_mkfifo); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mkfifo)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::mkfifo(filename, mode)");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	Mode_t	mode = (Mode_t)SvNV(ST(1));
	SysRet	RETVAL;
#line 1659 "POSIX.xs"
	TAINT_PROPER("mkfifo");
	RETVAL = mkfifo(filename, mode);
#line 3089 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_tcdrain); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcdrain)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::tcdrain(fd)");
    {
	int	fd = (int)SvIV(ST(0));
	SysRet	RETVAL;

	RETVAL = tcdrain(fd);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_tcflow); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcflow)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::tcflow(fd, action)");
    {
	int	fd = (int)SvIV(ST(0));
	int	action = (int)SvIV(ST(1));
	SysRet	RETVAL;

	RETVAL = tcflow(fd, action);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_tcflush); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcflush)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::tcflush(fd, queue_selector)");
    {
	int	fd = (int)SvIV(ST(0));
	int	queue_selector = (int)SvIV(ST(1));
	SysRet	RETVAL;

	RETVAL = tcflush(fd, queue_selector);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_tcsendbreak); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcsendbreak)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::tcsendbreak(fd, duration)");
    {
	int	fd = (int)SvIV(ST(0));
	int	duration = (int)SvIV(ST(1));
	SysRet	RETVAL;

	RETVAL = tcsendbreak(fd, duration);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_asctime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_asctime)
{
    dXSARGS;
    if (items < 6 || items > 9)
	Perl_croak(aTHX_ "Usage: POSIX::asctime(sec, min, hour, mday, mon, year, wday = 0, yday = 0, isdst = 0)");
    {
	int	sec = (int)SvIV(ST(0));
	int	min = (int)SvIV(ST(1));
	int	hour = (int)SvIV(ST(2));
	int	mday = (int)SvIV(ST(3));
	int	mon = (int)SvIV(ST(4));
	int	year = (int)SvIV(ST(5));
	int	wday;
	int	yday;
	int	isdst;
	char *	RETVAL;
	dXSTARG;

	if (items < 7)
	    wday = 0;
	else {
	    wday = (int)SvIV(ST(6));
	}

	if (items < 8)
	    yday = 0;
	else {
	    yday = (int)SvIV(ST(7));
	}

	if (items < 9)
	    isdst = 0;
	else {
	    isdst = (int)SvIV(ST(8));
	}
#line 1697 "POSIX.xs"
	{
	    struct tm mytm;
	    init_tm(&mytm);	/* XXX workaround - see init_tm() above */
	    mytm.tm_sec = sec;
	    mytm.tm_min = min;
	    mytm.tm_hour = hour;
	    mytm.tm_mday = mday;
	    mytm.tm_mon = mon;
	    mytm.tm_year = year;
	    mytm.tm_wday = wday;
	    mytm.tm_yday = yday;
	    mytm.tm_isdst = isdst;
	    RETVAL = asctime(&mytm);
	}
#line 3243 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_POSIX_clock); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_clock)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::clock()");
    {
	long	RETVAL;
	dXSTARG;

	RETVAL = clock();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_ctime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ctime)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::ctime(time)");
    {
	Time_t	time = (Time_t)SvNV(ST(0));
	char *	RETVAL;
	dXSTARG;

	RETVAL = ctime(&time);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_POSIX_times); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_times)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::times()");
   PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1724 "POSIX.xs"
	struct tms tms;
	clock_t realtime;
	realtime = times( &tms );
	EXTEND(SP,5);
	PUSHs( sv_2mortal( newSViv( (IV) realtime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_utime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_stime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_cutime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_cstime ) ) );
#line 3301 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_difftime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_difftime)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::difftime(time1, time2)");
    {
	Time_t	time1 = (Time_t)SvNV(ST(0));
	Time_t	time2 = (Time_t)SvNV(ST(1));
	double	RETVAL;
	dXSTARG;

	RETVAL = difftime(time1, time2);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_POSIX_mktime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mktime)
{
    dXSARGS;
    if (items < 6 || items > 9)
	Perl_croak(aTHX_ "Usage: POSIX::mktime(sec, min, hour, mday, mon, year, wday = 0, yday = 0, isdst = 0)");
    {
	int	sec = (int)SvIV(ST(0));
	int	min = (int)SvIV(ST(1));
	int	hour = (int)SvIV(ST(2));
	int	mday = (int)SvIV(ST(3));
	int	mon = (int)SvIV(ST(4));
	int	year = (int)SvIV(ST(5));
	int	wday;
	int	yday;
	int	isdst;
	SysRetLong	RETVAL;

	if (items < 7)
	    wday = 0;
	else {
	    wday = (int)SvIV(ST(6));
	}

	if (items < 8)
	    yday = 0;
	else {
	    yday = (int)SvIV(ST(7));
	}

	if (items < 9)
	    isdst = 0;
	else {
	    isdst = (int)SvIV(ST(8));
	}
#line 1751 "POSIX.xs"
	{
	    struct tm mytm;
	    init_tm(&mytm);	/* XXX workaround - see init_tm() above */
	    mytm.tm_sec = sec;
	    mytm.tm_min = min;
	    mytm.tm_hour = hour;
	    mytm.tm_mday = mday;
	    mytm.tm_mon = mon;
	    mytm.tm_year = year;
	    mytm.tm_wday = wday;
	    mytm.tm_yday = yday;
	    mytm.tm_isdst = isdst;
	    RETVAL = mktime(&mytm);
	}
#line 3375 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_strftime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strftime)
{
    dXSARGS;
    if (items < 7 || items > 10)
	Perl_croak(aTHX_ "Usage: POSIX::strftime(fmt, sec, min, hour, mday, mon, year, wday = -1, yday = -1, isdst = -1)");
    {
	char *	fmt = (char *)SvPV_nolen(ST(0));
	int	sec = (int)SvIV(ST(1));
	int	min = (int)SvIV(ST(2));
	int	hour = (int)SvIV(ST(3));
	int	mday = (int)SvIV(ST(4));
	int	mon = (int)SvIV(ST(5));
	int	year = (int)SvIV(ST(6));
	int	wday;
	int	yday;
	int	isdst;

	if (items < 8)
	    wday = -1;
	else {
	    wday = (int)SvIV(ST(7));
	}

	if (items < 9)
	    yday = -1;
	else {
	    yday = (int)SvIV(ST(8));
	}

	if (items < 10)
	    isdst = -1;
	else {
	    isdst = (int)SvIV(ST(9));
	}
#line 1784 "POSIX.xs"
	{
	    char *buf = my_strftime(fmt, sec, min, hour, mday, mon, year, wday, yday, isdst);
	    if (buf) {
		ST(0) = sv_2mortal(newSVpv(buf, 0));
		Safefree(buf);
	    }
	}
#line 3430 "POSIX.c"
    }
    XSRETURN(1);
}

XS(XS_POSIX_tzset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tzset)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::tzset()");
    {

	tzset();
    }
    XSRETURN_EMPTY;
}

XS(XS_POSIX_tzname); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tzname)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::tzname()");
   PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1798 "POSIX.xs"
	EXTEND(SP,2);
	PUSHs(sv_2mortal(newSVpvn(tzname[0],strlen(tzname[0]))));
	PUSHs(sv_2mortal(newSVpvn(tzname[1],strlen(tzname[1]))));
#line 3461 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_access); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_access)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::access(filename, mode)");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	Mode_t	mode = (Mode_t)SvNV(ST(1));
	SysRet	RETVAL;

	RETVAL = access(filename, mode);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_ctermid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ctermid)
{
    dXSARGS;
    if (items < 0 || items > 1)
	Perl_croak(aTHX_ "Usage: POSIX::ctermid(s = 0)");
    {
	char *	s = 0;
	char *	RETVAL;
	dXSTARG;
#line 1811 "POSIX.xs"
#ifdef HAS_CTERMID_R
	s = safemalloc((size_t) L_ctermid);
#endif
	RETVAL = ctermid(s);
#line 3505 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
#line 1818 "POSIX.xs"
#ifdef HAS_CTERMID_R
	Safefree(s);
#endif
#line 3511 "POSIX.c"
    }
    XSRETURN(1);
}

XS(XS_POSIX_cuserid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_cuserid)
{
    dXSARGS;
    if (items < 0 || items > 1)
	Perl_croak(aTHX_ "Usage: POSIX::cuserid(s = 0)");
    {
	char *	s = 0;
	char *	RETVAL;
	dXSTARG;

	RETVAL = cuserid(s);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_POSIX_fpathconf); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_fpathconf)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::fpathconf(fd, name)");
    {
	int	fd = (int)SvIV(ST(0));
	int	name = (int)SvIV(ST(1));
	SysRetLong	RETVAL;

	RETVAL = fpathconf(fd, name);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_pathconf); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_pathconf)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: POSIX::pathconf(filename, name)");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	int	name = (int)SvIV(ST(1));
	SysRetLong	RETVAL;

	RETVAL = pathconf(filename, name);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_pause); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_pause)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::pause()");
    {
	SysRet	RETVAL;

	RETVAL = pause();
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_setgid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setgid)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::setgid(gid)");
    {
	Gid_t	gid = (Gid_t)SvNV(ST(0));
	SysRet	RETVAL;

	RETVAL = setgid(gid);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
#line 1843 "POSIX.xs"
#ifndef WIN32
	if (RETVAL >= 0) {
	    PL_gid  = getgid();
	    PL_egid = getegid();
	}
#endif
#line 3625 "POSIX.c"
    }
    XSRETURN(1);
}

XS(XS_POSIX_setuid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setuid)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::setuid(uid)");
    {
	Uid_t	uid = (Uid_t)SvNV(ST(0));
	SysRet	RETVAL;

	RETVAL = setuid(uid);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
#line 1854 "POSIX.xs"
#ifndef WIN32
	if (RETVAL >= 0) {
	    PL_uid  = getuid();
	    PL_euid = geteuid();
	}
#endif
#line 3655 "POSIX.c"
    }
    XSRETURN(1);
}

XS(XS_POSIX_sysconf); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sysconf)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::sysconf(name)");
    {
	int	name = (int)SvIV(ST(0));
	SysRetLong	RETVAL;

	RETVAL = sysconf(name);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

XS(XS_POSIX_ttyname); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ttyname)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: POSIX::ttyname(fd)");
    {
	int	fd = (int)SvIV(ST(0));
	char *	RETVAL;
	dXSTARG;

	RETVAL = ttyname(fd);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

XS(XS_POSIX_getcwd); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_getcwd)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: POSIX::getcwd()");
   PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1872 "POSIX.xs"
      {
	dXSTARG;
	getcwd_sv(TARG);
	XSprePUSH; PUSHTARG;
      }
#line 3714 "POSIX.c"
	PUTBACK;
	return;
    }
}

XS(XS_POSIX_lchown); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_lchown)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: POSIX::lchown(uid, gid, path)");
    {
	Uid_t	uid = (Uid_t)SvNV(ST(0));
	Gid_t	gid = (Gid_t)SvNV(ST(1));
	char *	path = (char *)SvPV_nolen(ST(2));
	SysRet	RETVAL;
#line 1884 "POSIX.xs"
#ifdef HAS_LCHOWN
       /* yes, the order of arguments is different,
        * but consistent with CORE::chown() */
       RETVAL = lchown(path, uid, gid);
#else
       RETVAL = not_here("lchown");
#endif
#line 3739 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_POSIX); /* prototype to pass -Wmissing-prototypes */
XS(boot_POSIX)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("POSIX::SigSet::new", XS_POSIX__SigSet_new, file);
        newXS("POSIX::SigSet::DESTROY", XS_POSIX__SigSet_DESTROY, file);
        newXS("POSIX::SigSet::addset", XS_POSIX__SigSet_addset, file);
        newXS("POSIX::SigSet::delset", XS_POSIX__SigSet_delset, file);
        newXS("POSIX::SigSet::emptyset", XS_POSIX__SigSet_emptyset, file);
        newXS("POSIX::SigSet::fillset", XS_POSIX__SigSet_fillset, file);
        newXS("POSIX::SigSet::ismember", XS_POSIX__SigSet_ismember, file);
        newXS("POSIX::Termios::new", XS_POSIX__Termios_new, file);
        newXS("POSIX::Termios::DESTROY", XS_POSIX__Termios_DESTROY, file);
        newXS("POSIX::Termios::getattr", XS_POSIX__Termios_getattr, file);
        newXS("POSIX::Termios::setattr", XS_POSIX__Termios_setattr, file);
        newXS("POSIX::Termios::getispeed", XS_POSIX__Termios_getispeed, file);
        newXS("POSIX::Termios::getospeed", XS_POSIX__Termios_getospeed, file);
        newXS("POSIX::Termios::getiflag", XS_POSIX__Termios_getiflag, file);
        newXS("POSIX::Termios::getoflag", XS_POSIX__Termios_getoflag, file);
        newXS("POSIX::Termios::getcflag", XS_POSIX__Termios_getcflag, file);
        newXS("POSIX::Termios::getlflag", XS_POSIX__Termios_getlflag, file);
        newXS("POSIX::Termios::getcc", XS_POSIX__Termios_getcc, file);
        newXS("POSIX::Termios::setispeed", XS_POSIX__Termios_setispeed, file);
        newXS("POSIX::Termios::setospeed", XS_POSIX__Termios_setospeed, file);
        newXS("POSIX::Termios::setiflag", XS_POSIX__Termios_setiflag, file);
        newXS("POSIX::Termios::setoflag", XS_POSIX__Termios_setoflag, file);
        newXS("POSIX::Termios::setcflag", XS_POSIX__Termios_setcflag, file);
        newXS("POSIX::Termios::setlflag", XS_POSIX__Termios_setlflag, file);
        newXS("POSIX::Termios::setcc", XS_POSIX__Termios_setcc, file);
        newXS("POSIX::constant", XS_POSIX_constant, file);
        newXS("POSIX::int_macro_int", XS_POSIX_int_macro_int, file);
        newXS("POSIX::isalnum", XS_POSIX_isalnum, file);
        newXS("POSIX::isalpha", XS_POSIX_isalpha, file);
        newXS("POSIX::iscntrl", XS_POSIX_iscntrl, file);
        newXS("POSIX::isdigit", XS_POSIX_isdigit, file);
        newXS("POSIX::isgraph", XS_POSIX_isgraph, file);
        newXS("POSIX::islower", XS_POSIX_islower, file);
        newXS("POSIX::isprint", XS_POSIX_isprint, file);
        newXS("POSIX::ispunct", XS_POSIX_ispunct, file);
        newXS("POSIX::isspace", XS_POSIX_isspace, file);
        newXS("POSIX::isupper", XS_POSIX_isupper, file);
        newXS("POSIX::isxdigit", XS_POSIX_isxdigit, file);
        newXS("POSIX::open", XS_POSIX_open, file);
        newXS("POSIX::localeconv", XS_POSIX_localeconv, file);
        newXS("POSIX::setlocale", XS_POSIX_setlocale, file);
        newXS("POSIX::acos", XS_POSIX_acos, file);
        newXS("POSIX::asin", XS_POSIX_asin, file);
        newXS("POSIX::atan", XS_POSIX_atan, file);
        newXS("POSIX::ceil", XS_POSIX_ceil, file);
        newXS("POSIX::cosh", XS_POSIX_cosh, file);
        newXS("POSIX::floor", XS_POSIX_floor, file);
        newXS("POSIX::fmod", XS_POSIX_fmod, file);
        newXS("POSIX::frexp", XS_POSIX_frexp, file);
        newXS("POSIX::ldexp", XS_POSIX_ldexp, file);
        newXS("POSIX::log10", XS_POSIX_log10, file);
        newXS("POSIX::modf", XS_POSIX_modf, file);
        newXS("POSIX::sinh", XS_POSIX_sinh, file);
        newXS("POSIX::tan", XS_POSIX_tan, file);
        newXS("POSIX::tanh", XS_POSIX_tanh, file);
        newXS("POSIX::sigaction", XS_POSIX_sigaction, file);
        newXS("POSIX::sigpending", XS_POSIX_sigpending, file);
        newXS("POSIX::sigprocmask", XS_POSIX_sigprocmask, file);
        newXS("POSIX::sigsuspend", XS_POSIX_sigsuspend, file);
        newXS("POSIX::_exit", XS_POSIX__exit, file);
        newXS("POSIX::close", XS_POSIX_close, file);
        newXS("POSIX::dup", XS_POSIX_dup, file);
        newXS("POSIX::dup2", XS_POSIX_dup2, file);
        newXS("POSIX::lseek", XS_POSIX_lseek, file);
        newXS("POSIX::nice", XS_POSIX_nice, file);
        newXS("POSIX::pipe", XS_POSIX_pipe, file);
        newXS("POSIX::read", XS_POSIX_read, file);
        newXS("POSIX::setpgid", XS_POSIX_setpgid, file);
        newXS("POSIX::setsid", XS_POSIX_setsid, file);
        newXS("POSIX::tcgetpgrp", XS_POSIX_tcgetpgrp, file);
        newXS("POSIX::tcsetpgrp", XS_POSIX_tcsetpgrp, file);
        newXS("POSIX::uname", XS_POSIX_uname, file);
        newXS("POSIX::write", XS_POSIX_write, file);
        newXS("POSIX::tmpnam", XS_POSIX_tmpnam, file);
        newXS("POSIX::abort", XS_POSIX_abort, file);
        newXS("POSIX::mblen", XS_POSIX_mblen, file);
        newXS("POSIX::mbstowcs", XS_POSIX_mbstowcs, file);
        newXS("POSIX::mbtowc", XS_POSIX_mbtowc, file);
        newXS("POSIX::wcstombs", XS_POSIX_wcstombs, file);
        newXS("POSIX::wctomb", XS_POSIX_wctomb, file);
        newXS("POSIX::strcoll", XS_POSIX_strcoll, file);
        newXS("POSIX::strtod", XS_POSIX_strtod, file);
        newXS("POSIX::strtol", XS_POSIX_strtol, file);
        newXS("POSIX::strtoul", XS_POSIX_strtoul, file);
        newXS("POSIX::strxfrm", XS_POSIX_strxfrm, file);
        newXS("POSIX::mkfifo", XS_POSIX_mkfifo, file);
        newXS("POSIX::tcdrain", XS_POSIX_tcdrain, file);
        newXS("POSIX::tcflow", XS_POSIX_tcflow, file);
        newXS("POSIX::tcflush", XS_POSIX_tcflush, file);
        newXS("POSIX::tcsendbreak", XS_POSIX_tcsendbreak, file);
        newXS("POSIX::asctime", XS_POSIX_asctime, file);
        newXS("POSIX::clock", XS_POSIX_clock, file);
        newXS("POSIX::ctime", XS_POSIX_ctime, file);
        newXS("POSIX::times", XS_POSIX_times, file);
        newXS("POSIX::difftime", XS_POSIX_difftime, file);
        newXS("POSIX::mktime", XS_POSIX_mktime, file);
        newXS("POSIX::strftime", XS_POSIX_strftime, file);
        newXS("POSIX::tzset", XS_POSIX_tzset, file);
        newXS("POSIX::tzname", XS_POSIX_tzname, file);
        newXS("POSIX::access", XS_POSIX_access, file);
        newXS("POSIX::ctermid", XS_POSIX_ctermid, file);
        newXS("POSIX::cuserid", XS_POSIX_cuserid, file);
        newXS("POSIX::fpathconf", XS_POSIX_fpathconf, file);
        newXS("POSIX::pathconf", XS_POSIX_pathconf, file);
        newXS("POSIX::pause", XS_POSIX_pause, file);
        newXS("POSIX::setgid", XS_POSIX_setgid, file);
        newXS("POSIX::setuid", XS_POSIX_setuid, file);
        newXS("POSIX::sysconf", XS_POSIX_sysconf, file);
        newXS("POSIX::ttyname", XS_POSIX_ttyname, file);
        newXS("POSIX::getcwd", XS_POSIX_getcwd, file);
        newXS("POSIX::lchown", XS_POSIX_lchown, file);
    XSRETURN_YES;
}

