Summary: Displays where a particular program in your path is located.
Name: which
Version: 2.16
Release: 4
License: GPL
Group: Applications/System
Source0: http://www.xs4all.nl/~carlo17/which/%{name}-%{version}.tar.gz
Source1: which-2.sh
Url: http://www.xs4all.nl/~carlo17/which/
Patch: which-2.13-afs.patch
Patch1: which-2.14-broken.patch
Prefix: %{_prefix}
Buildroot: %{_tmppath}/%{name}-root
Prereq: /sbin/install-info
Prereq: dev

%description
The which command shows the full pathname of a specified program, if
the specified program is in your PATH.

%prep
%setup -q
%patch -p1 -b .afs
%patch1 -p1 -b .broken

%build
%configure

make

%install
rm -rf $RPM_BUILD_ROOT

%makeinstall
mkdir -p $RPM_BUILD_ROOT/etc/profile.d
install -m 755 %{SOURCE1} $RPM_BUILD_ROOT/etc/profile.d

%post
/sbin/install-info --quiet --info-dir=%{_infodir} %{_infodir}/which.info.gz > /dev/null 2>&1

%preun
if [ $1 = 0 ]; then
   /sbin/install-info --quiet --info-dir=%{_infodir} --delete %{_infodir}/which.info.gz > /dev/null 2>&1
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc EXAMPLES README AUTHORS NEWS
%{_bindir}/*
%config /etc/profile.d/which-2.*
%{_infodir}/which.info.gz
%{_mandir}/*/*

%changelog
* Sat Aug 07 2004 Than Ngo <than@redhat.com> 2.16-4
- add missing URL (thanks to  Robert Scheck)

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Sep 24 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 2.16
- fix %%preun

* Thu Jul 17 2003 Than Ngo <than@redhat.com> 2.14-8
- rebuild

* Thu Jul 17 2003 Than Ngo <than@redhat.com> 2.14-7
- added Prereq: dev (bug #99275)

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Tue Dec 10 2002 Than Ngo <than@redhat.com> 2.14-4
- cleanup code (bug #78478)

* Thu Nov 14 2002 Tim Powers <timp@redhat.com> 2.14-3
- redirect info dir warnings to /dev/null

* Thu Nov  7 2002 Than Ngo <than@redhat.com> 2.14-1
- add missing info file

* Mon Jul 29 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 2.14 wih better support for current bash

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Feb 27 2002 Than Ngo <than@redhat.com> 2.13-3
- use access instead stat in AFS environment (bug #60353)

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Dec 05 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 2.13

* Sat Aug  4 2001 Than Ngo <than@redhat.com>
- fix bug 50844

* Sun Jun 24 2001 Elliot Lee <sopwith@redhat.com>
- Bump release + rebuild.

* Sun Sep 10 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- 2.12 (only man-page fix)

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sun Jun 18 2000 Than Ngo <than@redhat.de>
- FHS packaging.

* Sun May 21 2000 Ngo Than <than@redhat.de>
- put man pages in /usr/share/man/*

* Thu Apr 20 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 2.11
- change from root:bin -> root:root

* Mon Feb 07 2000 Preston Brown <pbrown@redhat.com>
- rebuild to gzip man page

* Sun Jan 16 2000 Preston Brown <pbrown@redhat.com>
- newer stuff rom Carlo (2.10).  Author's email: carlo@gnu.org

* Thu Jan 13 2000 Preston Brown <pbrown@redhat.com>
- adopted Carlo's specfile.

* Fri Sep 24 1999 Carlo Wood <carlo@gnu.org>
- There should not be a reason anymore to include README.alias in the rpm docs.
- Don't install as root.root in RPM_BUILD_ROOT, in order to allow to build
  rpm as non-root.
- Bug fix
- Added /etc/profile.d for automatic alias inclusion.

* Wed Aug 25 1999 Carlo Wood <carlo@gnu.org>
- Added README.alias.

* Wed Aug 11 1999 Carlo Wood <carlo@gnu.org>
- Typo in comment.

* Thu May 27 1999 Carlo Wood <carlo@gnu.org>
- Typo fix
- Moved maintainer targets from makefile to Makefile.am.

* Tue May 18 1999 Carlo Wood <carlo@gnu.org>
- Typo in appended changelog.
- Appended the old change log of `which-2.0.spec' to (this) changelog,
  which is generated from the CVS log of `which-2.0.spec.in'.
- Generate which-2.spec from which-2.spec.in with automatic VERSION
  and CHANGELOG substitution.

* Tue May 14 1999 Carlo Wood <carlo@gnu.org>
- Moved assignment of CFLAGS to the configure line, using RPM_OPT_FLAGS now.
- Corrected Source: line to point to ftp.gnu.org.

* Sat Apr 17 1999 Carlo Wood <carlo@gnu.org>
- Started to use automake and autoconf

* Fri Apr 09 1999 Carlo Wood <carlo@gnu.org>
- Renamed which-2.0.spec to which-2.spec

