Summary: A small utility for safely making /tmp files.
Name: mktemp
Version: 1.5
Release: 10
Epoch: 2
License: BSD
Group: System Environment/Base
Source: ftp://ftp.mktemp.org/pub/%{name}/%{name}-%{version}.tar.gz
Url: http://www.mktemp.org
Buildroot: %{_tmppath}/%{name}-root

%description
The mktemp utility takes a given file name template and overwrites a
portion of it to create a unique file name.  This allows shell scripts
and other programs to safely create and use /tmp files.

Install the mktemp package if you need to use shell scripts or other
programs which will create and use unique /tmp files.

%prep
%setup -q

%build
%configure
make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall
mkdir -p ${RPM_BUILD_ROOT}/bin
mv $RPM_BUILD_ROOT%{_bindir}/mktemp $RPM_BUILD_ROOT/bin

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/bin/mktemp
%doc LICENSE
%{_mandir}/man1/mktemp.*

%changelog
* Wed Oct 06 2004 Than Ngo <than@redhat.com> 2:1.5-10
- fix Url #134804

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Feb 17 2004 Than Ngo <than@redhat.com> 2:1.5-8
- add LICENSE file, #115994
  
* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Nov 28 2003 Phil Knirsch <pknirsch@redhat.com> 2:1.5-6
- Bumped release and rebuilt.

* Tue Nov 18 2003 Phil Knirsch <pknirsch@redhat.com> 2:1.5-1
- Fix tarball name and use Epoch instead for versioning.

* Wed Oct 01 2003 Phil Knirsch <pknirsch@redhat.com> 1.5.1-1
- Update to latest version from www.mktemp.org.

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Thu Nov 21 2002 Elliot Lee <sopwith@redhat.com>
- Pass __cc macro to make for cross-compilation

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jun 19 2002 Than Ngo <than@redhat.com> 1.5-16
- don't forcibly strip binaries
- clean up a patch file

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Sun Mar 31 2002 Than Ngo <than@redhat.com> 1.5-14
- fix bug #62326

* Tue Feb 26 2002 Than Ngo <than@redhat.com> 1.5-13
- rebuild
- Copyrigh->License

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue May  8 2001 Than Ngo <than@redhat.com>
- fix typo in mkdtemp, thanks to sagami@mbc.nifty.com (bug #39713)

* Mon May  7 2001 Than Ngo <than@redhat.com>
- fix manpage (bug #39392)
- cleanup specfile

* Mon Apr  2 2001 Nalin Dahyabhai <nalin@redhat.com>
- rework locally-supplied mkdtemp() to handle EEXIST better

* Mon Feb  5 2001 Preston Brown <pbrown@redhat.com>
- -d option is now supported, remove manpage patch (#25969)

* Thu Dec 14 2000 Helge Deller <deller@gmx.de>
- rewrite mkdtemp() from glibc2.2 for usage under glibc2.1

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sat Jul  1 2000 Nalin Dahyabhai <nalin@redhat.com>
- re-enable the -d option, because glibc provides a mkdtemp() function now
  (except for ia64)

* Sun Jun 18 2000 Matt Wilson <msw@redhat.com>
- FHS packaging
- fixed non root build

* Mon Feb  7 2000 Bill Nottingham <notting@redhat.com>
- handle compressed manpages

* Mon Mar 22 1999 Erik Troan <ewt@redhat.com>
- sync'd man page with openbsd latest, and updated it for some Linux-specific
  changes

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 5)

* Tue Dec 29 1998 Cristian Gafton <gafton@redhat.com>
- build for 6.0

* Thu May 07 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Wed Oct 01 1997 Erik Troan <ewt@redhat.com>
- moved to /bin

