%define which_xterm xterm-old
Summary: The terminal feature database used by certain applications.
Name: termcap
Epoch: 1
Version: 5.4
Release: 3
License: Public Domain
Group: System Environment/Base
Source0: ftp://dickey.his.com/ncurses/ncurses-5.4.tar.gz
Source1: ftp://dickey.his.com/ncurses/5.4/patch-5.4-20040711.sh
Patch0: ncurses-5.4-kon2.patch
Patch1: ncurses-5.4-bterm.patch
Patch2: ncurses-5.4-which_xterm.patch
Patch10: ncurses-5.4-linux-console-color.patch
Patch20: ftp://dickey.his.com/ncurses/5.4/ncurses-5.4-20040718.patch.gz
Patch21: ftp://dickey.his.com/ncurses/5.4/ncurses-5.4-20040724.patch.gz
Patch22: ftp://dickey.his.com/ncurses/5.4/ncurses-5.4-20040731.patch.gz
Patch23: ftp://dickey.his.com/ncurses/5.4/ncurses-5.4-20040807.patch.gz
Patch24: ftp://dickey.his.com/ncurses/5.4/ncurses-5.4-20040814.patch.gz
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-root
BuildPrereq: bash, ncurses, sed, sharutils

%description
The termcap package provides the /etc/termcap file.  /etc/termcap is a
database which defines the capabilities of various terminals and
terminal emulators.  Certain programs use the /etc/termcap file to
access various features of terminals (the bell, colors, and graphics,
etc.).

%prep
%setup -q -n ncurses-5.4
# Apply upstream interim patches.
sh %{SOURCE1}
%patch20 -p1 -b .20040718
%patch21 -p1 -b .20040724

# The ncurses package isn't here yet.
#%patch22 -p1 -b .20040731
#%patch23 -p1 -b .20040807
#%patch24 -p1 -b .20040814

# Add definitions for kon2 and (bogl-)bterm, which include their own terminfo
# database files, but which need to be here for libtermcap's users.
%patch0 -p1 -b .kon2
%patch1 -p1 -b .bterm
# Handle the "what's xterm supposed to be?" configurable thingy.
%patch2 -p1 -b .which_xterm
pushd misc
cat terminfo.src | sed -e s,use=@WHICH_XTERM@,use=%{which_xterm},g > terminfo.src2 && cat terminfo.src2 > terminfo.src && rm terminfo.src2
popd

# If we're targeting Linux, make "console" an alias for either "linux" or
# "linux-m", as appropriate.  Is even correct for SPARC any more?
%ifos linux
%patch10 -p1 -b .linux-console-color
%endif

tic -Ct misc/terminfo.src > misc/termcap.src

%install
mkdir -p $RPM_BUILD_ROOT/etc
install -m644 misc/termcap.src $RPM_BUILD_ROOT/etc/termcap

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%config /etc/termcap

%changelog
* Mon Aug 23 2004 Nalin Dahyabhai <nalin@redhat.com> 1:5.4-3
- add missing sharutils buildprereq (needed for rollup patch, maybe #130551)

* Fri Aug 20 2004 Nalin Dahyabhai <nalin@redhat.com> 1:5.4-2
- mingetty sets $TERM to 'linux', so switching between monochrome and color by
  playing with the 'console' alias gets us nowhere; back to noarch for now
  (Bill Nottingham)

* Thu Aug 19 2004 Nalin Dahyabhai <nalin@redhat.com> 1:5.4-1
- update to current upstream termcap, building to match the most current
  ncurses available (#116330)
- termcap used to be noarch, but that is impossible with per-arch patches (this
  could come back to haunt us in multilib environments if care is not taken),
  so make it arch-specific again
- make 'console' an alias for either 'linux' or 'linux-m' depending on whether
  or not the usual console supports color -- this means 'linux' for most
  arches, and 'linux-m' for sparc*
- add a definition for 'bterm' (bogl-bterm installs its own terminfo file)
- use terminfo source instead of termcap source for 'kon2' (kon2 installs its
  own terminfo file)
- approximate ncurses's --with-xterm-new as a local %%{which_xterm} define

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Sep  3 2003 Bill Nottingham <notting@redhat.com> 11.0.1-17.1
- rebuild in different environment

* Thu Aug  7 2003 Elliot Lee <sopwith@redhat.com>
- Remove unpackaged files (/etc/termcap.orig)

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Thu Dec 26 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- Patches to /etc/termcap have not been properly applied. Disabled
  Patch2:kterm (already applied) and Patch3:rxvt (not needed anymore)
- Why are patches only applied to /etc/termcap and not the terminfo/termcap
  source file??

* Wed Nov 27 2002 Tim Powers <timp@redhat.com> 11.0.1-14
- remove unpackaged files from the buildroot

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Fri Jul 20 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix scoansi

* Tue Jun 26 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- add termcap entry from the kon2 rpm

* Wed Mar 14 2001 Tim Powers <timp@redhat.com>
- fixed license

* Wed Feb 22 2001 Harald Hoyer <harald@redhat.de>
- fixed end key for rxvt

* Fri Feb  9 2001 Yukihiro Nakai <ynakai@redhat.com>
- Add rxvt entry fix patch

* Wed Dec 20 2000 Yukihiro Nakai <ynakai@redhat.com>
- Add kterm entry fix patch

* Mon Oct 16 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Build termcap from the terminfo source file in ncurses, so they're
  finally in sync (Bug #13090)

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Thu Jun 29 2000 Bill Nottingham <notting@redhat.com>
- defattr

* Mon Mar 20 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 11.0.1

* Mon Mar 06 2000 Preston Brown <pbrown@redhat.com>
- add end key mappings for linux console (fix /bin/vi)

* Sat Mar 04 2000 Preston Brown <pbrown@redhat.com>
- remove typo

* Tue Feb 29 2000 Preston Brown <pbrown@redhat.com>
- shifted fkey 3-20 added for xterm

* Fri Feb 18 2000 Preston Brown <pbrown@redhat.com>
- xterm entries from XFree86 3.3.6.
- completely apply debian policy for backspace and delete.

* Sun Feb  5 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix xterm (#9141)

* Tue Feb 01 2000 Preston Brown <pbrown@redhat.com>
- small patch from Hans for xterm (#8634), revert HJ fix.

* Tue Feb 01 2000 Cristian Gafton <gafton@redhat.com>
- sync the xterm entry with the XFree86 3.3.6 one

* Tue Jan 18 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Add patch form Hans de Goede <hans@highrise.nl> to get the termcap
  descriptions in sync with the terminfo (ncurses) ones
- make it a noarch package

* Sun Nov 21 1999 Bernhard Rosenkraenzer <bero@redhat.com>
- 10.2.7 - this should finally fix the "telnet from FreeBSD to Linux"
  problem

* Mon Oct 18 1999 Preston Brown <pbrown@redhat.com>
- xterm termcap patch from H.J. Lu; claims fixes xterm under 6.1

* Mon Mar 29 1999 Jeff Johnson <jbj@redhat.com>
- termcap used to be noarch but that is impossible with per-arch patches

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 14)

* Fri Mar 12 1999 Jeff Johnson <jbj@redhat.com>
- merge sparc console termcap (from termfiles_sparc).

* Wed Dec 30 1998 Cristian Gafton <gafton@redhat.com>
- rebuild for glibc 2.1

* Thu May 07 1998 Erik Troan <ewt@redhat.com>
- added linux-lat entry
- build rooted

* Fri May 01 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Thu Oct 23 1997 Erik Troan <ewt@redhat.com>
- made a noarch package

