Summary: A tool for determining compilation options.
Name: pkgconfig
Version: 0.15.0
Release: 3
Epoch: 1
License: GPL
Group: Development/Tools
Source:  http://www.freedesktop.org/software/pkgconfig/releases/%{name}-%{version}.tar.gz
BuildPrereq: autoconf213 automake14
# http://x2.freedesktop.org/cgi-bin/bugzilla/show_bug.cgi?id=125
Patch1:  pkgconfig-0.14.0-lib64.patch
# http://x2.freedesktop.org/cgi-bin/bugzilla/show_bug.cgi?id=119
Patch2:  pkgconfig-0.14.0-datadir.patch
Patch3:  pkgconfig-0.15.0-quote.patch
BuildRoot: %{_tmppath}/%{name}-root

%description
The pkgconfig tool determines compilation options. For each required
library, it reads the configuration file and outputs the necessary
compiler and linker flags.

%prep
%setup -q
%patch1 -p1 -b .lib64
%patch2 -p1 -b .datadir
%patch3 -p1 -b .quote
autoheader-2.13
autoconf-2.13
automake-1.4

%build
%configure
make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall
mkdir -p $RPM_BUILD_ROOT%{_libdir}/pkgconfig
strip $RPM_BUILD_ROOT%{_bindir}/*

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_mandir}/*/*
%{_bindir}/*
%{_libdir}/pkgconfig
%{_datadir}/aclocal/*

%changelog
* Wed Jun 23 2004 Matthias Clasen <mclasen@redhat.com> 1:0.15.0-3
- fix underquoted definition in pkg.m4  (#116128)

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Feb 24 2004 Mark McLoughlin <markmc@redhat.com>
- Update to 0.15.0
- Fix datadir patch conflict

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Oct 23 2003 Owen Taylor <otaylor@redhat.com> 1:0.14.0-6
- Make pkgconfig look in /usr/share/pkgconfig as well by default (#98595)

* Thu Jun 26 2003 Havoc Pennington <hp@redhat.com> 1:0.14.0-5
- rebuild

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Feb 10 2003 Nalin Dahyabhai <nalin@redhat.com>
- suppress /usr/lib64 (instead of /usr/lib) from LIBS by default on multilib
  arches where the default is to use lib64

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Fri Nov  8 2002 Havoc Pennington <hp@redhat.com>
- 0.14

* Tue Oct  8 2002 Havoc Pennington <hp@redhat.com>
- use libdir, so we do move .pc files to /usr/lib64

* Tue Oct  8 2002 Havoc Pennington <hp@redhat.com>
- use prefix/lib not libdir, so we don't move .pc files to /usr/lib64

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu Mar  7 2002 Havoc Pennington <hp@redhat.com>
- 0.12.0

* Thu Feb  7 2002 Havoc Pennington <hp@redhat.com>
- 0.11.0

* Sun Feb  3 2002 Havoc Pennington <hp@redhat.com>
- backbuild in gnomehide

* Sun Feb  3 2002 Havoc Pennington <hp@redhat.com>
- 0.10.0

* Sun Feb  3 2002 Havoc Pennington <hp@redhat.com>
- 0.9.0

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jun 13 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- call libtoolize to make porting to new archs easier

* Thu Jun 07 2001 Havoc Pennington <hp@redhat.com>
- put pkg.m4 in file list

* Wed Jun 06 2001 Havoc Pennington <hp@redhat.com>
- Upgrade to 0.7
- add man page

* Wed Jan 03 2001 Havoc Pennington <hp@redhat.com>
- Upgrade to 0.5

* Thu Dec 14 2000 Bill Nottingham <notting@redhat.com>
- rebuild because of broken fileutils

* Wed Oct 04 2000 Owen Taylor <otaylor@redhat.com>
- Initial package
