%if %{?WITH_SELINUX:0}%{!?WITH_SELINUX:1}
%define WITH_SELINUX 1
%endif
%if %{?WITH_PAM:0}%{!?WITH_PAM:1}
%define WITH_PAM 1
%endif
Summary: The Vixie cron daemon for executing specified programs at set times.
Name: vixie-cron
Version: 4.1
Release: 24_FC3
Epoch:   1
License: distributable
Group:   System Environment/Base
Source0: ftp://ftp.isc.org/isc/cron/vixie-cron-%{version}.tar.gz
Source1: vixie-cron.init
Source2: crond.sysconfig
Patch0:  vixie-cron-4.1-_0_rh_Makefile.patch
Patch1:  vixie-cron-4.1-_1_rh_pathnames.patch
Patch2:  vixie-cron-4.1-_2_config.patch
Patch3:  vixie-cron-4.1-_3_selinux.patch
Patch4:  vixie-cron-4.1-_4_vfork_sigchld.patch
Patch5:  vixie-cron-4.1-_5_sprintf_misc.patch
Patch6:  vixie-cron-4.1-_6_rh_crond.patch
Patch7:  vixie-cron-4.1-_7_crontab-stdin.patch
Patch8:  vixie-cron-4.1-_8_root-allowed.patch
Patch9:  vixie-cron-4.1-_9_no-header.patch
Patch10: vixie-cron-4.1-_10_manpages.patch
Patch11: vixie-cron-4.1-_11_with_selinux.patch
Patch12: vixie-cron-4.1-_12_pam.patch
Patch13: vixie-cron-4.1-_13_with_pam.patch
Patch14: vixie-cron-4.1-_14_pamd_crond.patch
Patch15: vixie-cron-4.1-_15_system_crontab_user.patch
Patch16: vixie-cron-4.1-_16_crontab_selinux.patch
Patch17: vixie-cron-4.1-_17_pam-rootok.patch
Patch18: vixie-cron-4.1-_18_cron_log_facility.patch
Patch19: vixie-cron-4.1-_19_crontab_stat_not_fstat.patch
Patch20: vixie-cron-4.1-_20_nickname_man.patch
Patch21: vixie-cron-4.1-_21_-i_option.patch
Patch22: vixie-cron-4.1-_22_no_0600_mode_enforce.patch
Patch23: vixie-cron-4.1-_23_freecon_segv.patch
Patch24: vixie-cron-4.1-_24_crontab_selinux_new.patch
Patch25: vixie-cron-4.1-_25-allow-root-crontab.patch
Patch26: vixie-cron-4.1-_26-saved-uids.patch
Patch27: vixie-cron-4.1-_27-no-strip-header-comments.patch
Patch28: vixie-cron-4.1-_28-fix_ppc.patch
Patch29: vixie-cron-4.1-_29-permit_any_crontab_option.patch
Patch30: vixie-cron-4.1-_30-uninitialized.patch
Patch31: vixie-cron-4.1-_31-allow_pam_access.patch
Patch32: vixie-cron-4.1-_32-no_mail_rcpt_safe_p.patch

Buildroot: %{_tmppath}/%{name}-%{version}-root
Requires: sysklogd >= 1.3.33-6, bash >= 2.0
%if %{WITH_SELINUX}
Requires: libselinux
Buildrequires: libselinux-devel
%endif
%if %{WITH_PAM}
Requires: pam
Buildrequires: pam-devel
%endif

Prereq: /sbin/chkconfig /etc/init.d /sbin/service

%description
The vixie-cron package contains the Vixie version of cron.  Cron is a
standard UNIX daemon that runs specified programs at scheduled times.
Vixie cron adds better security and more powerful configuration
options to the standard version of cron.

%prep
%setup -q
%patch0 -p1 -b .rh_Makefile
%patch1 -p1 -b .rh_pathnames
%patch2 -p1 -b .config
%patch3 -p1 -b .selinux
%patch4 -p1 -b .vfork_sigchld
%patch5 -p1 -b .sprintf_misc
%patch6 -p1 -b .rh_crond
%patch7 -p1 -b .crontab-stdin
%patch8 -p1 -b .root-allowed
%patch9 -p1 -b .no-header
%patch10 -p1 -b .manpages
%if %{WITH_SELINUX}
#SELinux
# Enables SELinux support
%patch11 -p1 -b .with_selinux
%endif
%patch12 -p1 -b .pam
%if %{WITH_PAM}
%patch13 -p1 -b .with_pam
%patch14 -p1 -b .pamd_crond
%patch15 -p1 -b .system_crontab_user
%endif
%patch16 -p1 -b .crontab_selinux
%patch17 -p1 -b .pam-rootok
%patch18 -p1 -b .cron_log_facility
%patch19 -p1 -b .crontab_stat_not_fstat
%patch20 -p1 -b .nickname_man
%patch21 -p1 -b -i_option
%patch22 -p1 -b .no_0600_mode_enforce
%if %{WITH_SELINUX}
%patch23 -p1 -b .freecon_segv
%patch24 -p1 -b .selinux_crontab_new
%endif
%patch25 -p1 -b .allow-root-crontab
%patch26 -p1 -b .saved_uids
%patch27 -p1 -b .no-strip-header-comments
%patch28 -p1 -b .fix_ppc
%patch29 -p1 -b .permit_any_crontab_option
%patch30 -p1 -b .uninitialized
%patch31 -p1 -b .allow_pam_access
%patch32 -p1 -b .no_mail_rcpt_safe_p.patch

%build
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/{bin,sbin}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man{1,5,8}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/etc/pam.d
make install DESTDIR=$RPM_BUILD_ROOT DESTMAN=$RPM_BUILD_ROOT%{_mandir}
mkdir -p $RPM_BUILD_ROOT/var/spool/cron
chmod 700 $RPM_BUILD_ROOT/var/spool/cron
mkdir -p $RPM_BUILD_ROOT/etc/cron.d
chmod 755 $RPM_BUILD_ROOT/etc/cron.d
install -m755 $RPM_SOURCE_DIR/vixie-cron.init $RPM_BUILD_ROOT/etc/rc.d/init.d/crond
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/
cp %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/crond

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add crond
[ ! -f /etc/cron.allow ] && [ ! -f /etc/cron.deny ] && touch /etc/cron.deny ||:;
 
%preun
if [ "$1" = 0 ]; then
    [ -f /var/lock/subsys/crond ] && /sbin/service crond stop >/dev/null 2>&1
    /sbin/chkconfig --del crond
fi

%postun
if [ "$1" -ge "1" ]; then
	/sbin/service crond condrestart >/dev/null 2>&1
fi

%triggerpostun -- vixie-cron < 3.0.1-56
/sbin/chkconfig --del crond
/sbin/chkconfig --add crond

%files

%defattr(-,root,root)
/usr/sbin/crond
/usr/bin/crontab
%{_mandir}/man8/crond.*
%{_mandir}/man8/cron.*
%{_mandir}/man5/crontab.*
%{_mandir}/man1/crontab.*
%dir /var/spool/cron
%dir /etc/cron.d
%config /etc/rc.d/init.d/crond
%config /etc/pam.d/crond
%config(noreplace) /etc/sysconfig/crond

%changelog
* Fri Feb 25 2005 Jason Vas Dias <jvdias@redhat.com> - 4.1-24_FC3
- Add an /etc/sysconfig/crond file for containing CRONDARGS and
- settings like CRON_VALIDATE_MAILRCPTS .

* Fri Feb 25 2005 Jason Vas Dias <jvdias@redhat.com> - 4.1-24_FC3
- Fix bug 147636 - disable silly mail recipient name checking 
- (do_command.c's safe_p()) by default . Can be enabled by 
- presence of CRON_VALIDATE_MAILRCPTS variable in crond's 
- environment - also '_'s in MAILTOs are allowed.

* Tue Jan 25 2005 Jason Vas Dias <jvdias@redhat.com> - 4.1-21_FC3
- Fix bug 146073 - allow the 'pam_access' module to be used with
- cron - set 'PAM_TTY' item to 'cron' .

* Wed Dec 20 2004 Jason Vas Dias <jvdias@redhat.com> - 4.1-20_FC3
- fix bug 142953 : allow read-only crontabs + provide -p 
- 'permit all crontabs' option to disable mode checking. 
- bug 135845 fix required 'ch' to be initialized in crontab.c line 322
- (bug 141760)

* Wed Dec 20 2004 Jason Vas Dias <jvdias@redhat.com> - 4.1-20_FC3
- fixed all uninitialized variable warnings

* Fri Oct 15 2004 Jason Vas Dias <jvdias@redhat.com> - 4.1-19
- crontab -e should only strip NHEADER_LINES comments 
- (NHEADER_LINES==0), not at least one header comment line.
- (bug 135845)

* Sat Oct 09 2004 Florian La Roche <laroche@redhat.com> - 4.1-18
- no need to make user installed crontabs readable

* Thu Sep 30 2004 Jason Vas Dias <jvdias@redhat.com> - 4.1-17
- Users not allowed to use 'crontab mycrontab', while
- 'crontab < mycrontab' allowed; this is because misc.c's
- swap_uids_back() was not using save_euid / save_egid .
- Thanks to Mads Martin Joergensen <mmj@suse.de> for pointing this out.

* Wed Sep 29 2004 Jason Vas Dias <jvdias@redhat.com> - 4.1-16
- Just found out in testing that if neither /etc/cron.{deny,allow}
- exist, root is unable to use crontab - I'm sure root could before,
- but is in any case meant to be able to. Allowing root to use crontab.

* Wed Sep 29 2004 Jason Vas Dias <jvdias@redhat.com> - 4.1-14
- Fix for bug 130102 got dropped somehow from latest CVS.
- This is now restored - in %post, if neither /etc/cron.{deny,allow}
- exist, touch /etc/cron.deny, to allow all users to use crontab,
- as was previous default vixie-cron behaviour.

* Fri Sep 17 2004 Jason Vas Dias <jvdias@redhat.com> - 4.1-12
- Merged Dan's patch with vixie-cron-4.1-11 which was not 
- latest version according to new CVS ?!?!

* Fri Sep 17 2004 Dan Walsh <dwalsh@redhat.com>  - 4.1-12
- Updated SELinux patch to use checkPasswdAccess

* Tue Aug 31 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1-11
- Fixed SIGSEGV in free_user when !is_selinux_enabled() and crontab
- has no valid jobs (bug 131390).

* Wed Aug 18 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1.10
- Fixed bug 130102: Restored default behaviour if neither 
- /etc/cron.deny nor /etc/cron.allow exist - 'touch /etc/cron.deny'
- in %post

* Wed Aug 11 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1.9
- Removed 0600 mode enforcement as per Florian La Roche's request

* Tue Aug 10 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1.8
- Allowed editors such as 'gedit' which do not modify original
- file, but which rename(2) a temp file to original, to be used
- by crontab -e (bug 129170).

* Tue Aug 10 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1.8
- Added '-i' option to crontab to prompt the user before deleting
- crontab with '-r'.

* Tue Aug 10 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1.8
- Added documentation for '@' nicknames to crontab.5
- (bugs 107542, 89899). Also removed 'second when' (bug 59802). 

* Sun Aug 1  2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1.7
- fixed bug 128924: 'cron' log facility not being used

* Fri Jul 30 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1.6
- Added PAM 'auth sufficient pam_rootok.so' to /etc/pam.d/crond
- (fixes bug 128843) - on dwalsh's advice.

* Thu Jul 29 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1-5
- Added Buildrequires: pam-devel

* Wed Jul 28 2004 Dan Walsh <dwalsh@redhat.com> - 4.1-4
- Fix crontab to do SELinux checkaccess

* Wed Jul 28 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1-3
- Fixed bug 128701: cron fails to parse user 6th field in
- system crontabs (patch15)

* Tue Jul 27 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1-2
- Changed 'Requires' dependency from 'pam-devel' to 'pam'.

* Mon Jul 26 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1-1
- Added PAM access control support.

* Thu Jul 22 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1-1
- Changed post-install to change mode of existing crontabs to
- 0600 to allow run by new ISC cron 4.1 

* Thu Jul 22 2004 Jason Vas Dias <jvdias@redhat.com>  - 4.1-1
- Upgraded to ISC cron 4.1

* Thu Jul  1 2004 Jens Petersen <petersen@redhat.com> - 3.0.1-94
- add vixie-cron-3.0.1-cron-descriptors-125110.patch to close std descriptors
  when forking (Bernd Schmidt, 121280)
- add vixie-cron-3.0.1-no-crontab-header-89809.patch to not prepend header to
  crontab files (Damian Menscher, 103899)
- fix use of RETVAL in init.d script (Enrico Scholz, 97784)
- add safer malloc call to vixie-cron-3.0.1-sprintf.patch 
- add cron-3.0.1-crontab-syntax-error-114386.patch to fix looping on crontab
  syntax error (Miloslav Trmac, 89937)

* Fri Jun 25 2004 Dan Walsh <dwalsh@redhat.com> - 3.0.1-93
- Add fixes from NSA 

* Tue Jun 22 2004 Dan Walsh <dwalsh@redhat.com> - 3.0.1-92
- Add fixes from NSA 

* Tue Jun 15 2004 Dan Walsh <dwalsh@redhat.com> - 3.0.1-91
- Change patch to check SElinux properly, go back to using fname instead of uname

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Jun 4 2004 Dan Walsh <dwalsh@redhat.com> - 3.0.1-89
- Fix patch

* Fri Jun 4 2004 Dan Walsh <dwalsh@redhat.com> - 3.0.1-88
- Add patch to allow it to run in permissive mode.

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Feb 4 2004 Dan Walsh <dwalsh@redhat.com> - 3.0.1-86
- Add security_getenforce check.

* Mon Jan 26 2004 Dan Walsh <dwalsh@redhat.com> - 3.0.1-85
- Fix call to is_selinux_enabled()

* Mon Dec 8 2003 Dan Walsh <dwalsh@redhat.com> - 3.0.1-84
- change daemon flag to 1

* Wed Dec 3 2003 Dan Walsh <dwalsh@redhat.com> - 3.0.1-83
- Add daemon to make sure child is clean

* Fri Nov  7 2003 Jens Petersen <petersen@redhat.com> - 3.0.1-82
- add vixie-cron-3.0.1-pie.patch to build crond as pie (#108414)
  [Ulrich Drepper]
- require libselinux and buildrequire libselinux-devel

* Thu Oct 30 2003 Dan Walsh <dwalsh@redhat.com> - 3.0.1-81.sel
- turn on selinux

* Tue Sep 30 2003 Jens Petersen <petersen@redhat.com> - 3.0.1-80
- add vixie-cron-3.0.1-vfork-105616.patch to use fork instead of vfork
  (#105616) [report and patch from ian@caliban.org]
- update vixie-cron-3.0.1-redhat.patch not to change DESTMAN redundantly
  (it is overrriden in the spec file anyway)

* Fri Sep 5 2003 Dan Walsh <dwalsh@redhat.com> - 3.0.1-79
- turn off selinux

* Fri Sep 5 2003 Dan Walsh <dwalsh@redhat.com> - 3.0.1-78.sel
- turn on selinux

* Tue Jul 29 2003 Dan Walsh <dwalsh@redhat.com> - 3.0.1-77
- Patch to run on SELinux

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Mar 19 2003 Jens Petersen <petersen@redhat.com> - 3.0.1-75
- add vixie-cron-3.0.1-root_-u-85879.patch from Valdis Kletnieks to allow
  root to run "crontab -u <user>" even for users that aren't allowed to

* Wed Feb 19 2003 Jens Petersen <petersen@redhat.com> - 3.0.1-74
- fix preun script typo (#75137) [reported by Peter Bieringer]

* Tue Feb 11 2003 Bill Nottingham <notting@redhat.com> 3.0.1-73
- don't set SIGCHLD to SIG_IGN and then try and wait... (#84046)

* Fri Feb  7 2003 Nalin Dahyabhai <nalin@redhat.com> 3.0.1-72
- adjust cron.d patch so that it ignores file with names that begin with '#'
  or end with '~', '.rpmorig', '.rpmsave', or '.rpmnew'
- merge hunk of buffer overflow patch into the cron.d patch

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Wed Dec 11 2002 Tim Powers <timp@redhat.com> 3.0.1-70
- rebuild on all arches

* Sat Jul 20 2002 Akira TAGOH <tagoh@redhat.com> 3.0.1-69
- vixie-cron-3.0.1-nonstrip.patch: applied to fix the stripped binary issue.

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Jun 10 2002 Bill Huang <bhuang@redhat.com>
- Fix preun bugs.(#55340)
- Fix fprintf bugs.(#65209)

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Apr 15 2002 Bill Huang <bhuang@redhat.com>
- Fixed #62963.

* Thu Apr 04 2002 James McDermott <jmcdermo@redhat.com>
- Alter behavior of crontab to take stdin as the default
  behavior if no options are specified. 

* Sun Jun 24 2001 Elliot Lee <sopwith@redhat.com>
- Bump release + rebuild.

* Thu Mar  8 2001 Bill Nottingham <notting@redhat.com>
- add patch from Alan Eldridge <alane@geeksrus.net> to
  fix double execution of jobs (#29868)

* Mon Feb 11 2001 Bill Nottingham <notting@redhat.com>
- fix buffer overflow in crontab

* Wed Feb  7 2001 Trond Eivind Glomsrød <teg@redhat.com>
- fix usage string in initscript (#26533)

* Tue Feb  6 2001 Bill Nottingham <notting@redhat.com>
- fix build with new glibc (#25931)

* Tue Jan 23 2001 Bill Nottingham <notting@redhat.com>
- change i18n mechanism

* Fri Jan 19 2001 Bill Nottingham <notting@redhat.com>
- log as 'crond', not 'CROND' (#19410)
- account for shifts in system clock (#23230, patch from <pererik@onedial.se>)
- i18n-ize initscript

* Thu Aug 24 2000 Than Ngo <than@redhat.com>
- fix to set startup position correct at update

* Wed Aug 24 2000 Than Ngo <than@redhat.com>
- add /sbin/service to Prereq
- call /sbin/service instead service
- fix startup position (Bug #13353)

* Mon Aug  7 2000 Bill Nottingham <notting@redhat.com>
- fix crond logging patch (dan@doom.cmc.msu.ru)
- log via syslog (suggestion from jos@xos.nl)
- put system crontab location in crontab(5) (#14842)

* Fri Jul 28 2000 Bill Nottingham <notting@redhat.com>
- fix condrestart

* Fri Jul 21 2000 Bill Nottingham <notting@redhat.com>
- fix reload bug (#14065)

* Fri Jul 14 2000 Bill Nottingham <notting@redhat.com>
- move initscript back

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Thu Jul  6 2000 Bill Nottingham <notting@redhat.com>
- prereq /etc/init.d

* Mon Jul  3 2000 Bill Nottingham <notting@redhat.com>
- fix %%post; we do condrestart in %%postun

* Thu Jun 29 2000 Bill Nottingham <notting@redhat.com>
- oops, fix init script

* Tue Jun 27 2000 Bill Nottingham <notting@redhat.com>
- require new initscripts, not prereq

* Mon Jun 26 2000 Bill Nottingham <notting@redhat.com>
- initscript hacks

* Wed Jun 14 2000 Nalin Dahyabhai <nalin@redhat.com>
- tweak logrotate config

* Sun Jun 11 2000 Bill Nottingham <notting@redhat.com>
- rebuild in new env.
- FHS fixes
- don't ship chkconfig links

* Fri Mar 31 2000 Bill Nottingham <notting@redhat.com>
- fix non-root builds (#10490)

* Sun Mar 26 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- do not remove log files

* Thu Feb  3 2000 Bill Nottingham <notting@redhat.com>
- handle compressed man pages

* Fri Sep 10 1999 Bill Nottingham <notting@redhat.com>
- chkconfig --del in %preun, not %postun

* Wed Aug 25 1999 Bill Nottingham <notting@redhat.com>
- fix buffer overflow

* Mon Aug 16 1999 Bill Nottingham <notting@redhat.com>
- initscript munging

* Fri Jul 30 1999 Michael K. Johnson <johnsonm@redhat.com>
- dayofmonth and month can't be 0

* Thu Jun  3 1999 Jeff Johnson <jbj@redhat.com>
- in cron.log use "kill -HUP pid" not killall to preserve errors (#2241).

* Wed Apr 14 1999 Michael K. Johnson <johnsonm@redhat.com>
- add note to man page about DST conversion causing strangeness
- documented cron.d patch

* Tue Apr 13 1999 Michael K. Johnson <johnsonm@redhat.com>
- improved cron.d patch

* Mon Apr 12 1999 Erik Troan <ewt@redhat.com>
- added cron.d patch

* Tue Mar 23 1999 Bill Nottingham <notting@redhat.com>
- logrotate changes

* Tue Mar 23 1999 Preston Brown <pbrown@redhat.com>
- clean up log files on deinstallation

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 28)

* Wed Dec 30 1998 Cristian Gafton <gafton@redhat.com>
- build for glibc 2.1

* Wed Jun 10 1998 Prospector System <bugs@redhat.com>
- translations modified for de

* Wed Jun 10 1998 Jeff Johnson <jbj@redhat.com>
- reset SIGCHLD before grandchild execle (problem #732)

* Sat May 02 1998 Cristian Gafton <gafton@redhat.com>
- enhanced initscript

* Mon Apr 27 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Thu Dec 11 1997 Cristian Gafton <gafton@redhat.com>
- added a patch to get rid of the dangerous sprintf() calls
- added BuildRoot and Prereq: /sbin/chkconfig

* Sun Nov 09 1997 Michael K. Johnson <johnsonm@redhat.com>
- fixed cron/crond dichotomy in init file.

* Wed Oct 29 1997 Donnie Barnes <djb@redhat.com>
- fixed bad init symlinks

* Thu Oct 23 1997 Erik Troan <ewt@redhat.com>
- force it to use SIGCHLD instead of defunct SIGCLD

* Mon Oct 20 1997 Erik Troan <ewt@redhat.com>
- updated for chkconfig
- added status, restart options to init script

* Tue Jun 17 1997 Erik Troan <ewt@redhat.com>
- built against glibc

* Wed Feb 19 1997 Erik Troan <ewt@redhat.com>
- Switch conditional from "axp" to "alpha" 

