
_BEGIN_STD_C

#if defined(__arm__) || defined(__thumb__)
/*
 * All callee preserved registers:
 * v1 - v7, fp, ip, sp, lr, f4, f5, f6, f7
 */
#define _JBLEN 23
#endif

#ifdef __sparc__
/*
 * onsstack,sigmask,sp,pc,npc,psr,g1,o0,wbcnt (sigcontext).
 * All else recovered by under/over(flow) handling.
 */
#define	_JBLEN	13
#endif

/* necv70 was 9 as well. */

#ifdef __mc68000__
/*
 * onsstack,sigmask,sp,pc,psl,d2-d7,a2-a6,
 * fp2-fp7	for 68881.
 * All else recovered by under/over(flow) handling.
 */
#define	_JBLEN	34
#endif

#if defined(__mc68hc11__) || defined(__mc68hc12__) || defined(__mc68hc1x__)
/*
 * D, X, Y are not saved.
 * Only take into account the pseudo soft registers (max 32).
 */
#define _JBLEN  32
#endif

#if defined(__Z8001__) || defined(__Z8002__)
/* 16 regs + pc */
#define _JBLEN 20
#endif

#ifdef _AM29K
/*
 * onsstack,sigmask,sp,pc,npc,psr,g1,o0,wbcnt (sigcontext).
 * All else recovered by under/over(flow) handling.
 */
#define	_JBLEN	9
#endif

#if defined(__CYGWIN__) && !defined (_JBLEN)
#define _JBLEN (13 * 4)
#elif defined (__i386__)
#if defined(__unix__) || defined(__rtems__)
# define _JBLEN	9
#else
#include "setjmp-dj.h"
#endif
#endif

#ifdef __i960__
#define _JBLEN 35
#endif

#ifdef __M32R__
/* Only 8 words are currently needed.  10 gives us some slop if we need
   to expand.  */
#define _JBLEN 10
#endif

#ifdef __mips__
#ifdef __mips64
#define _JBTYPE long long
#endif
#ifdef __mips_soft_float
#define _JBLEN 11
#else
#define _JBLEN 23
#endif
#endif

/* start-sanitize-r5900 */
#ifdef __R5900__
/* allow for 11 128-bit registers and 8 32-bit FP regs */
#undef _JBLEN
#undef _JBTYPE
#define _JBLEN 13
typedef int __jmp_buf_elt __attribute__ ((mode(TI)));
#define _JBTYPE __jmp_buf_elt
#endif

/* end-sanitize-r5900 */
#ifdef __m88000__
#define _JBLEN 21
#endif

#ifdef __H8300__
#define _JBLEN 5
#define _JBTYPE int
#endif

#ifdef __H8300H__
/* same as H8/300 but registers are twice as big */
#define _JBLEN 5
#define _JBTYPE long
#endif

#if defined (__H8300S__) || defined (__H8300SX__)
/* same as H8/300 but registers are twice as big */
#define _JBLEN 5
#define _JBTYPE long
#endif

#ifdef __H8500__
#define _JBLEN 4
#endif

#ifdef  __sh__
#if __SH5__
#define _JBLEN 50
#define _JBTYPE long long
#else
#define _JBLEN 20
#endif /* __SH5__ */
#endif

#ifdef  __v800
#define _JBLEN 28
#endif

#ifdef __PPC__
#ifdef __ALTIVEC__
#define _JBLEN 64
#else
#define _JBLEN 32
#endif
#define _JBTYPE double
#endif

#ifdef __hppa__
/* %r30, %r2-%r18, %r27, pad, %fr12-%fr15.
   Note space exists for the FP registers, but they are not
   saved.  */
#define _JBLEN 28
#endif

#if defined(__mn10300__) || defined(__mn10200__)
#ifdef __AM33_2__
#define _JBLEN 26
#else
/* A guess */
#define _JBLEN 10
#endif
#endif

#ifdef __v850
/* I think our setjmp is saving 15 regs at the moment.  Gives us one word
   slop if we need to expand.  */
#define _JBLEN 16
#endif

#if defined(_C4x)
#define _JBLEN 10
#endif
#if defined(_C3x)
#define _JBLEN 9
#endif

#ifdef __TIC80__
#define _JBLEN 13
#endif

#ifdef __D10V__
#define _JBLEN 8
#endif

#ifdef __D30V__
#define _JBLEN ((64 /* GPR */ + (2*2) /* ACs */ + 18 /* CRs */) / 2)
#define _JBTYPE double
#endif

#ifdef __frv__
#define _JBLEN (68/2)  /* room for 68 32-bit regs */
#define _JBTYPE double
#endif

/* start-sanitize-ip */
#ifdef __IP2K__
#define _JBLEN (10)		/* Save PC, DP, SP, IP, FP */
#define _JBPC 0
#define _JBDP 2
#define _JBSP 4
#define _JBIP 6
#define _JBFP 8
#define _JBTYPE char
#endif

/* end-sanitize-ip */
/* start-sanitize-cra8500 */
#ifdef __cra8500__
#define _JBLEN (16)
#define _JBTYPE long
#endif

/* end-sanitize-cra8500 */
/* start-sanitize-nios */
#ifdef __nios__
#define _JBLEN 4	
#endif

/* end-sanitize-nios */
/* start-sanitize-ip */
#ifdef __ip4k__
#define _JBLEN 42
#endif

/* end-sanitize-ip */
#ifdef __fr30__
#define _JBLEN 10
#endif

#ifdef __iq2000__
#define _JBLEN 32
#endif

#ifdef __mcore__
#define _JBLEN 16
#endif

/* start-sanitize-calmrisc16 */
#ifdef __calmrisc16__
#define _JBLEN 10
#endif

/* end-sanitize-calmrisc16 */
/* start-sanitize-calmrisc32 */
#ifdef __calmrisc32__
#define _JBLEN 16
#endif

/* end-sanitize-calmrisc32 */
#ifdef __MMIX__
/* Using a layout compatible with GCC's built-in.  */
#define _JBLEN 5
#define _JBTYPE unsigned long
#endif

#ifdef __xstormy16__
/* 4 GPRs plus SP plus PC. */
#define _JBLEN 8
#endif

/* start-sanitize-cy16 */
#ifdef __cy16__
#define _JBLEN 24
#endif

/* end-sanitize-cy16 */
/* start-sanitize-ms1 */
#ifdef __ms1__
#define _JBLEN 16
#endif

/* end-sanitize-ms1 */
/* start-sanitize-mrisc1 */
#ifdef __mrisc1__
#define _JBLEN 16
#endif

/* end-sanitize-mrisc1 */
/* start-sanitize-mep */
#ifdef __mep__
/* 16 GPRs, pc, hi, lo */
#define _JBLEN 19
#endif

/* end-sanitize-mep */
#ifdef _JBLEN
#ifdef _JBTYPE
typedef	_JBTYPE jmp_buf[_JBLEN];
#else
typedef	int jmp_buf[_JBLEN];
#endif
#endif

_END_STD_C

#if defined(__CYGWIN__) || defined(__rtems__)
#include <signal.h>

#ifdef __cplusplus
extern "C" {
#endif

/* POSIX sigsetjmp/siglongjmp macros */
typedef int sigjmp_buf[_JBLEN+2];

#define _SAVEMASK	_JBLEN
#define _SIGMASK	(_JBLEN+1)

#ifdef __CYGWIN__
# define _CYGWIN_WORKING_SIGSETJMP
#endif

#define sigsetjmp(env, savemask) ((env)[_SAVEMASK] = savemask,\
               sigprocmask (SIG_SETMASK, 0, (sigset_t *) ((env) + _SIGMASK)),\
               setjmp (env))

#define siglongjmp(env, val) ((((env)[_SAVEMASK])?\
               sigprocmask (SIG_SETMASK, (sigset_t *) ((env) + _SIGMASK), 0):0),\
               longjmp (env, val))

#ifdef __cplusplus
}
#endif
#endif /* __CYGWIN__ or __rtems__ */
