;;  calmrisc16
;;   Copyright (C) 2001 by  Red Hat, Incorporated. All rights reserved.
;; 
;; Permission to use, copy, modify, and distribute this software
;; is freely granted, provided that this notice is preserved.
;; 
;; The 'target-independent' memcpy version is not 16-bit clean, and we can
;; do a lot better with target specific code anyways.
	.file "memcpy.S"

	.section .text
	.align 1
	.global _memcpy
_memcpy:
	ldw a8,@[sp+2]
	ldw a9,@[sp+6]
	ldw r6,@[sp+10]
	ld r10,#1
	tst r9,r10
	brtd .Leven_source
	ldw r7,@[sp+12]
	.global ___memcpy_6789_odd
___memcpy_6789_odd:
	sub r7,#1
	decc r6
;; If the length was zero, return immediately.
	brf .Lret_dest
	ldb r1,@[a9+0]
	add a9,#1
	ldb @[a8+0],r1
	add a8,#1
	.global ___memcpy_6789_even
___memcpy_6789_even:
.Leven_source:
	tst r8,r10
	brfd .Lunaligned
	.global ___memcpy_6789
___memcpy_6789:
	sr r7
	brfd .Leven_length
	sr r7
	ld a10,a14
	jsr .Leven_length
	ldb r2,@[a9+0]
	ldb @[a8+0],r2
	jmp a10
.Leven_length:
	brfd .L0mod4
	sr r7
	ldw r0,@[a9+0]
	add a9,#2
	ldw @[a8+0],r0
	add a8,#2
.L0mod4:
	brfd .L0mod8
	sr r7
	ldw r0,@[a9+0]
	ldw r1,@[a9+2]
	add a9,#4
	ldw @[a8+0],r0
	ldw @[a8+2],r1
	add a8,#4
.L0mod8:
	brfd .Lwordloop_start
	sub r7,#1
	add r7,#1
	sub a9,#8
	brad .Lwordloop_mid
	sub a8,#8
.Lwordloop_restart:
	ld r7,#0x0fff
	bra .Lwordloop
.Lwordloop_start:
	brf .Lwordloop_checkhigh
.Lwordloop:
	ldw r0,@[a9+0x0]
	ldw r1,@[a9+0x2]
	ldw @[a8+0x0],r0
	ldw @[a8+0x2],r1
	ldw r0,@[a9+0x4]
	ldw r1,@[a9+0x6]
	ldw @[a8+0x4],r0
	ldw @[a8+0x6],r1
.Lwordloop_mid:
	ldw r0,@[a9+0x8]
	ldw r1,@[a9+0xa]
	ldw @[a8+0x8],r0
	ldw @[a8+0xa],r1
	ldw r0,@[a9+0xc]
	ldw r1,@[a9+0xe]
	ldw @[a8+0xc],r0
	ldw @[a8+0xe],r1
	add a9,#16
	bnzd r7,.Lwordloop
	add a8,#16
.Lwordloop_checkhigh:
	sub r6,#1
	brt .Lwordloop_restart
.Lret_dest:
	ldw r0,@[sp+2]
	retd
	ldw r1,@[sp+4]
.Lunaligned:
	brfd .Leven_length2
	sr r7
	ldb r0,@[a9+0]
	add a9,#1
	ldb @[a8+0],r0
	add a8,#1
.Leven_length2:
	brfd .Lbyteloop_start
	ldw r0,@[sp+2]
	ld r7,r7
	sub a9,#2
	brad .Lbyteloop_mid
	sub a8,#2
.Lbyteloop_restart:
	sr r7
	brad .Lbyteloop
	sr r7
.Lbyteloop_start:
	sub r7,#1
	brf .Lbyteloop_checkhigh
.Lbyteloop:
	ldb r2,@[a9+0]
	ldb r3,@[a9+1]
	ldb @[a8+0],r2
	ldb @[a8+1],r3
.Lbyteloop_mid:
	ldb r2,@[a9+2]
	ldb r3,@[a9+3]
	ldb @[a8+2],r2
	ldb @[a8+3],r3
	add a9,#4
	bnzd r7,.Lbyteloop
	add a8,#4
.Lbyteloop_checkhigh:
	sub r6,#1
	brt .Lbyteloop_restart
	retd
	ldw r1,@[sp+4]
