/*
 * Copyright (c) 2000, Red Hat Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the copyright notice
 * above is retained.
 *
 */

/*
 * C library -- _setjmp, _longjmp
 *
 *      _longjmp(a,v)
 * will generate a "return(v?v:1)" from
 * the last call to
 *      _setjmp(a)
 * by unwinding the call stack.
 * The previous signal state is NOT restored.
 */

	.align 4
	.text
	.globl setjmp
	.globl _setjmp
	.globl longjmp
	.globl _longjmp

setjmp:
_setjmp:

	st64 r17++,r4		; store call-saved registers
	st64 r17++,r6
	st64 r17++,r8
	st64 r17++,r10
	st64 r17++,r20
	st64 r17++,r22
	st64 r17++,r28
	st64 r17++,r30

	movc #0,r18		; return 0
	jmp r16,JMP

longjmp:
_longjmp:

	ld64 r17++,r4		; reload saved registers
	ld64 r17++,r6
	ld64 r17++,r8
	ld64 r17++,r10
	ld64 r17++,r20
	ld64 r17++,r22
	ld64 r17++,r28
	ld64 r17++,r30

	/* r18 already contains return code so we don't need to move it */
	compc #0,r18	; if val is 0, then return 1, otherwise return val
	jmp r31,#code(exit),JNE
	movc #1,r18
exit:
	jmp r16,JMP
	
	.end
