# setjmp/longjmp for CY16
# 
# The jmpbuf looks like this:
#	
# Register	jmpbuf offset
# R0		0x0		 0
# R1		0x2		 2
# R2		0x4		 4
# R3		0x6		 6
# R4		0x8		 8
# R5		0xa		10
# R6		0xc		12
# R7		0xe		14
# R8		0x10		16
# R9		0x12		18
# R14		0x14		20
# R15		0x16		22
#
# R0 contains the pointer to jmpbuf
	.text
	.global	setjmp
	.type	setjmp ,@function
setjmp:
# Move r0 to one of the scratch address registers.
	mov	r12, r0
	mov	[r12], r0
	mov	[r12+2], r1
	mov 	[r12+4], r2
	mov	[r12+6], r3
	mov	[r12+8], r4
	mov	[r12+10], r5
	mov	[r12+12], r6
	mov	[r12+14], r7
	mov	[r12+16], r8
	mov	[r12+18], r9
	mov	[r12+20], r14
	mov	[r12+22], sp
	mov	r0, #0
	ret
.Lend1:
	.size	setjmp,.Lend1-setjmp

	.global	longjmp
	.type	longjmp,@function
longjmp:
	mov	r13, r0
	mov	r12, r1
	mov	sp, [r13+22]
	mov	r14, [r13+20]
	mov	r9, [r13+18]
	mov	r8, [r13+16]
	mov	r7, [r13+14]
	mov	r6, [r13+12]
	mov	r5, [r13+10]
	mov	r4, [r13+8]
	mov	r3, [r13+6]
	mov	r2, [r13+4]
	mov	r1, [r13+2]
	mov	r0, [r13]
# Value to return is in r12.  If zero, return 1
	mov	r0, r12
	cmp 	r0, #0
	jz 	4
	mov	r0, #1
.L01:
	ret
.Lend2:
	.size	longjmp,.Lend2-longjmp2
