/*
 * Copyright (c) 2000, Red Hat Inc.
 */

/*
 * C library -- _setjmp, _longjmp
 *
 *      _longjmp(a,v)
 * will generate a "return(v?v:1)" from
 * the last call to
 *      _setjmp(a)
 * by unwinding the call stack.
 * The previous signal state is NOT restored.
 */


	.align 4
	.text
	.globl setjmp
	.globl _setjmp
	.globl longjmp
	.globl _longjmp

setjmp:
_setjmp:
        move.4	d0,a0
	move.4	a0,d1
	move.4	(a0)4++,d1
	move.4	(a0)4++,d2
	move.4	(a0)4++,d3
	move.4	(a0)4++,d4
	move.4	(a0)4++,d5
	move.4	(a0)4++,d6
	move.4	(a0)4++,d7
	move.4	(a0)4++,d8
	move.4	(a0)4++,d9
	move.4	(a0)4++,d10
	move.4	(a0)4++,d11
	move.4	(a0)4++,d12
	move.4	(a0)4++,d13
	move.4	(a0)4++,d14
	move.4	(a0)4++,d15
	move.4	(a0)4++,d16
	move.4	(a0)4++,d17
	move.4	(a0)4++,d18
	move.4	(a0)4++,d19
	move.4	(a0)4++,d20
	move.4	(a0)4++,d21
	move.4	(a0)4++,d22
	move.4	(a0)4++,d23
	move.4	(a0)4++,d24
	move.4	(a0)4++,d25
	move.4	(a0)4++,d26
	move.4	(a0)4++,d27
	move.4	(a0)4++,d28
	move.4	(a0)4++,d29
	move.4	(a0)4++,d30
	move.4	(a0)4++,d31
	move.4	(a0)4++,a1
	move.4	(a0)4++,a2
	move.4	(a0)4++,a3
	move.4	(a0)4++,a4
	move.4	(a0)4++,a5
	move.4	(a0)4++,a6
	move.4	(a0)4++,a7
	move.4	(a0)4++,d0	/* actually a0 which we store last */
	move.4	a0,d0		/* restore a0 */
	xor.4	d0,d0,d0	/* return 0 */
        ret	a5

longjmp:
_longjmp:
	cmpi	d2,#0		/* compute v ? v : 1 for return code */
	jmpne.w label1
	movei	d2,#1
label1:
	move.4	d0,d2
	move.4	a0,d1
	move.4	d1,(a0)4++
	move.4	d2,(a0)4++
	move.4	d3,(a0)4++
	move.4	d4,(a0)4++
	move.4	d5,(a0)4++
	move.4	d6,(a0)4++
	move.4	d7,(a0)4++
	move.4	d8,(a0)4++
	move.4	d9,(a0)4++
	move.4	d10,(a0)4++
	move.4	d11,(a0)4++
	move.4	d12,(a0)4++
	move.4	d13,(a0)4++
	move.4	d14,(a0)4++
	move.4	d15,(a0)4++
	move.4	d16,(a0)4++
	move.4	d17,(a0)4++
	move.4	d18,(a0)4++
	move.4	d19,(a0)4++
	move.4	d20,(a0)4++
	move.4	d21,(a0)4++
	move.4	d22,(a0)4++
	move.4	d23,(a0)4++
	move.4	d24,(a0)4++
	move.4	d25,(a0)4++
	move.4	d26,(a0)4++
	move.4	d27,(a0)4++
	move.4	d28,(a0)4++
	move.4	d29,(a0)4++
	move.4	d30,(a0)4++
	move.4	d31,(a0)4++
	move.4	a1,(a0)4++
	move.4	a2,(a0)4++
	move.4	a3,(a0)4++
	move.4	a4,(a0)4++
	move.4	a5,(a0)4++
	move.4	a6,(a0)4++
	move.4	a7,(a0)4++
	move.4	a0,(a0)		/* a0 is last in list */
	ret	a5
	.end

