/*	Copyright 1990 Integrated Device Technology
**	All Rights Reserved
**
** 8254 programmable interval timer driver - contains code to install the
**	driver as well as the driver itself. In that this device does not
**	trasnsfer any amount of data there are no read/write functions
**	As such it is not the most representative driver - However it is
**	an i-o device present on the 382 board.
*/

#include "idtmon.h"
#include "idtcpu.h"
#include "idtio.h"
#include "i8254.h"
#include "iregdef.h"
#include "idt_entrypt.h"

#ifndef TADD
#define TADD 0xBF800000
#endif

/*
**	This is an example of how a driver in a users program 
**	may be integrated into the
**	prom monitor i/o system. This example will use the prom monitor 
**	entry point:
**		install_new_dev();
**	When the users program first begins and is in the process of
**	executing its start up code a call will be made to the
**	function below ( install_timer_driver() ).
*/

int	i8254init();	/* 8254 driver initialization function */
int	i8254open();	/* 8254 driver open function */
int	i8254ioctl();	/* 8254 driver ioctl function */
int	nulldev();	/* null driver function */

/*
**
**	The data structures below will be added to the monitors 
**	device tables by (install_new_dev() )
*/

struct dev_init_tab i8254_init[] = {
	{
	 "timer0",	/* name of device */
	 "",		/* dev. description */
	 "i8254",	/* driver name */
	 0,		/* controller number */
	 0,		/* timer number */
	 TIM_CNTR0,	/* control word for timer 0 */
	 TADD		/* io base address */
	},
	{
	"timer1",	/* name of device */
	"",		/* dev description */
	"i8254",	/* driver name */
	0,		/* controller number */
	1,		/* timer number */
	TIM_CNTR1,	/* control word for timer 1 */
	TADD		/* io base address */
	},	
	{ 0,0,0,0,0,0,0 }
};

struct dev_sw_tab i8254_table[] = {
	{
	i8254open,	   /* device open routine */
	nulldev,	   /* device close routine */
	nulldev,	   /* devive read routine */
	nulldev,	   /* device write routine */
	i8254init,	   /* device init routine */
	nulldev,	   /* device strategy routine */
	i8254ioctl,	   /* device ioctl routine */
	"i8254" 	   /* device driver name */
	},
	{ 0,0,0,0,0,0,0,0 }
};
static TIMER *tadd;

/*
**	When the users program first begins and is in the process of
**	executing its start up code a call will be made to the
**	function below ( install_timer_driver() ).
**
** install_timer_driver(addr) - call from the start up code to make call
**			to monitors install_new_dev() function
**
*/
install_timer_driver(addr)
int addr;
{
	int i;
	for(i=0; i8254_init[i].dev_name != 0; i++)
	   i8254_init[i].dev_io_addr = addr;
	install_new_dev(i8254_table,i8254_init);
	tadd = (TIMER*)addr;
	i8254init();	/* call initialization function */
}

/*********************************************************************
** The following sections of code are the actual device (8254) driver*
*********************************************************************/


/*-----------------------------------------------------------------
**	timer driver initializatiom function
**
**	i8254init() - does necessary initialization 
**		sets the pre scaler counter ( counter 2 ) to divide
**		the input frequency of 3.6864mhz by 16 counters 0 and 1
**		are set to mode 5 and an initial count of 0
**	makes sure that the interrupts point to a null interrupt processor
*-------------------------------------------------------------------*/

int i8254init()
{
	TIMER *taddr;
	int dummy;

	taddr = tadd;
	taddr->control = TIM_MODE5|TIM_CNTR0|TIM_RW1|TIM_RW0; wbflush();
	taddr->control = TIM_MODE5|TIM_CNTR1|TIM_RW1|TIM_RW0; wbflush();
	taddr->control = TIM_MODE2|TIM_CNTR2|TIM_RW1|TIM_RW0; wbflush();

	taddr->timer0 = 0; wbflush();
	taddr->timer0 = 0; wbflush();

	taddr->timer1 = 0; wbflush();
	taddr->timer1 = 0; wbflush();
		/* set up ther pre-scaler so it outputs a count */
		/* every 5 ms. - this gives timers 0 and 1 a range of */
		/* 5 ms. to 327.68 secs */
	taddr->timer2 = (18432 & 0xff); wbflush();
	taddr->timer2 = ((18432 >> 8) & 0xff); wbflush();
	dummy = taddr->clrint0;
	dummy = taddr->clrint1;
}
/*-----------------------------------------------------------------
**	timer driver open function
**
**	i8254open() - opens the device for operation (normally it
**			would be for reading or writing which in
**			the case of a timer doesn't really apply).
**	opening a counter(timer) sets it to a mode that will not!
**	generate any counts or interrupts on the 382 board. gate is
**	tied high. (mode 5 reguires a low to high transition on
**	gate for counting to begin.
-----------------------------------------------------------------*/
int i8254open(io)
struct iocntb *io;
{
	TIMER *taddr;	/* pointer to timer addresses */

	taddr = (TIMER*)io->icb_di->dev_io_addr;	/* get io address */
	taddr->control = io->icb_di->dev_part|TIM_MODE5|TIM_RW0|TIM_RW1;
	wbflush();
	if ( io->icb_di->dev_unit == 0 )
	    { taddr->timer0 = 0; wbflush();
	      taddr->timer0 = 0; wbflush();}
	else
	    { taddr->timer1 = 0; wbflush();
	      taddr->timer1 = 0; wbflush();}
	return(0);
}

/*-------------------------------------------------------------------
**	i8254ioctl - io control function for the 8254
**
*-------------------------------------------------------------------*/

int i8254ioctl(io,cmd,arg)
struct iocntb *io;
int cmd;
int arg;
{
	TIMER *taddr;	/* pointer to timer addresses */
	int unit, mode ,action,num5ms,dummy;
	u_char byte0,byte1;
	taddr = (TIMER*)io->icb_di->dev_io_addr;	/* get io address */
	unit = io->icb_di->dev_unit;		/* get timer number */
	action = NULL;
	switch (cmd) {
	    case CIOCMODE0:
		mode = TIM_MODE0;
		action = LDCOUNT;
		break;
	    case CIOCMODE2:
		mode = TIM_MODE2;
		action = LDCOUNT;
		break;
	    case CIOCMODE3:
		mode = TIM_MODE3;
		action = LDCOUNT;
		break;
	    case CIOCMODE4:
		mode = TIM_MODE4;
		action = LDCOUNT;
		break;
	    case CIOCCLRINT:
		if ( arg == 0 )
		    dummy = taddr->clrint0;
		else
		    dummy = taddr->clrint1;
		break;
	    case CIOCINTENAB:
		if ( unit == 0 )
		  enable_int( 1 << (10+arg) );
		else
		  enable_int( 1 << (10+arg) );
		break;
	    case CIOCINTDISAB:
		if ( unit == 0 )
		  disable_int( 1 << (10+arg) );
		else
		  disable_int( 1 << (10+arg) );
		break;
	  }
	if ( action == LDCOUNT )
	   {
	    taddr->control = io->icb_di->dev_part|mode|TIM_RW0|TIM_RW1;
	    wbflush();
	    num5ms = arg/5;
	    byte0 = (u_char)(num5ms & 0xff);
	    byte1 = (u_char)((num5ms >> 8) & 0xff);
	    if ( unit == 0 )
	       { taddr->timer0 = byte0; wbflush();
	         taddr->timer0 = byte1; wbflush(); }
	    else
	       { taddr->timer1 = byte0; wbflush();
	         taddr->timer1 = byte1; wbflush(); }
	    }
}
/*
** nulldev - null driver function
*/
int nulldev()
{
	return(0);
}

