/*************************************************************************
**
** Copyright (c) 1991 Integrated Device Technology, Inc.
**	All Rights Reserved
**
** Distribution of source code or binaries derived from this file is not
** permitted except as specifically allowed for in the Integrated Device 
** Technology Software License agreement.  All copies of this source code
** modified or unmodified must retain this entire copyright notice and 
** comment as is.
** Direct all support questions to Integrated Device Technology, Inc.
**
** THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
**
**************************************************************************/

#include <string.h>

unsigned long _get_avail_mem();
char *_get_brkpt();

static char *brkpt,*ibrkpt;
static unsigned long avail;

_init_sbrk()
{
	ibrkpt = brkpt = _get_brkpt();
	avail = _get_avail_mem(brkpt);
	if (avail <= 4096)
		_exit();
}

char *
sbrk(amt)
int amt;
{
	int i;	
	if (amt > 0)
		if (amt > avail) return ((char *)-1);
		else {
			avail = avail - amt;
			for(i=0;i<amt;i++)brkpt[i]=0;
			brkpt = brkpt + amt;
			return((char *)(brkpt-amt));
		}
	else if (amt < 0)
		if (brkpt + amt < ibrkpt)
			return ((char *)-1);
		else {
			avail = avail - amt;
			brkpt = brkpt + amt;
			return((char *)(brkpt-amt));
		}	
	else return(char*)brkpt;
}
