#include "test.h"
#include <errno.h>

/* testsuite entry point */
void
_DEFUN_VOID (test_main)
{
	int     i;
	double  r;
	int     t;

	float   xf;
	double  gives;

	int     pow;

	/* Frexp of x return a and n, where a * 2**n == x, so test this with a
     set of random numbers */
	for (t = 0; t < 2; t++) {
		for (i = 0; i < 1000; i++) {

			double  x = randx ();
			line (i);
			switch (t) {
			case 0:
				newfunc ("frexp/ldexp");
				r = frexp (x, &pow);
				if (r > 1.0 || r < -1.0) {
					/* Answer can never be > 1 or < 1 */
					test_iok (0, 1);
				}
				gives = ldexp (r, pow);
				test_mok (gives, x, 62);
				break;
			case 1:
				newfunc ("frexpf/ldexpf");
				if (x > FLT_MIN && x < FLT_MAX) {
					/* test floats too, but they have a smaller range so make sure x
	     isn't too big. Also x can get smaller than a float can
	     represent to make sure that doesn't happen too */
					xf = x;
					r = frexpf (xf, &pow);
					if (r > 1.0 || r < -1.0) {
						/* Answer can never be > 1 or < -1 */
						test_iok (0, 1);
					}
					gives = ldexpf (r, pow);
					test_mok (gives, x, 32);

				}
			}

		}

	}

	/* test a few numbers manually to make sure frexp/ldexp are not
     testing as ok because both are broken */

	r = frexp (64.0, &i);

	test_mok (r, 0.5, 64);
	test_iok (i, 7);

	r = frexp (96.0, &i);

	test_mok (r, 0.75, 64);
	test_iok (i, 7);

}
