(* $Id: gtkSignal.mli,v 1.9 2003/09/22 03:24:15 garrigue Exp $ *)

open Gobject

type id
type 'a marshaller = 'a -> Closure.argv -> unit
type ('a,'b) t =
 { name: string; classe: 'a; marshaller: 'b marshaller }
    (* When writing marshallers, beware that the list omits the 0th
       argument of argv, which is the referent object *)

val stop_emit : unit -> unit
    (* Call [stop_emit ()] in a callback to prohibit further handling
       of the current signal invocation, by calling [emit_stop_by_name].
       Be careful about where you use it, since the concept of current
       signal may be tricky. *)

val connect :
  sgn:('a, 'b) t -> callback:'b -> ?after:bool -> 'a obj -> id
    (* You may use [stop_emit] inside the callback *)

val user_handler : (exn -> unit) ref
    (* A hook to allow changing the behaviour of exceptions in callbacks
       The default behaviour of printing the exception and ignoring it
       is obtained when [user_handler] is set to [Pervasives.raise] *)

external connect_by_name :
  'a obj -> name:string -> callback:g_closure -> after:bool -> id
  = "ml_g_signal_connect_closure"
external disconnect : 'a obj -> id -> unit
  = "ml_g_signal_handler_disconnect"
external emit_stop_by_name : 'a obj -> name:string -> unit
  = "ml_g_signal_stop_emission_by_name"
    (* Unsafe: use [stop_emit] instead. *)
external handler_block : 'a obj -> id -> unit
  = "ml_g_signal_handler_block"
external handler_unblock : 'a obj -> id -> unit
  = "ml_g_signal_handler_unblock"

(* Some marshaller functions, to build signals *)
val marshal_unit : (unit -> unit) marshaller
val marshal_int : (int -> unit) marshaller
val marshal_string : (string -> unit) marshaller

val marshal1 : 'a data_conv -> string -> ('a -> unit) marshaller
val marshal2 :
  'a data_conv -> 'b data_conv -> string -> ('a -> 'b -> unit) marshaller
val marshal3 :
  'a data_conv -> 'b data_conv -> 'c data_conv ->
  string -> ('a -> 'b -> 'c -> unit) marshaller
val marshal4 :
  'a data_conv -> 'b data_conv -> 'c data_conv -> 'd data_conv ->
  string -> ('a -> 'b -> 'c -> 'd -> unit) marshaller
val marshal5 :
  'a data_conv -> 'b data_conv -> 'c data_conv -> 'd data_conv ->
  'e data_conv -> string -> ('a -> 'b -> 'c -> 'd -> 'e -> unit) marshaller
val marshal6 :
  'a data_conv -> 'b data_conv -> 'c data_conv -> 'd data_conv ->
  'e data_conv -> 'f data_conv ->
  string -> ('a -> 'b -> 'c -> 'd -> 'e -> 'f -> unit) marshaller

val marshal0_ret : ret:'a data_conv -> (unit -> 'a) marshaller
val marshal1_ret :
  ret:'a data_conv -> 'b data_conv -> string -> ('b -> 'a) marshaller
val marshal2_ret :
  ret:'a data_conv -> 'b data_conv -> 'c data_conv ->
  string -> ('b -> 'c -> 'a) marshaller
val marshal3_ret :
  ret:'a data_conv -> 'b data_conv -> 'c data_conv -> 'd data_conv ->
  string -> ('b -> 'c -> 'd -> 'a) marshaller
val marshal4_ret :
  ret:'a data_conv -> 'b data_conv -> 'c data_conv -> 'd data_conv ->
  'e data_conv -> string -> ('b -> 'c -> 'd -> 'e -> 'a) marshaller

(* Emitter functions *)
val emit :
  'a Gobject.obj -> sgn:('a, 'b) t ->
  emitter:(cont:('c Gobject.data_set array -> 'd) -> 'b) ->
  conv:(Gobject.g_value -> 'd) -> 'b
val emit_unit : 'a obj -> sgn:('a, unit -> unit) t -> unit
val emit_int : 'a obj -> sgn:('a, int -> unit) t -> int -> unit

(* Internal functions. *)
val enter_callback : (unit -> unit) ref
val exit_callback : (unit -> unit) ref
type saved_state
val push_callback : unit -> saved_state
val pop_callback : saved_state -> bool
