/* Copyright (C) 2003, 2004 Free Software Foudnation, Inc.
   This file is part of the GNU C Library.
   Contributed by Alexandre Oliva <aoliva@redhat.com>, 2004.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <sysdep.h>
#include <asm/unistd.h>
#include <tcb-offsets.h>

       .text
       .globl  __vfork
       .type __vfork,@function
/* int vfork(void) */
__vfork:
	setlos	#PID_OFFSET, gr9

	ld.p	@(gr29, gr9), gr6
	setlos	#-4096, gr4	; used for the errno test after the syscall

	subcc	gr0, gr6, gr5, icc0
	bne	icc0, #2, 1f

	slli	gr4, #19, gr5	; set it to 0x80000000

1:	st.p	gr5, @(gr29, gr9)
	
	setlos	#__NR_vfork, gr7
	tra	gr0, gr0

	cmp.p	gr8, gr0, icc0
	cmp	gr8, gr4, icc1
	beqlr	icc0, #2	; return to the child immediately
	st.p	gr6, @(gr29, gr9) ; on the parent, restore the PID
	blslr	icc1, #2	; and return unless the call failed

	SYSCALL_ERROR_HANDLER

       .size   __vfork,.-__vfork

.weak vfork
.global vfork
.set vfork, __vfork
