#ifndef __LINUX_COMPILER_H
#define __LINUX_COMPILER_H

#ifdef __CHECKER__
# define __user		__attribute__((noderef, address_space(1)))
# define __kernel	/* default address space */
# define __safe		__attribute__((safe))
# define __force	__attribute__((force))
extern void __chk_user_ptr(void __user *);
#else
# define __user
# define __kernel
# define __safe
# define __force
# define __chk_user_ptr(x) (void)0
#endif

/* Somewhere in the middle of the GCC 2.96 development cycle, we implemented
   a mechanism by which the user can annotate likely branch directions and
   expect the blocks to be reordered appropriately.  Define __builtin_expect
   to nothing for earlier compilers.  */

#if __GNUC__ == 2 && __GNUC_MINOR__ <= 96
#define __builtin_expect(x, expected_value) (x)
#endif

#if __GNUC__ == 3 && __GNUC_MINOR__ >= 1
#define  noinline __attribute__((noinline))
#else
#define  noinline
#endif

#define likely(x)	__builtin_expect((x),1)
#define unlikely(x)	__builtin_expect((x),0)

#endif /* __LINUX_COMPILER_H */
