#############################################################
#
# bind
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
BIND_SOURCE:=bind.tar.gz
BIND_SITE:=ftp://ftp.isc.org/isc/bind9/9.2.3
BIND_CAT:=zcat
endif

BIND_DIR:=$(BUILD_DIR)/bind
BIND_BINARY:=bin/named/named
BIND_TARGET_BINARY:=usr/sbin/named

TARGET_LOGROTATE_DIR := $(TARGET_DIR)/etc/logrotate.d

ifneq ($(USE_CVS),true)
bind-source: $(DL_DIR)/$(BIND_SOURCE)
else
bind-source:
endif

BIND_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d bind $(CVS_TAG) $(CVS_PREFIX)bind

bind-checkout:
	@$(BIND_CVSCO)

$(BIND_DIR)/.unpacked: $(DL_DIR)/$(BIND_SOURCE)
ifneq ($(USE_CVS),true)
	$(BIND_CAT) $(DL_DIR)/$(BIND_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(BIND_CVSCO)
endif
	cat $(SOURCE_DIR)/bind-config-cross.patch | patch -d $(BIND_DIR) -p1
	cp $(SOURCE_DIR)/config.sub $(BIND_DIR)/
	touch $(BIND_DIR)/.unpacked

$(BIND_DIR)/.configured: $(BIND_DIR)/.unpacked
	(cd $(BIND_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var/run/named \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--with-randomdev=/dev/urandom \
		--disable-ipv6 \
	);
	touch  $(BIND_DIR)/.configured

$(BIND_DIR)/$(BIND_BINARY): $(BIND_DIR)/.configured
	$(MAKE) CFLAGS="$(TARGET_CFLAGS)" CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(BIND_DIR)

$(STAGING_DIR)/$(BIND_TARGET_BINARY): $(BIND_DIR)/$(BIND_BINARY)
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(BIND_DIR) install

$(TARGET_DIR)/$(BIND_TARGET_BINARY): $(STAGING_DIR)/$(BIND_TARGET_BINARY)
	touch $(TARGET_DIR)/.touchme
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(BIND_DIR) install
	@find $(TARGET_DIR)/usr/include -type d -newer $(TARGET_DIR)/.touchme | xargs rm -rf
	@find $(TARGET_DIR)/usr/lib -name \*.a -newer $(TARGET_DIR)/.touchme | xargs rm -f
	@for f in `find $(TARGET_DIR)/usr/sbin $(TARGET_DIR)/usr/bin \
			-type f -newer $(TARGET_DIR)/.touchme -exec file {} \; \
			| grep "ELF.*executable.*not stripped" \
			| cut -d : -f 1` ; do \
            $(STRIP) $$f ; \
        done
	rm -f $(TARGET_DIR)/.touchme
	install -m0755 $(BIND_DIR)/named.init $(TARGET_DIR)/etc/rc.d/init.d/named
	install -d $(DOC_DIR)/doc/bind
	@for f in FAQ COPYRIGHT ; do \
		install -m0644 $(BIND_DIR)/$$f $(DOC_DIR)/doc/bind/$$f ;\
	done
	@cp -Rd $(BIND_DIR)/doc/rfc $(DOC_DIR)/doc/bind/rfc
	install -d $(TARGET_DIR)/var/named
	install -d $(TARGET_DIR)/var/run/named
	if [ ! -d $(TARGET_LOGROTATE_DIR) ]; then \
		mkdir --mode=0755 -p $(TARGET_LOGROTATE_DIR); \
	fi
	install -m0644 $(SOURCE_DIR)/named.logrotate $(TARGET_LOGROTATE_DIR)/named

bind: uclibc initscripts $(TARGET_DIR)/$(BIND_TARGET_BINARY)

bind-clean:
	-rm -f $(TARGET_DIR)/$(BIND_TARGET_BINARY)
	@for f in dig host isc-config.sh nslookup nsupdate ; do \
		rm -f $(TARGET_DIR)/usr/bin/$$f ;\
	done
	@for f in dnssec-keygen dnssec-signkey lwresd named-checkconf rndc \
		  dnssec-makekeyset dnssec-signzone named named-checkzone \
		  rndc-confgen ;  do \
		rm -f $(TARGET_DIR)/usr/sbin/$$f ;\
	done
	-rm -f $(TARGET_DIR)/etc/rc.d/init.d/named
	-rm -f $(TARGET_DIR)/usr/man/man1/dig.1 \
		$(TARGET_DIR)/usr/man/man1/host.1 \
		$(TARGET_DIR)/usr/man/man3/lwres* \
		$(TARGET_DIR)/usr/man/man5/rndc.conf.5 \
		$(TARGET_DIR)/usr/man/man8/dnssec* \
		$(TARGET_DIR)/usr/man/man8/lwresd.8 \
		$(TARGET_DIR)/usr/man/man8/named* \
		$(TARGET_DIR)/usr/man/man8/nsupdate.8 \
		$(TARGET_DIR)/usr/man/man8/rndc* \
	-rm -rf $(TARGET_DIR)/usr/lib/bind
	-rm -rf $(DOC_DIR)/doc/bind
	-$(MAKE) -C $(BIND_DIR) clean

bind-dirclean:
	rm -rf $(BIND_DIR)

bind-fetch:
	 $(WGET) -P $(DL_DIR) $(BIND_SITE)/$(BIND_SOURCE)

endif

