#############################################################
#
# cpio
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
CPIO_SOURCE:=cpio.tar.gz
CPIO_SITE:=ftp://ftp.gnu.org/gnu/cpio
CPIO_CAT:=zcat
endif

CPIO_DIR:=$(BUILD_DIR)/cpio
CPIO_BINARY:=cpio
CPIO_TARGET_BINARY:=bin/cpio

ifneq ($(USE_CVS),true)
cpio-fetch:
	 $(WGET) -P $(DL_DIR) $(CPIO_SITE)/$(CPIO_SOURCE)

cpio-source: $(DL_DIR)/$(CPIO_SOURCE)
else
cpio-source:
endif

CPIO_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d cpio $(CVS_TAG) $(CVS_PREFIX)cpio

cpio-checkout:
	@$(CPIO_CVSCO)

$(CPIO_DIR)/.unpacked: $(DL_DIR)/$(CPIO_SOURCE)
ifneq ($(USE_CVS),true)
	$(CPIO_CAT) $(DL_DIR)/$(CPIO_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(CPIO_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(CPIO_DIR)/
	touch $(CPIO_DIR)/.unpacked

$(CPIO_DIR)/.configured: $(CPIO_DIR)/.unpacked
	(cd $(CPIO_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(CPIO_DIR)/.configured

$(CPIO_DIR)/$(CPIO_BINARY): $(CPIO_DIR)/.configured
	$(MAKE) CFLAGS="$(TARGET_CFLAGS)" CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(CPIO_DIR)

$(TARGET_DIR)/$(CPIO_TARGET_BINARY): $(CPIO_DIR)/$(CPIO_BINARY)
	install -m0755 $(CPIO_DIR)/$(CPIO_BINARY) $(TARGET_DIR)/$(CPIO_TARGET_BINARY)
	install -m0644 $(CPIO_DIR)/cpio.1 $(TARGET_DIR)/usr/man/man1/cpio.1
	$(STRIP) $(TARGET_DIR)/$(CPIO_TARGET_BINARY)
	install -d $(DOC_DIR)/doc/cpio
	@for f in COPYING COPYING.LIB ; do \
		install -m0644 $(CPIO_DIR)/$$f $(DOC_DIR)/doc/cpio/$$f ;\
	done

cpio: uclibc $(TARGET_DIR)/$(CPIO_TARGET_BINARY)

cpio-clean:
	-rm -f $(TARGET_DIR)/$(CPIO_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/man/man1/cpio.1
	-rm -rf $(DOC_DIR)/doc/cpio
	-$(MAKE) -C $(CPIO_DIR) clean

cpio-dirclean:
	rm -rf $(CPIO_DIR)
endif

