#
# dosfstools
#
######################################################

ifneq ($(USE_CVS),true)
DOSFSTOOLS_SOURCE:=dosfstools.tar.gz
DOSFSTOOLS_SITE:=ftp://ibiblio.org/pub/Linux/system/filesystems/dosfs/
DOSFSTOOLS_CAT:=zcat
DOSFSTOOLS_DIR:=$(BUILD_DIR)/dosfstools
else
# using CVS
DOSFSTOOLS_DIR:=$(BUILD_DIR)/dosfstools
endif

ifeq ($(USE_GLIBC),true)
#DOSFSTOOLS_PREREQ=
else
endif

DOSFSTOOLS_BINARY:=dosfsck
DOSFSTOOLS_TARGET_BINARY:=sbin/$(DOSFSTOOLS_BINARY)

TARGET_MAN_DIR := $(TARGET_DIR)/usr/share/man/man8

ifneq ($(USE_CVS),true)
dosfstools-fetch:
	$(WGET) -P $(DL_DIR) $(DOSFSTOOLS_SITE)/$(DOSFSTOOLS_SOURCE)

dosfstools-source: $(DL_DIR)/$(DOSFSTOOLS_SOURCE)
else
dosfstools-source:
endif

DOSFSTOOLS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d dosfstools $(CVS_TAG) $(CVS_PREFIX)dosfstools

dosfstools-checkout:
	@$(DOSFSTOOLS_CVSCO)

$(DOSFSTOOLS_DIR)/.unpacked: $(DL_DIR)/$(DOSFSTOOLS_SOURCE)
ifneq ($(USE_CVS),true)
	$(DOSFSTOOLS_CAT) $(DL_DIR)/$(DOSFSTOOLS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	$(DOSFSTOOLS_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(DOSFSTOOLS_DIR)/
	touch $(DOSFSTOOLS_DIR)/.unpacked

$(DOSFSTOOLS_DIR)/$(DOSFSTOOLS_BINARY): $(DOSFSTOOLS_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) CFLAGS="$(CFLAGS) -Dllseek=lseek64 -D_LARGEFILE64_SOURCE" -C $(DOSFSTOOLS_DIR)

$(TARGET_DIR)/$(DOSFSTOOLS_TARGET_BINARY): $(DOSFSTOOLS_DIR)/$(DOSFSTOOLS_BINARY)
	mkdir -p $(TARGET_DIR)/sbin
	mkdir -p $(TARGET_MAN_DIR)

	install -m755 $(DOSFSTOOLS_DIR)/mkdosfs/mkdosfs $(TARGET_DIR)/sbin/mkdosfs
	$(TARGET_CROSS)strip $(TARGET_DIR)/sbin/mkdosfs
	ln -f $(TARGET_DIR)/sbin/mkdosfs $(TARGET_DIR)/sbin/mkfs.vfat
	ln -f $(TARGET_DIR)/sbin/mkdosfs $(TARGET_DIR)/sbin/mkfs.msdos

	install -m755 $(DOSFSTOOLS_DIR)/dosfsck/dosfsck $(TARGET_DIR)/sbin/dosfsck
	$(TARGET_CROSS)strip $(TARGET_DIR)/sbin/dosfsck
	ln -f $(TARGET_DIR)/sbin/dosfsck $(TARGET_DIR)/sbin/fsck.msdos
	ln -f $(TARGET_DIR)/sbin/dosfsck $(TARGET_DIR)/sbin/fsck.vfat

	install -m 644 $(DOSFSTOOLS_DIR)/mkdosfs/mkdosfs.8 $(TARGET_MAN_DIR)
	ln -sf mkdosfs.8.gz $(TARGET_MAN_DIR)/mkfs.msdos.8.gz
	ln -sf mkdosfs.8.gz $(TARGET_MAN_DIR)/mkfs.vfat.8.gz

	install -m 644 $(DOSFSTOOLS_DIR)/dosfsck/dosfsck.8 $(TARGET_MAN_DIR)
	ln -sf dosfsck.8.gz $(TARGET_MAN_DIR)/fsck.vfat.8.gz

dosfstools: uclibc $(DOSFSTOOLS_PREREQ) $(TARGET_DIR)/$(DOSFSTOOLS_TARGET_BINARY)

dosfstools-clean:
	-rm -f $(TARGET_DIR)/sbin/{mkdosfs,mkfs.vfat,mkfs.msdos} \
		$(TARGET_DIR)/sbin/{dosfsck,fsck.msdos,fsck.vfat} \
		$(TARGET_MAN_DIR)/{mkdosfs.8,mkfs.msdos.8.gz,mkfs.vfat.8.gz} \
		$(TARGET_MAN_DIR)/{dosfsck.8,fsck.vfat.8.gz}
	$(MAKE) -C $(DOSFSTOOLS_DIR) clean

dosfstools-dirclean:
	-rm -rf $(DOSFSTOOLS_DIR)

