#############################################################
#
# finger
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
FINGER_SOURCE:=finger.tar.gz
FINGER_CAT:=zcat
endif

FINGER_DIR:=$(BUILD_DIR)/finger
FINGER_BINARY:=finger/finger
FINGER_TARGET_BINARY:=usr/bin/finger

ifneq ($(USE_CVS),true)
finger-fetch:
	 $(WGET) -P $(DL_DIR) $(FINGER_SITE)/$(FINGER_SOURCE)

finger-source: $(DL_DIR)/$(FINGER_SOURCE)
else
finger-source:
endif

FINGER_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d finger $(CVS_TAG) $(CVS_PREFIX)finger

finger-checkout:
	@$(FINGER_CVSCO)

$(FINGER_DIR)/.unpacked: $(DL_DIR)/$(FINGER_SOURCE)
ifneq ($(USE_CVS),true)
	$(FINGER_CAT) $(DL_DIR)/$(FINGER_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(FINGER_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(FINGER_DIR)/
	touch $(FINGER_DIR)/.unpacked

$(FINGER_DIR)/.configured: $(FINGER_DIR)/.unpacked
	(cd $(FINGER_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		./configure \
			--installroot=$(TARGET_DIR) \
			--with-c-compiler=$(TARGET_CC) \
			--enable-ipv6 \
	);
	touch  $(FINGER_DIR)/.configured

$(FINGER_DIR)/$(FINGER_BINARY): $(FINGER_DIR)/.configured
	$(MAKE) -C $(FINGER_DIR)

$(TARGET_DIR)/$(FINGER_TARGET_BINARY): $(FINGER_DIR)/$(FINGER_BINARY)
	$(MAKE) -C $(FINGER_DIR) install
	$(STRIP) $(TARGET_DIR)/$(FINGER_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/in.fingerd
	install -m0644 $(FINGER_DIR)/finger-xinetd \
		$(TARGET_DIR)/etc/xinetd.d/finger
	install -d $(DOC_DIR)/doc/finger
	@for f in BUGS README ; do \
		install -m0644 $(FINGER_DIR)/$$f $(DOC_DIR)/doc/finger/$$f ;\
	done

finger: uclibc xinetd $(TARGET_DIR)/$(FINGER_TARGET_BINARY)

finger-clean:
	-rm -f $(TARGET_DIR)/$(FINGER_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/in.fingerd \
		$(TARGET_DIR)/usr/man/man1/finger.1 \
		$(TARGET_DIR)/usr/man/man8/fingerd.8 \
		$(TARGET_DIR)/usr/man/man8/in.fingerd.8 \
		$(TARGET_DIR)/etc/xinetd.d/finger
	-rm -rf $(DOC_DIR)/doc/finger
	-$(MAKE) -C $(FINGER_DIR) clean

finger-dirclean:
	rm -rf $(FINGER_DIR)
endif

