#############################################################
#
# freetype
#
#############################################################
ifneq ($(USE_CVS),true)
FREETYPE_SOURCE:=freetype.tar.gz
FREETYPE_SITE:=xxxxxxxxxxxxxxxxxxxxxxxx
FREETYPE_CAT:=zcat
endif

FREETYPE_DIR:=$(BUILD_DIR)/freetype

ifneq ($(USE_CVS),true)
freetype-fetch:
	 $(WGET) -P $(DL_DIR) $(FREETYPE_SITE)/$(FREETYPE_SOURCE)

freetype-source: $(DL_DIR)/$(FREETYPE_SOURCE)
else
freetype-source:
endif

FREETYPE_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d freetype $(CVS_TAG) $(CVS_PREFIX)freetype

freetype-checkout:
	@$(FREETYPE_CVSCO)

$(FREETYPE_DIR)/.unpacked: $(DL_DIR)/$(FREETYPE_SOURCE)
ifneq ($(USE_CVS),true)
	$(FREETYPE_CAT) $(DL_DIR)/$(FREETYPE_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(FREETYPE_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(FREETYPE_DIR)/
	cp $(SOURCE_DIR)/config.sub $(FREETYPE_DIR)/builds/unix
	cp $(SOURCE_DIR)/ltmain.sh $(FREETYPE_DIR)/builds/unix
	touch $(FREETYPE_DIR)/.unpacked

$(FREETYPE_DIR)/.configured: $(FREETYPE_DIR)/.unpacked
	(cd $(FREETYPE_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		sh -x ./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
	);
	touch  $(FREETYPE_DIR)/.configured

$(FREETYPE_DIR)/objs/.libs/libfreetype.so: $(FREETYPE_DIR)/.configured
	$(MAKE) -C $(FREETYPE_DIR)

$(STAGING_DIR)/usr/lib/libfreetype.so: $(FREETYPE_DIR)/objs/.libs/libfreetype.so
	$(MAKE) \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/freetype \
	    -C $(FREETYPE_DIR) install;
	chmod a-x $(STAGING_DIR)/usr/lib/libfreetype*so*
	rm -f $(STAGING_DIR)/usr/lib/libfreetype.la

$(TARGET_DIR)/usr/lib/libfreetype.so: $(STAGING_DIR)/usr/lib/libfreetype.so
	$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/freetype \
	    -C $(FREETYPE_DIR) install
	mkdir -p $(DOC_DIR)/doc/freetype
	for f in GPL.txt license.txt FTL.txt PATENTS INSTALL ; do \
		install -m0644 $(FREETYPE_DIR)/docs/$$f $(DOC_DIR)/doc/freetype/$$f ;\
	done
	rm -f $(TARGET_DIR)/usr/lib/libfreetype.la



freetype-clean:
	-$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/freetype \
	    -C $(FREETYPE_DIR) uninstall
	-$(MAKE)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/freetype \
	    -C $(FREETYPE_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/freetype
	$(MAKE) -C $(FREETYPE_DIR) clean



freetype-dirclean:
	rm -rf $(FREETYPE_DIR)

freetype: uclibc $(TARGET_DIR)/usr/lib/libfreetype.so


