#############################################################
#
# grep
#
#############################################################
ifneq ($(USE_CVS),true)
GNUGREP_SOURCE:=grep.tar.gz
GNUGREP_SITE:=http://ftp.debian.org/debian/pool/main/g/grep/
GNUGREP_CAT:=zcat
endif

GNUGREP_DIR:=$(BUILD_DIR)/grep
GNUGREP_BINARY:=src/grep
GNUGREP_TARGET_BINARY:=bin/grep

ifneq ($(USE_CVS),true)
grep-fetch:
	 $(WGET) -P $(DL_DIR) $(GNUGREP_SITE)/$(GNUGREP_SOURCE)

grep-source: $(DL_DIR)/$(GNUGREP_SOURCE)
endif

GREP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d grep $(CVS_TAG) $(CVS_PREFIX)grep

grep-checkout:
	@$(GREP_CVSCO)

$(GNUGREP_DIR)/.unpacked: $(DL_DIR)/$(GNUGREP_SOURCE)
ifneq ($(USE_CVS),true)
	$(GNUGREP_CAT) $(DL_DIR)/$(GNUGREP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(GREP_CVSCO)
endif
	touch $(GNUGREP_DIR)/.unpacked

$(GNUGREP_DIR)/.configured: $(GNUGREP_DIR)/.unpacked
	(cd $(GNUGREP_DIR); rm -rf config.cache; \
		aclocal ; automake ;\
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--bindir=/bin \
		--datadir=/usr/share \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--disable-perl-regexp \
		--without-included-regex \
	);
	touch  $(GNUGREP_DIR)/.configured

$(GNUGREP_DIR)/$(GNUGREP_BINARY): $(GNUGREP_DIR)/.configured
	$(MAKE) -C $(GNUGREP_DIR)

# This stuff is needed to work around GNU make deficiencies
grep-target_binary: $(GNUGREP_DIR)/$(GNUGREP_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) STRIP=$(TARGET_CROSS)strip \
		-C $(GNUGREP_DIR) install-strip
	install -d $(DOC_DIR)/doc/grep
	for f in AUTHORS COPYING NEWS THANKS TODO ; do \
		install -m0644 $(GNUGREP_DIR)/$$f $(DOC_DIR)/doc/grep/$$f ;\
	done

grep: uclibc grep-target_binary

grep-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(GNUGREP_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/grep
	-$(MAKE) -C $(GNUGREP_DIR) clean

grep-dirclean:
	rm -rf $(GNUGREP_DIR)

