#############################################################
#
# gtk
#
#############################################################
ifneq ($(USE_CVS),true)
GTK_SOURCE:=gtk+.tar.gz
GTK_SITE:=xxxxxxxxxxxxxxxxxxxxxxxx
GTK_CAT:=zcat
endif

GTK_DIR:=$(BUILD_DIR)/gtk+

ifneq ($(USE_CVS),true)
gtk-fetch:
	 $(WGET) -P $(DL_DIR) $(GTK_SITE)/$(GTK_SOURCE)

gtk-source: $(DL_DIR)/$(GTK_SOURCE)
else
gtk-source:
endif

GTK_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d gtk+ $(CVS_TAG) $(CVS_PREFIX)gtk+

gtk-checkout:
	@$(GTK_CVSCO)

$(GTK_DIR)/.unpacked: $(DL_DIR)/$(GTK_SOURCE)
ifneq ($(USE_CVS),true)
	$(GTK_CAT) $(DL_DIR)/$(GTK_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(GTK_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(GTK_DIR)/
	touch $(GTK_DIR)/.unpacked

$(GTK_DIR)/.configured: $(GTK_DIR)/.unpacked
	(cd $(GTK_DIR); rm -rf config.cache; automake -a; \
		EGREP=egrep \
		GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/lib/glib-2.0/include" \
		GLIB_LIBS="-L$(STAGING_DIR)/usr/lib -lglib-2.0" autoconf; autoheader; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS) -I$(STAGING_DIR)/usr/include -I$(STAGING_DIR)/usr/include/freetype2 -I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/lib/glib-2.0/include -I$(STAGING_DIR)/usr/include/libpng12 -I$(STAGING_DIR)/usr/include/pango-1.0 -I$(STAGING_DIR)/usr/include/atk-1.0" \
		LDFLAGS="-L$(STAGING_DIR)/lib -L$(STAGING_DIR)/usr/lib -L$(STAGING_DIR)/usr/X11R6/lib" \
		ac_cv_path_FREETYPE_CONFIG=$(STAGING_DIR)/bin/freetype-config \
		PKG_CONFIG_PATH=$(STAGING_DIR)/lib/pkgconfig \
		PANGO_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/lib/glib-2.0/include -I$(STAGING_DIR)/usr/include/pango-1.0" \
		STAGING_DIR=$(STAGING_DIR) \
		lt_cv_prog_cc_pic=' -fPIC -DPIC' \
		lt_cv_prog_cc_can_build_shared=yes \
		lt_cv_prog_cc_no_builtin= \
		lt_cv_prog_cc_shlib= \
		lt_cv_prog_cc_static=-static \
		lt_cv_prog_cc_static_works=yes \
		lt_cv_prog_cc_wl=-Wl, \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--without-qt \
		--without-x \
		--without-libtiff \
		--disable-gtk-doc \
		--disable-glibtest \
	);
	touch  $(GTK_DIR)/.configured

$(GTK_DIR)/gtk/.libs/libgtk-directfb-2.0.so: $(GTK_DIR)/.configured
	$(MAKE) CC_FOR_BUILD=$(HOSTCC)  \
		EGREP=egrep \
		GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/lib/glib-2.0/include" \
		GLIB_LIBS="-L$(STAGING_DIR)/usr/lib -lglib-2.0"  \
		FREETYPE_LIBS="-lfontconfig -lfreetype -lxmlparse -lxmltok -lgmodule-2.0 -lgobject-2.0 -lglib-2.0" -C $(GTK_DIR)

$(STAGING_DIR)/usr/lib/libgtk-directfb-2.0.so: $(GTK_DIR)/gtk/.libs/libgtk-directfb-2.0.so
	$(MAKE) \
	    EGREP=egrep \
	    CC_FOR_BUILD=$(HOSTCC)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/gtk \
	    -C $(GTK_DIR) install-strip;
	chmod a-x $(STAGING_DIR)/usr/lib/libgtk*so*
	rm -f $(STAGING_DIR)/usr/lib/libgtk*.la

$(TARGET_DIR)/usr/lib/libgtk-directfb-2.0.so: $(STAGING_DIR)/usr/lib/libgtk-directfb-2.0.so
	$(MAKE) \
	    EGREP=egrep \
	    GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/lib/glib-2.0/include" \
	    GLIB_LIBS="-L$(STAGING_DIR)/usr/lib" \
	    CC_FOR_BUILD=$(HOSTCC)  \
	    prefix=$(STAGING_DIR) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/gtk \
	    -C $(GTK_DIR) install-strip;
	chmod a-x $(TARGET_DIR)/usr/lib/libgtk*so*
	mv $(TARGET_DIR)/bin/gtk-demo $(TARGET_DIR)/bin/gtk-demo-dfb
	install -D $(SOURCE_DIR)/gtkrc $(TARGET_DIR)/etc/gtk-2.0/gtkrc
	install -D $(SOURCE_DIR)/gtk.immodules $(TARGET_DIR)/etc/gtk-2.0/gtk.immodules
	install -D $(SOURCE_DIR)/gdk-pixbuf.loaders $(TARGET_DIR)/etc/gtk-2.0/gdk-pixbuf.loaders
	install -D $(SOURCE_DIR)/appwindow.c $(TARGET_DIR)/usr/share/gtk-2.0/demo/appwindow.c
	install -D $(SOURCE_DIR)/gtk-logo-rgb.gif $(TARGET_DIR)/usr/share/gtk-2.0/demo/gtk-logo-rgb.gif
	rm -f $(TARGET_DIR)/usr/lib/libgtk*.la
	rm -f $(TARGET_DIR)/etc/fb.modes
	mkdir -p $(DOC_DIR)/doc/gtk
	@for f in COPYING README ; do \
		install -m0644 -D $(GTK_DIR)/$$f $(DOC_DIR)/doc/gtk/$$f ;\
	done

gtk-clean:
	-$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/gtk \
	    -C $(GTK_DIR) uninstall
	-$(MAKE)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/gtk \
	    -C $(GTK_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/gtk
	$(MAKE) -C $(GTK_DIR) clean


gtk-dirclean:
	rm -rf $(GTK_DIR)

gtk: uclibc $(TARGET_DIR)/usr/lib/libgtk-directfb-2.0.so


