#############################################################
#
# initscripts
#
#############################################################

ifneq ($(USE_CVS), true)
INITSCRIPTS_SOURCE:=initscripts.tar.gz
INITSCRIPTS_CAT:=zcat
endif

INITSCRIPTS_DIR:=$(BUILD_DIR)/initscripts
INITSCRIPTS_BINARY:=initscripts
INITSCRIPTS_TARGET_BINARY:=usr/bin/initscripts

INITSCRIPTS_DEFS := GLIB_LIBFLAGS="-lglib-2.0" \
		    GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/usr/lib/glib-2.0/include"


ifneq ($(USE_CVS),true)
$(DL_DIR)/$(INITSCRIPTS_SOURCE):

initscripts-source: $(DL_DIR)/$(INITSCRIPTS_SOURCE)
else
initscripts-source:
endif

INITSCRIPTS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d initscripts $(CVS_TAG) $(CVS_PREFIX)initscripts

initscripts-checkout:
	@$(INITSCRIPTS_CVSCO)

ifneq ($(USE_CVS), true)
$(INITSCRIPTS_DIR)/.unpacked: $(DL_DIR)/$(INITSCRIPTS_SOURCE)
	$(INITSCRIPTS_CAT) $(DL_DIR)/$(INITSCRIPTS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
$(INITSCRIPTS_DIR)/.unpacked: 
	@$(INITSCRIPTS_CVSCO)
endif
	-cat $(SOURCE_DIR)/initscripts.patch | patch -p0 -d $(INITSCRIPTS_DIR)
	touch  $(INITSCRIPTS_DIR)/.unpacked

$(INITSCRIPTS_DIR)/.built: $(INITSCRIPTS_DIR)/.unpacked
	$(MAKE) $(TARGET_CONFIGURE_OPTS) LDFLAGS="-L$(STAGING_DIR)/usr/lib" $(INITSCRIPTS_DEFS) -C $(INITSCRIPTS_DIR)
	touch $(INITSCRIPTS_DIR)/.built

$(INITSCRIPTS_DIR)/.installed: $(INITSCRIPTS_DIR)/.built
	-rm -rf $(TARGET_DIR)/etc/init.d
	$(MAKE) $(TARGET_CONFIGURE_OPTS) ROOT=$(TARGET_DIR) -C $(INITSCRIPTS_DIR) install
	# chkconfig does this in RH*L, but who cares..
	-ln -s rc.d/init.d $(TARGET_DIR)/etc/init.d
	-sed -i -e 's,^(kernel\.sysrq =) *0,\1 1,' $(TARGET_DIR)/etc/sysctl.conf
	install -d $(DOC_DIR)/doc/initscripts
	for f in sysconfig.txt sysvinitfiles ipv6-6to4.howto \
			ipv6-tunnel.howto static-routes-ipv6 ; do \
		install -m0644 $(INITSCRIPTS_DIR)/$$f $(DOC_DIR)/doc/initscripts ;\
	done
	for s in random network rawdevices; \
		do $(SOURCE_DIR)/addservice $(TARGET_DIR) $$s ; \
	done
	touch $(INITSCRIPTS_DIR)/.installed

initscripts: uclibc sysvinit glib2 popt $(INITSCRIPTS_DIR)/.installed

initscripts-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(INITSCRIPTS_DIR) uninstall
	-rm -f $(INITSCRIPTS_DIR)/.installed \
		$(INITSCRIPTS_DIR)/.built
	-$(MAKE) -C $(INITSCRIPTS_DIR) clean

initscripts-dirclean:
	rm -rf $(INITSCRIPTS_DIR)

