#############################################################
#
# iproute
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
IPROUTE_SOURCE:=iproute.tar.gz
IPROUTE_SITE:=ftp://ftp.gnu.org/gnu/iproute
IPROUTE_CAT:=zcat
endif

IPROUTE_DIR:=$(BUILD_DIR)/iproute
IPROUTE_BINARY:=ip/ip
IPROUTE_TARGET_BINARY:=sbin/ip

ifneq ($(USE_CVS),true)
iproute-fetch:
	 $(WGET) -P $(DL_DIR) $(IPROUTE_SITE)/$(IPROUTE_SOURCE)

iproute-source: $(DL_DIR)/$(IPROUTE_SOURCE)
else
iproute-source:
endif

IPROUTE_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d iproute $(CVS_TAG) $(CVS_PREFIX)iproute

iproute-checkout: 
	@$(IPROUTE_CVSCO)

$(IPROUTE_DIR)/.unpacked: $(DL_DIR)/$(IPROUTE_SOURCE)
ifneq ($(USE_CVS),true)
	$(IPROUTE_CAT) $(DL_DIR)/$(IPROUTE_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(IPROUTE_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(IPROUTE_DIR)/
	touch $(IPROUTE_DIR)/.unpacked

$(IPROUTE_DIR)/$(IPROUTE_BINARY): $(IPROUTE_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) KERNEL_INCLUDE=$(STAGING_DIR)/usr/include LIBC_INCLUDE=$(STAGING_DIR)/usr/include -C $(IPROUTE_DIR)
	$(MAKE) CC=$(TARGET_CC) -C $(IPROUTE_DIR)/doc

$(TARGET_DIR)/$(IPROUTE_TARGET_BINARY): $(IPROUTE_DIR)/$(IPROUTE_BINARY)
	@for f in ip/ip ip/ifcfg ip/rtmon tc/tc ; do \
		install -m0755 $(IPROUTE_DIR)/$$f $(TARGET_DIR)/sbin ;\
	done
	install -m0755 $(IPROUTE_DIR)/ip/rtacct $(TARGET_DIR)/usr/sbin
	install -m0755 $(IPROUTE_DIR)/ip.8 $(TARGET_DIR)/usr/man/man8
	install -d $(TARGET_DIR)/etc/iproute2
	cp -f $(IPROUTE_DIR)/etc/iproute2/rt_* $(TARGET_DIR)/etc/iproute2
	install -d $(DOC_DIR)/doc/iproute
	@for f in README.decnet README.iproute2+tc RELNOTES  ; do \
		install -m0644 $(IPROUTE_DIR)/$$f $(DOC_DIR)/doc/iproute/$$f ;\
	done
	cp -R $(IPROUTE_DIR)/examples $(DOC_DIR)/doc/iproute/
	-find $(DOC_DIR)/doc/iproute -name CVS -type d | xargs rm -rf

iproute: uclibc $(TARGET_DIR)/$(IPROUTE_TARGET_BINARY)

iproute-clean:
	-@for f in ip/ip ip/ifcfg ip/rtmon tc/tc ; do \
		rm -f $(TARGET_DIR)/sbin/$$f || : ;\
	done
	-rm -f $(TARGET_DIR)/usr/sbin/rtacct
	-rm -rf $(TARGET_DIR)/etc/iproute2
	-rm -f $(TARGET_DIR)/usr/man/man8/ip.8
	-rm -rf $(DOC_DIR)/doc/iproute
	-$(MAKE) -C $(IPROUTE_DIR) clean

iproute-dirclean:
	rm -rf $(IPROUTE_DIR)
endif

