#############################################################
#
# iputils
#
#############################################################

ifneq ($(USE_CVS), true)
IPUTILS_SOURCE:=iputils.tar.gz
IPUTILS_DIR:=$(BUILD_DIR)/iputils
IPUTILS_CAT:=zcat
else
IPUTILS_DIR:=$(BUILD_DIR)/iputils
endif

#IPUTILS_TARGETS := tracepath ping clockdiff rdisc arping tftpd rarpd \
#		tracepath6 traceroute6 ping6

IPUTILS_TARGETS := ping arping ping6

IPUTILS_BINARIES:= $(addprefix $(IPUTILS_DIR)/, $(IPUTILS_TARGETS))

IPUTILS_TARGET_BINARIES:= $(TARGET_DIR)/bin/ping \
			$(TARGET_DIR)/sbin/arping \
			$(TARGET_DIR)/bin/ping6

IPUTILS_TARGET_MANS:= $(TARGET_DIR)/usr/man/man8/ping.8 \
			$(TARGET_DIR)/usr/man/man8/arping.8 \

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(IPUTILS_SOURCE):

iputils-source: $(DL_DIR)/$(IPUTILS_SOURCE)
else
iputils-source:
endif

IPUTILS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d iputils $(CVS_TAG) $(CVS_PREFIX)iputils

iputils-checkout:
	@$(IPUTILS_CVSCO)

$(IPUTILS_DIR)/.unpacked: $(DL_DIR)/$(IPUTILS_SOURCE)
ifneq ($(USE_CVS), true)
	$(IPUTILS_CAT) $(DL_DIR)/$(IPUTILS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(IPUTILS_CVSCO)
endif
	-cat $(SOURCE_DIR)/iputils.patch | patch -p0 -d $(IPUTILS_DIR)
	touch  $(IPUTILS_DIR)/.unpacked

$(IPUTILS_BINARIES): $(IPUTILS_DIR)/.unpacked
	$(MAKE) $(TARGET_CONFIGURE_OPTS) STAGING_DIR=$(STAGING_DIR) -C $(IPUTILS_DIR)

$(IPUTILS_TARGET_BINARIES): $(IPUTILS_BINARIES)
	install -m 0755 $(IPUTILS_DIR)/ping $(TARGET_DIR)/bin/ping
	install -m 0755 $(IPUTILS_DIR)/arping $(TARGET_DIR)/sbin/arping
	install -m 0755 $(IPUTILS_DIR)/ping6 $(TARGET_DIR)/bin/ping6
	install -m 0644 $(IPUTILS_DIR)/doc/ping.8 $(TARGET_DIR)/usr/man/man8/ping.8
	install -m 0644 $(IPUTILS_DIR)/doc/arping.8 $(TARGET_DIR)/usr/man/man8/arping.8

iputils: uclibc $(IPUTILS_TARGET_BINARIES)

iputils-clean:
	-rm -rf $(IPUTILS_TARGET_BINARIES)
	-rm -rf $(IPUTILS_TARGET_MANS)
	-$(MAKE) -C $(IPUTILS_DIR) clean

iputils-dirclean:
	rm -rf $(IPUTILS_DIR)

