#############################################################
#
# logrotate
#
#############################################################
ifneq ($(USE_CVS), true)
LOGROTATE_SOURCE:=logrotate.tar.gz
LOGROTATE_CAT:=zcat
endif
LOGROTATE_DIR:=$(BUILD_DIR)/logrotate

LOGROTATE_BINARY:=logrotate
LOGROTATE_TARGET_BINARY:=usr/sbin/logrotate

TARGET_LOGROTATE_DIR := $(TARGET_DIR)/etc/logrotate.d

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(LOGROTATE_SOURCE):

logrotate-source: $(DL_DIR)/$(LOGROTATE_SOURCE)
else
logrotate-source:
endif

LOGROTATE_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d logrotate $(CVS_TAG) $(CVS_PREFIX)logrotate

logrotate-checkout:
	@$(LOGROTATE_CVSCO)

$(LOGROTATE_DIR)/.unpacked: $(DL_DIR)/$(LOGROTATE_SOURCE)
ifneq ($(USE_CVS), true)
	$(LOGROTATE_CAT) $(DL_DIR)/$(LOGROTATE_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LOGROTATE_CVSCO)
endif
	-cat $(SOURCE_DIR)/logrotate.patch | patch -p1 -d $(LOGROTATE_DIR)
	touch  $(LOGROTATE_DIR)/.unpacked

$(LOGROTATE_DIR)/.configured: $(LOGROTATE_DIR)/.unpacked
	touch $(LOGROTATE_DIR)/.configured

$(LOGROTATE_DIR)/$(LOGROTATE_BINARY): $(LOGROTATE_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) OS_NAME=Linux WITH_SELINUX=no -C $(LOGROTATE_DIR)

$(TARGET_DIR)/$(LOGROTATE_TARGET_BINARY): $(LOGROTATE_DIR)/$(LOGROTATE_BINARY)
	install $(LOGROTATE_DIR)/$(LOGROTATE_BINARY) $(TARGET_DIR)/$(LOGROTATE_TARGET_BINARY)
	if [ ! -d $(TARGET_LOGROTATE_DIR) ]; then \
		mkdir --mode=0755 -p $(TARGET_LOGROTATE_DIR); \
	fi
	install -m0644 $(LOGROTATE_DIR)/examples/logrotate-default $(TARGET_DIR)/etc/logrotate.conf

logrotate: uclibc popt $(TARGET_DIR)/$(LOGROTATE_TARGET_BINARY)

logrotate-clean:
	rm -rf $(TARGET_DIR)/$(LOGROTATE_TARGET_BINARY)
	-$(MAKE) -C $(LOGROTATE_DIR) clean

logrotate-dirclean:
	rm -rf $(LOGROTATE_DIR)

