#############################################################
#
# makedev
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
MAKEDEV_SOURCE:=makedev.tar.gz
MAKEDEV_CAT:=zcat
endif

MAKEDEV_DIR:=$(BUILD_DIR)/makedev
MAKEDEV_BINARY:=MAKEDEV
MAKEDEV_TARGET_BINARY:=dev/MAKEDEV

ifneq ($(USE_CVS),true)
makedev-fetch:
	 $(WGET) -P $(DL_DIR) $(MAKEDEV_SITE)/$(MAKEDEV_SOURCE)

makedev-source: $(DL_DIR)/$(MAKEDEV_SOURCE)
else
makedev-source:
endif

MAKEDEV_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d makedev $(CVS_TAG) $(CVS_PREFIX)makedev

makedev-checkout:
	@$(MAKEDEV_CVSCO)

$(MAKEDEV_DIR)/.unpacked: $(DL_DIR)/$(MAKEDEV_SOURCE)
ifneq ($(USE_CVS),true)
	$(MAKEDEV_CAT) $(DL_DIR)/$(MAKEDEV_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(MAKEDEV_CVSCO)
endif
	touch $(MAKEDEV_DIR)/.unpacked

$(MAKEDEV_DIR)/$(MAKEDEV_BINARY): $(MAKEDEV_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) -C $(MAKEDEV_DIR)

$(TARGET_DIR)/$(MAKEDEV_TARGET_BINARY): $(MAKEDEV_DIR)/$(MAKEDEV_BINARY)
	$(MAKE) \
		DESTDIR=$(TARGET_DIR) \
		mandir=$(TARGET_DIR)/usr/man \
		-C $(MAKEDEV_DIR) install
	install -d $(DOC_DIR)/doc/makedev
	@for f in COPYING devices.txt ; do \
		install -m0644 $(MAKEDEV_DIR)/$$f $(DOC_DIR)/doc/makedev/$$f ;\
	done

makedev: uclibc $(TARGET_DIR)/$(MAKEDEV_TARGET_BINARY)

makedev-clean:
	-rm -f $(TARGET_DIR)/$(MAKEDEV_TARGET_BINARY) \
		$(TARGET_DIR)/usr/sbin/mksock \
		$(TARGET_DIR)/etc/makedev.d
	-rm -rf $(DOC_DIR)/doc/makedev
	-$(MAKE) -C $(MAKEDEV_DIR) clean

makedev-dirclean:
	rm -rf $(MAKEDEV_DIR)
endif

