#############################################################
#
# netkitntalk
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITNTALK_SOURCE:=netkit-ntalk.tar.gz
NETKITNTALK_SITE:=ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/
NETKITNTALK_DIR:=$(BUILD_DIR)/${shell basename $(NETKITNTALK_SOURCE) .tar.gz}

NETKITNTALK_CAT:=zcat
else
# using CVS
NETKITNTALK_DIR:=$(BUILD_DIR)/netkit-ntalk
endif

NETKITNTALK_BINARY:=ntalk/ntalk
NETKITNTALK_TARGET_BINARY:=usr/bin/ntalk

ifneq ($(USE_CVS),true)
netkitntalk-fetch:
	 $(WGET) -P $(DL_DIR) $(NETKITNTALK_SITE)/$(NETKITNTALK_SOURCE)

netkitntalk-source: $(DL_DIR)/$(NETKITNTALK_SOURCE)
else
netkitntalk-source:
endif

NETKITNTALK_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d netkit-ntalk $(CVS_TAG) $(CVS_PREFIX)netkit-ntalk

netkitntalk-checkout:
	@$(NETKITNTALK_CVSCO)

$(NETKITNTALK_DIR)/.unpacked: $(DL_DIR)/$(NETKITNTALK_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITNTALK_CAT) $(DL_DIR)/$(NETKITNTALK_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITNTALK_CVSCO)
endif
	touch $(NETKITNTALK_DIR)/.unpacked

$(NETKITNTALK_DIR)/.configured: $(NETKITNTALK_DIR)/.unpacked
	(cd $(NETKITNTALK_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITNTALK_DIR)/.configured

$(NETKITNTALK_DIR)/$(NETKITNTALK_BINARY): $(NETKITNTALK_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(NETKITNTALK_DIR)

$(TARGET_DIR)/$(NETKITNTALK_TARGET_BINARY): $(NETKITNTALK_DIR)/$(NETKITNTALK_BINARY)
	$(MAKE) STRIP=$(TARGET_CROSS)strip INSTALLROOT=$(TARGET_DIR) -C $(NETKITNTALK_DIR) install
	sed -i -e "s~^# *talk.*~talk\tdgram\tudp\twait\troot\t/usr/sbin/in.talkd\t/usr/sbin/in.talkd~;" $(TARGET_DIR)/etc/inetd.conf
	sed -i -e "s~^# *ntalk.*~ntalk\tdgram\tudp\twait\troot\t/usr/sbin/in.ntalkd\t/usr/sbin/in.ntalkd~;" $(TARGET_DIR)/etc/inetd.conf
	mkdir -p $(DOC_DIR)/doc/netkit-ntalk
	for f in BUGS README ; do \
	    install -m0644 $(NETKITNTALK_DIR)/$$f $(DOC_DIR)/doc/netkit-ntalk/$$f ; \
	done

netkitntalk: uclibc tcp_wrappers $(TARGET_DIR)/$(NETKITNTALK_TARGET_BINARY)

netkitntalk-clean:
	-rm -f $(TARGET_DIR)/$(NETKITNTALK_TARGET_BINARY)
	-$(MAKE) -C $(NETKITNTALK_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-ntalk

netkitntalk-dirclean:
	rm -rf $(NETKITNTALK_DIR)

