#############################################################
#
# popt
#
#############################################################
ifneq ($(USE_CVS), true)
POPT_SOURCE:=popt.tar.gz
POPT_CAT:=zcat
endif
POPT_DIR:=$(BUILD_DIR)/popt

POPT_LIBRARY:=.libs/libpopt.a
POPT_HEADER:=popt.h
POPT_STAGING_LIBRARY:=usr/lib/libpopt.a
POPT_STAGING_HEADER:=usr/include/popt.h

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(POPT_SOURCE):

popt-source: $(DL_DIR)/$(POPT_SOURCE)
else
popt-source:
endif

POPT_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d popt $(CVS_TAG) $(CVS_PREFIX)popt

popt-checkout:
	@$(POPT_CVSCO)

$(POPT_DIR)/.unpacked: $(DL_DIR)/$(POPT_SOURCE)
ifneq ($(USE_CVS), true)
	$(POPT_CAT) $(DL_DIR)/$(POPT_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(POPT_CVSCO)
endif
	-cat $(SOURCE_DIR)/popt.patch | patch -p1 -d $(POPT_DIR)
	touch  $(POPT_DIR)/.unpacked

$(POPT_DIR)/.configured: $(POPT_DIR)/.unpacked
	(cd $(POPT_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
	);
	touch $(POPT_DIR)/.configured

$(POPT_DIR)/$(POPT_LIBRARY): $(POPT_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(POPT_DIR) libpopt.la

$(STAGING_DIR)/$(POPT_STAGING_LIBRARY): $(POPT_DIR)/$(POPT_LIBRARY)
	install $(POPT_DIR)/$(POPT_LIBRARY) $(STAGING_DIR)/$(POPT_STAGING_LIBRARY)
	install $(POPT_DIR)/$(POPT_HEADER)  $(STAGING_DIR)/$(POPT_STAGING_HEADER)

popt: uclibc $(STAGING_DIR)/$(POPT_STAGING_LIBRARY)

popt-clean:
	$(MAKE) CC=$(TARGET_CC) -C $(POPT_DIR) uninstall
	-$(MAKE) -C $(POPT_DIR) clean

popt-dirclean:
	rm -rf $(POPT_DIR)

