#############################################################
#
# pump
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
PUMP_SOURCE:=pump.tar.gz
PUMP_SITE:=ftp://ftp.gnu.org/gnu/pump
PUMP_CAT:=zcat
endif

PUMP_DIR:=$(BUILD_DIR)/pump
PUMP_BINARY:=pump
PUMP_TARGET_BINARY:=sbin/pump

ifneq ($(USE_CVS),true)
pump-fetch:
	 $(WGET) -P $(DL_DIR) $(PUMP_SITE)/$(PUMP_SOURCE)

pump-source: $(DL_DIR)/$(PUMP_SOURCE)
else
pump-source:
endif

PUMP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d pump $(CVS_TAG) $(CVS_PREFIX)pump

pump-checkout:
	@$(PUMP_CVSCO)

$(PUMP_DIR)/.unpacked: $(DL_DIR)/$(PUMP_SOURCE)
ifneq ($(USE_CVS),true)
	$(PUMP_CAT) $(DL_DIR)/$(PUMP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PUMP_CVSCO)
endif
	sed -i -e 's,[[:space:]]/usr/lib,$(STAGING_DIR)/usr/lib,' $(PUMP_DIR)/Makefile
	touch $(PUMP_DIR)/.unpacked

$(PUMP_DIR)/$(PUMP_BINARY): $(PUMP_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) -C $(PUMP_DIR) pump

$(TARGET_DIR)/$(PUMP_TARGET_BINARY): $(PUMP_DIR)/$(PUMP_BINARY)
	install -m0755 $(PUMP_DIR)/$(PUMP_BINARY) $(TARGET_DIR)/$(PUMP_TARGET_BINARY)
	install -m0644 $(PUMP_DIR)/pump.8 $(TARGET_DIR)/usr/man/man8
	install -m0644 $(PUMP_DIR)/libpump.a $(STAGING_DIR)/usr/lib
	install -m0644 $(PUMP_DIR)/pump.h $(STAGING_DIR)/usr/include
	$(STRIP) $(TARGET_DIR)/$(PUMP_TARGET_BINARY)
	install -d $(DOC_DIR)/doc/pump
	@for f in COPYING CREDITS ; do \
		install -m0644 $(PUMP_DIR)/$$f $(DOC_DIR)/doc/pump/$$f ;\
	done

pump: uclibc popt $(TARGET_DIR)/$(PUMP_TARGET_BINARY)

pump-clean:
	-rm -f $(TARGET_DIR)/$(PUMP_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/man/man8/pump.8
	-rm -f $(STAGING_DIR)/usr/lib/libpump.a
	-rm -f $(STAGING_DIR)/usr/include/pump.h
	-rm -rf $(DOC_DIR)/doc/pump
	-$(MAKE) -C $(PUMP_DIR) clean

pump-dirclean:
	rm -rf $(PUMP_DIR)
endif

