#############################################################
#
# sash
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
SASH_SOURCE:=sash.tar.gz
SASH_CAT:=zcat
endif

SASH_DIR:=$(BUILD_DIR)/sash
SASH_BINARY:=sash
SASH_TARGET_BINARY:=bin/sash

ifneq ($(USE_CVS),true)
sash-fetch:
	 $(WGET) -P $(DL_DIR) $(SASH_SITE)/$(SASH_SOURCE)

sash-source: $(DL_DIR)/$(SASH_SOURCE)
else
sash-source:
endif

SASH_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d sash $(CVS_TAG) $(CVS_PREFIX)sash

sash-checkout:
	@$(SASH_CVSCO)

$(SASH_DIR)/.unpacked: $(DL_DIR)/$(SASH_SOURCE)
ifneq ($(USE_CVS),true)
	$(SASH_CAT) $(DL_DIR)/$(SASH_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SASH_CVSCO)
endif
	touch $(SASH_DIR)/.unpacked

$(SASH_DIR)/$(SASH_BINARY): $(SASH_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) -C $(SASH_DIR)

$(TARGET_DIR)/$(SASH_TARGET_BINARY): $(SASH_DIR)/$(SASH_BINARY)
	$(MAKE) BINDIR=$(TARGET_DIR)/bin MANDIR=$(TARGET_DIR)/usr/man/man1 -C $(SASH_DIR) install
	install -d $(DOC_DIR)/doc/sash
	@for f in README ; do \
		install -m0644 $(SASH_DIR)/$$f $(DOC_DIR)/doc/sash/$$f ;\
	done

sash: uclibc $(TARGET_DIR)/$(SASH_TARGET_BINARY)

sash-clean:
	-rm -f $(SASH_TARGET_BINARY) $(TARGET_DIR)/usr/man/man1/sash.1
	-rm -rf $(DOC_DIR)/doc/sash
	-$(MAKE) -C $(SASH_DIR) clean

sash-dirclean:
	rm -rf $(SASH_DIR)
endif

