#############################################################
#
# sysstat
#
#############################################################

ifneq ($(USE_CVS), true)
SYSSTAT_SOURCE:=sysstat.tar.gz
SYSSTAT_CAT:=zcat
endif

SYSSTAT_DIR:=$(BUILD_DIR)/sysstat
SYSSTAT_BINARY:=sar
SYSSTAT_TARGET_BINARY:=usr/bin/sar

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(SYSSTAT_SOURCE):

sysstat-source: $(DL_DIR)/$(SYSSTAT_SOURCE)
else
sysstat-source:
endif

SYSSTAT_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d sysstat $(CVS_TAG) $(CVS_PREFIX)sysstat

sysstat-checkout:
	@$(SYSSTAT_CVSCO)

$(SYSSTAT_DIR)/.unpacked: $(DL_DIR)/$(SYSSTAT_SOURCE)
ifneq ($(USE_CVS), true)
	$(SYSSTAT_CAT) $(DL_DIR)/$(SYSSTAT_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SYSSTAT_CVSCO)
endif
	touch  $(SYSSTAT_DIR)/.unpacked

$(SYSSTAT_DIR)/$(SYSSTAT_BINARY): $(SYSSTAT_DIR)/.unpacked
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(SYSSTAT_DIR)
	cp $(SOURCE_DIR)/sysstat.crond  $(SYSSTAT_DIR)

$(TARGET_DIR)/$(SYSSTAT_TARGET_BINARY): $(SYSSTAT_DIR)/$(SYSSTAT_BINARY)

sysstat: uclibc $(TARGET_DIR)/$(SYSSTAT_TARGET_BINARY)
	$(MAKE) $(TARGET_CONFIGURE_OPTS) DESTDIR=$(TARGET_DIR) -C $(SYSSTAT_DIR) install
	$(MAKE) $(TARGET_CONFIGURE_OPTS) DESTDIR=$(STAGING_DIR) -C $(SYSSTAT_DIR) install
	mkdir -p $(TARGET_DIR)/var/log/sa
	mkdir -p $(STAGING_DIR)/var/log/sa
	mkdir -p $(TARGET_DIR)/etc/cron.d
	install $(SYSSTAT_DIR)/sysstat.crond $(TARGET_DIR)/etc/cron.d/sysstat
	mkdir -p $(STAGING_DIR)/etc/cron.d
	install $(SYSSTAT_DIR)/sysstat.crond $(STAGING_DIR)/etc/cron.d/sysstat

sysstat-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(SYSSTAT_DIR) uninstall
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(SYSSTAT_DIR) uninstall
	-$(MAKE) -C $(SYSSTAT_DIR) clean
	rm -f $(TARGET_DIR)/etc/cron.d/sysstat
	rm -f $(STAGING_DIR)/etc/cron.d/sysstat

sysstat-dirclean:
	rm -rf $(SYSSTAT_DIR)

