#############################################################
#
# traceroute
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
TRACEROUTE_SOURCE:=traceroute.tar.gz
TRACEROUTE_SITE:=ftp://ftp.gnu.org/gnu/traceroute
TRACEROUTE_CAT:=zcat
endif

TRACEROUTE_DIR:=$(BUILD_DIR)/traceroute
TRACEROUTE_BINARY:=traceroute
TRACEROUTE_TARGET_BINARY:=usr/sbin/traceroute

ifneq ($(USE_CVS),true)
traceroute-fetch:
	 $(WGET) -P $(DL_DIR) $(TRACEROUTE_SITE)/$(TRACEROUTE_SOURCE)

traceroute-source: $(DL_DIR)/$(TRACEROUTE_SOURCE)
else
traceroute-source:
endif

TRACEROUTE_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d traceroute $(CVS_TAG) $(CVS_PREFIX)traceroute

traceroute-checkout:
	@$(TRACEROUTE_CVSCO)

$(TRACEROUTE_DIR)/.unpacked: $(DL_DIR)/$(TRACEROUTE_SOURCE)
ifneq ($(USE_CVS),true)
	$(TRACEROUTE_CAT) $(DL_DIR)/$(TRACEROUTE_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(TRACEROUTE_CVSCO)
endif
	rm -f $(TRACEROUTE_DIR)/config.sub
	cp $(SOURCE_DIR)/config.sub $(TRACEROUTE_DIR)/
	touch $(TRACEROUTE_DIR)/.unpacked

$(TRACEROUTE_DIR)/.configured: $(TRACEROUTE_DIR)/.unpacked
	(cd $(TRACEROUTE_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(TRACEROUTE_DIR)/.configured

$(TRACEROUTE_DIR)/$(TRACEROUTE_BINARY): $(TRACEROUTE_DIR)/.configured
	$(MAKE) -C $(TRACEROUTE_DIR)

$(TARGET_DIR)/$(TRACEROUTE_TARGET_BINARY): $(TRACEROUTE_DIR)/$(TRACEROUTE_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(TRACEROUTE_DIR) install install-man
	$(STRIP) $(TARGET_DIR)/$(TRACEROUTE_TARGET_BINARY)
	ln -sf ../usr/sbin/traceroute $(TARGET_DIR)/bin/traceroute
	install -d $(DOC_DIR)/doc/traceroute
	install -m0644 $(TRACEROUTE_DIR)/README $(DOC_DIR)/doc/traceroute/README


traceroute: uclibc $(TARGET_DIR)/$(TRACEROUTE_TARGET_BINARY)

traceroute-clean:
	-rm -f $(TARGET_DIR)/$(TRACEROUTE_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/bin/traceroute
	-rm -f $(TARGET_DIR)/usr/man/man8/traceroute.8
	-rm -rf $(DOC_DIR)/doc/traceroute
	-$(MAKE) -C $(TRACEROUTE_DIR) clean

traceroute-dirclean:
	rm -rf $(TRACEROUTE_DIR)
endif

