#############################################################
#
# XFree86
#
#############################################################
ifneq ($(USE_CVS),true)
XFREE86_SOURCE:=XFree86.tar.gz
XFREE86_SITE:=xxxxxxxxxxxxxxxxxxxxxxxx
XFREE86_CAT:=zcat
endif

XFREE86_DIR:=$(BUILD_DIR)/XFree86

ifneq ($(USE_CVS),true)
XFree86-fetch:
	 $(WGET) -P $(DL_DIR) $(XFREE86_SITE)/$(XFREE86_SOURCE)

XFree86-source: $(DL_DIR)/$(XFREE86_SOURCE)
else
XFree86-source:
endif

XFREE86_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d XFree86 $(CVS_TAG) $(CVS_PREFIX)XFree86

XFree86-checkout:
	@$(XFREE86_CVSCO)

$(XFREE86_DIR)/.unpacked: $(DL_DIR)/$(XFREE86_SOURCE)
ifneq ($(USE_CVS),true)
	$(XFREE86_CAT) $(DL_DIR)/$(XFREE86_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(XFREE86_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(XFREE86_DIR)/
	sed -ie 's,#define StdIncDir.*,#define StdIncDir $(GNUPRO_TARGET_DIR)/sys-root/usr/include,g' $(XFREE86_DIR)/xc/config/cf/cross.def
	sed -ie 's,#define PostIncDir.*,#define PostIncDir $(GNUPRO_TARGET_DIR)/sys-root/usr/include,g' $(XFREE86_DIR)/xc/config/cf/cross.def
	sed -ie 's,#define CcCmd.*,#define CcCmd $(TARGET_CROSS)gcc,g' $(XFREE86_DIR)/xc/config/cf/cross.def
	sed -ie 's,#define CplusplusCmd.*,#define CplusplusCmd $(TARGET_CROSS)g++,g' $(XFREE86_DIR)/xc/config/cf/cross.def
	sed -ie 's,#define LdPostLib.*,#define LdPostLib -L$(GNUPRO_TARGET_DIR)/sys-root/usr/lib,g' $(XFREE86_DIR)/xc/config/cf/cross.def
	touch $(XFREE86_DIR)/.unpacked

$(XFREE86_DIR)/.configured: $(XFREE86_DIR)/.unpacked
	touch  $(XFREE86_DIR)/.configured

$(XFREE86_DIR)/xc/lib/X11/libX11.so: $(XFREE86_DIR)/.configured
	$(MAKE) -C $(XFREE86_DIR)/xc STD_INCLUDES="-I$(STAGING_DIR)/usr/include -I$(STAGING_DIR)/usr/include/libpng" World

$(STAGING_DIR)/usr/X11R6/lib/libX11.so: $(XFREE86_DIR)/xc/lib/X11/libX11.so
	$(MAKE) \
	    EXTRA_LDOPTIONS=" -Wl,-u,main" \
	    DESTDIR=$(STAGING_DIR) \
	    -C $(XFREE86_DIR)/xc install;
	chmod a-x $(STAGING_DIR)/usr/X11R6/lib/libX*so*
	rm -f $(STAGING_DIR)/usr/X11R6/lib/libX*.la

$(TARGET_DIR)/usr/X11R6/lib/libX11.so: $(STAGING_DIR)/usr/X11R6/lib/libX11.so
	$(MAKE) \
	    EXTRA_LDOPTIONS=" -Wl,-u,main" \
	    DESTDIR=$(TARGET_DIR) \
	    -C $(XFREE86_DIR)/xc install;
	chmod a-x $(TARGET_DIR)/usr/X11R6/lib/libX*so*
	echo "/usr/X11R6/lib" > $(TARGET_DIR)/etc/ld.so.conf
	install -m 0664 $(SOURCE_DIR)/profile $(TARGET_DIR)/etc/profile
	install -m 0644 $(SOURCE_DIR)/twmrc $(TARGET_DIR)/root/.twmrc
	install -m 0644 $(SOURCE_DIR)/xinitrc $(TARGET_DIR)/root/.xinitrc
ifeq ($(USE_GLIBC),true)
	install -m 0755 $(SOURCE_DIR)/firstboot.glibc $(TARGET_DIR)/sbin/firstboot
endif
	rm -f $(TARGET_DIR)/usr/X11R6/lib/libX*.la
	mkdir -p $(DOC_DIR)/doc/XFree86
	@for f in INSTALL-X.org RELNOTES RELNOTES-X.org ; do \
		install -m0644 -D $(XFREE86_DIR)/xc/$$f $(DOC_DIR)/doc/XFree86/$$f ;\
	done

XFree86-clean:
	-$(MAKE) \
	    -C $(XFREE86_DIR)/xc uninstall
	-rm -rf $(DOC_DIR)/doc/XFree86
	$(MAKE) -C $(XFREE86_DIR)/xc clean


XFree86-dirclean:
	rm -rf $(XFREE86_DIR)

XFree86: uclibc $(TARGET_DIR)/usr/X11R6/lib/libX11.so


