#!/bin/csh
# -*- mode:SH; -*-
#
# This script creates series of bdf files from TTF file.
#
#
# Please set up parameters
#
# Font dpi:
set DPI=96

#
# TrueType files dir.
set ttf_dir=~/ttf

# TTF files, please specify only base name
# Script will try to use BolD, Italic and BoldItalic versions of face
set FACES="COUR MONOTYPE"

# Output codepage
# koi8.r
# windows.1251
# iso8859.5
# iso8859.2
set LANG_ID=koi8.r

foreach x ( 7 8 9 10 11 12 14 16 18 20 24 30 50 100 150)
foreach z ( $FACES )
set y = ${ttf_dir}/${z}
#
# Simple face
 if( -e ${y}.TTF ) then
     echo ${z} at ${x}pt
     ./ttf2bdf -c m  -m $LANG_ID -p $x -r $DPI ${y}.TTF | bdftopcf | compress > ${DPI}dpi/${z}${x}.pcf.Z
 endif
#
# Bold face
 if( -e ${y}BD.TTF ) then
    echo Bold ${z} at ${x}pt
    ./ttf2bdf -c m  -m $LANG_ID -p $x -r $DPI -w bold  ${y}BD.TTF | bdftopcf | compress > ${DPI}dpi/${z}bd${x}.pcf.Z
 endif
#
# Italic face
 if( -e ${y}I.TTF ) then
    echo Italic ${z} at ${x}pt
    ./ttf2bdf -c m -m $LANG_ID -p $x -r $DPI -s o  ${y}I.TTF | bdftopcf | compress >${DPI}dpi/${z}i${x}.pcf.Z
 endif
#
# Bold Italic face
 if( -e ${y}BI.TTF ) then
    echo Bold Italic ${z} at ${x}pt
    ./ttf2bdf -c m -m $LANG_ID -p $x -r $DPI -w bold -s o  ${y}BI.TTF | bdftopcf | compress > ${DPI}dpi/${z}bi${x}.pcf.Z
 endif
end                                                                     
end

#echo Creating fonts directory...
#cd ${DPI}dpi
#mkfontdir
