/*
   (c) Copyright 2002-2003  Denis Oliver Kropp <dok@directfb.org>
   All rights reserved.

   XDirectFB is mainly based on XDarwin and
   also contains some KDrive, XFree and XWin code.
*/
/* $XFree86: xc/programs/Xserver/hw/directfb/directfb.h,v 1.10 2001/10/14 03:02:18 torrey Exp $ */

#ifndef _DIRECTFBX_H
#define _DIRECTFBX_H

#include <pthread.h>
#include <directfb.h>
#include "inputstr.h"
#include "screenint.h"
#include "extensions/XKB.h"
#include "directfbScreen.h"


void xf86SetRootClip (ScreenPtr pScreen, BOOL enable);

#undef assert
#define assert(x) { if ((x) == 0) \
    FatalError("assert failed on line %d of %s!\n", __LINE__, __FILE__); }
#define kern_assert(x) { if ((x) != KERN_SUCCESS) \
    FatalError("assert failed on line %d of %s with kernel return 0x%x!\n", \
                __LINE__, __FILE__, x); }
                
#define XDIRECTFB_OUTOFMEMORY()    \
     ErrorF( "%s() ran out of system memory!\n", __FUNCTION__ )

/* User preferences used by generic DirectFB X server code */
typedef struct {
     int  defaultOpacity;
     int  unfocusedOpacity;

     Bool enableUnfocused;
     Bool enableFadeIn;
     Bool enableFadeOut;

     Bool enableRoot;

     DFBDisplayLayerID layerID;
} XDirectFBPrefs;

extern XDirectFBPrefs directfbPrefs;

/* location of X11s (0,0) point in global screen coordinates */
extern int                  directfbMainScreenX;
extern int                  directfbMainScreenY;

extern int                  directfbEventsPipe[2];

extern DFBInputDeviceLockState directfbLocks;

#define MIN_KEYCODE XkbMinLegalKeyCode     /* unfortunately, this isnt 0... */


#endif	/* _DIRECTFBX_H */
