.\" $Xorg: proxymngr.man,v 1.4 2001/02/09 02:05:34 xorgcvs Exp $
.\" Copyright 1996, 1998  The Open Group
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\" 
.\"
.\" $XFree86: xc/programs/proxymngr/proxymngr.man,v 1.7 2001/12/14 20:01:02 dawes Exp $
.\"
.TH PROXYMNGR 1 __xorgversion__
.SH NAME
proxymngr - proxy manager service
.SH SYNOPSIS
\fBproxymngr\fP [\fB\-config\fP \fIfilename\fP] [\fB\-timeout\fP \fIseconds\fP] [\fB\-retries\fP \fI#\fP] [\fB\-verbose\fP]
.SH DESCRIPTION
The proxy manager (proxymngr) is responsible for resolving requests from
xfindproxy (and other similar clients), starting new proxies when
appropriate, and keeping track of all of the available proxy services.
The proxy manager strives to reuse existing proxies whenever possible.
.PP
There are two types of proxies that the proxy manager deals with, \fImanaged\fP
and \fIunmanaged\fP proxies.
.PP
A \fImanaged\fP proxy is a proxy that is started ``on demand'' by the proxy manager.
.PP
An \fIunmanaged\fP proxy, on the other hand, is started either at system boot time,
or manually by a system administrator.  The proxy manager is made aware of
its existence, but no attempt is made by the proxy manager to start unmanaged
proxies.
.PP
The command line options that can be specified to
.B proxymngr
are:
.PP
.TP 8
.B \-config
Used to override the default proxymngr config file.
See below for more details about the config file.
.PP
.TP 8
.B \-timeout
Sets the number of seconds between attempts made by the
proxy manager to find an unmanaged proxy.  The default is 10.
.PP
.TP 8
.B \-retries
Sets the maximum number of retries made by the proxy
manager to find an an unmanaged proxy.  The default is 3.
.PP
.TP 8
.B \-verbose
Causes various debugging and tracing records to be displayed as
requests are received and proxies are started.
.PP
.PP
.SH Proxy Manager Config File
.PP
The proxy manager maintains a local configuration file describing the proxy
services available.  This configuration file is installed
in
.I __projectroot__/lib/X11/proxymngr/pmconfig
during the installation
of proxymngr.  The location of the configuration file can be overwritten using
the \fB\-config\fP command line option.
.PP
Aside from lines starting with an exclamation point for comments, each line
of the configuration file describes either an unmanaged or managed proxy
service.
.PP
For unmanaged proxies, the format is:
.IP
<service-name> unmanaged <proxy-address>
.PP
service-name is the name of the unmanaged proxy service, and must not
contain any spaces, for example ``XFWP''.  service-name is case
insenstive.
.PP
proxy-address is the network address of the unmanaged proxy.  The format
of the address is specific to the service-name.  For example, for the
``XFWP'' service, the proxy-address might be ``firewall.x.org:100''.
.PP
If there is more than one entry in the config file with the same
unmanaged service-name, the proxy manager will try to use the proxies
in the order presented in the config file.
.PP
For managed proxies, the format is:
.IP
<service-name> managed <command-to-start-proxy>
.PP
service-name is the name of the managed proxy service, and must not
contain any spaces, for example ``LBX''.  service-name is case insensitive.
.PP
command-to-start-proxy is the command executed by the proxy manager to
start a new instance of the proxy.  If command-to-start-proxy contains
spaces, the complete command should be surrounded by single quotes.
If desired, command-to-start-proxy can be used to start a proxy on a
remote machine.  The specifics of the remote execution method used to
do this is not specified here.
.PP
.SH EXAMPLE
.PP
Here is a sample configuration file:
.PP
.nf
\fC
.RS
! proxy manager config file
!
! Each line has the format:
!    <serviceName> managed <startCommand>
!        or
!    <serviceName> unmanaged <proxyAddress>
!
lbx managed __projectroot__/bin/lbxproxy
!
! substitute site-specific info
xfwp unmanaged firewall:4444
\fP
.RE
.fi
.PP
.SH PROXY MANAGER DETAILS
.PP
When the proxy manager gets a request from xfindproxy (or another similar
client), its course of action will depend on the service-name in question.
.PP
For a managed proxy service, the proxy manager will find out if any of the
already running proxies for this service can handle a new request.  If not,
the proxy manager will attempt to start up a new instance of the proxy
(using the command-to-start-proxy found in the config file).  If that fails,
an error will be returned to the caller.
.PP
For an unmanaged proxy service, the proxy manager will look in the config
file to find all unmanaged proxies for this service.  If there is more than
one entry in the config file with the same unmanaged service-name, the
proxy manager will try to use the proxies in the order presented in the
config file.  If none of the unmanged proxies can satisfy the request, the
proxy manager will timeout for a configurable amount of time (specified by
.B \-timeout
or default of 10) and reattempt to find an unmanaged proxy willing
to satisfy the request.  The number of retries can be specified by the
.B \-retries
argument, or a default of 3 will be used.  If the retries fail,
the proxy manager has no choice but to return an error to the caller (since
the proxy manager can not start unmanaged proxy services).
.PP
.SH BUGS
proxy manager listen port should be configurable.
.PP
.B \-timeout
and
.B \-retries
is not implemented in proxymngr.
.PP
proxymngr does not utilize the ``options'' and ``host'' fields in the
proxy management protocol GetProxyAddr request.
.SH SEE ALSO
xfindproxy (1), xfwp (1), Proxy Management Protocol spec V1.0
.SH AUTHOR
Ralph Mor, X Consortium
