#	$NetBSD: Makefile,v 1.51 2000/12/29 16:30:31 bjh21 Exp $
#	@(#)Makefile	8.4 (Berkeley) 5/5/95

WARNS=2
YHEADER=1
PROG=	sh
SHSRCS=	alias.c cd.c echo.c error.c eval.c exec.c expand.c \
	histedit.c input.c jobs.c mail.c main.c memalloc.c miscbltin.c \
	mystring.c options.c parser.c printf.c redir.c show.c trap.c output.c \
	var.c test.c setmode.c times.c
GENSRCS=arith.c arith.h builtins.c builtins.h init.c nodes.c \
	signames.c nodes.h syntax.c syntax.h token.h
SRCS=	${SHSRCS} ${GENSRCS}

YFLAGS=	-d

CPPFLAGS+=-DSHELL -I. -I${.CURDIR}

.ifdef	HETIO
SHSRCS+=hetio.c
CPPFLAGS+=-DHETIO
.endif

.PATH:	${.CURDIR}/bltin ${.CURDIR}/../../usr.bin/printf ${.CURDIR}/../test

CLEANFILES+= mkinit mknodes mksyntax
CLEANFILES+= ${GENSRCS} y.tab.h

BLTINDEFS=specialbltins.def regularbltins.def assignbltins.def

token.h: mktokens
	sh ${.ALLSRC}

builtins.c builtins.h: mkbuiltins shell.h builtins.def ${BLTINDEFS}
	sh ${.ALLSRC} ${.OBJDIR} '${CFLAGS}'

init.c: mkinit ${SHSRCS}
	./${.ALLSRC}

nodes.c nodes.h: mknodes nodetypes nodes.c.pat
	./${.ALLSRC}

syntax.c syntax.h: mksyntax
	./${.ALLSRC}

signames.c: mksignames
	./${.ALLSRC}

mkinit: mkinit.c
	${HOST_LINK.c} -o mkinit ${.IMPSRC}

mknodes: mknodes.c
	${HOST_LINK.c} -o mknodes ${.IMPSRC}

.if	(${MACHINE_ARCH} == "powerpc") || \
	(${MACHINE_ARCH} == "arm32") || \
	(${MACHINE_ARCH} == "arm26")
TARGET_CHARFLAG= -DTARGET_CHAR="u_int8_t"
.else
TARGET_CHARFLAG= -DTARGET_CHAR="int8_t"
.endif

mksyntax: mksyntax.c
	${HOST_LINK.c} ${TARGET_CHARFLAG} -o mksyntax ${.IMPSRC}

.include <bsd.prog.mk>

${OBJS}: builtins.h nodes.h syntax.h token.h
