#ifndef _ASM_MMU_CONTEXT_H
#define _ASM_MMU_CONTEXT_H

#include <linux/config.h>
#include <asm/setup.h>
#include <asm/page.h>
#include <asm/pgalloc.h>

static inline void enter_lazy_tlb(struct mm_struct *mm, struct task_struct *tsk, unsigned cpu)
{
}

static inline int init_new_context(struct task_struct *tsk, struct mm_struct *mm)
{
	// mm->context = virt_to_phys(mm->pgd);
#ifndef CONFIG_UCLINUX
	mm->context.id = 0;
#endif
	return 0;
}

#define destroy_context(mm)		do { } while(0)

static inline void switch_mm(struct mm_struct *prev, struct mm_struct *next,
			     struct task_struct *tsk, unsigned cpu)
{
#ifndef CONFIG_UCLINUX
	asm volatile("movgs %0,ttbr" : : "r"(virt_to_phys(next->pgd)));
	asm volatile("movgs %0,cxnr" : : "r"(next->context.id));
#endif
}

static inline void activate_mm(struct mm_struct *prev, struct mm_struct *next)
{
#ifndef CONFIG_UCLINUX
	asm volatile("movgs %0,ttbr" : : "r"(virt_to_phys(next->pgd)));
	asm volatile("movgs %0,cxnr" : : "r"(next->context.id));
#endif
}

#endif
