/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client.ui.gui;

import com.ibm.wssvt.acme.common.client.ui.gui.AcmeGUI;
import com.ibm.wssvt.acme.common.client.ui.gui.PropertiesDialog;
import com.ibm.wssvt.acme.common.client.ui.gui.RefreshableAcmeGuiPanel;
import com.ibm.wssvt.acme.common.client.ui.gui.model.AdapterConfigurationDecorator;
import com.ibm.wssvt.acme.common.client.ui.gui.model.ExecutionUnitConfigurationDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AdaptersPanel
extends JPanel
implements RefreshableAcmeGuiPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox cbTemplateAdapters = null;
    private JLabel lblServiceName = null;
    private JScrollPane spSelectedAdapters = null;
    private JList lstConfiguredAdapters = null;
    private JButton btnAddAdapter = null;
    private JButton btnRemoveAdapter = null;
    private JButton btnConfigureAdapter = null;
    private JLabel lblAdapterMessage = null;
    private JButton btnDispalyAdapterTemplateProps = null;
    private JLabel lblSelectedAdapterId = null;

    public AdaptersPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName("Service Adapters");
        this.setSize(1076, 669);
        this.lblSelectedAdapterId = new JLabel();
        this.lblSelectedAdapterId.setBounds(new Rectangle(312, 95, 176, 22));
        this.lblSelectedAdapterId.setText("");
        this.lblSelectedAdapterId.setToolTipText("The selected adapter id");
        this.lblAdapterMessage = new JLabel();
        this.lblAdapterMessage.setBounds(new Rectangle(23, 541, 743, 16));
        this.lblAdapterMessage.setForeground(new Color(255, 51, 51));
        this.lblAdapterMessage.setText("");
        this.lblAdapterMessage.setToolTipText("look here for messages");
        this.lblServiceName = new JLabel();
        this.lblServiceName.setBounds(new Rectangle(19, 15, 105, 16));
        this.lblServiceName.setToolTipText("Select a Service (aka adapter)");
        this.lblServiceName.setText("Select a Service.");
        this.setLayout(null);
        this.add((Component)this.getCbTemplateAdapters(), null);
        this.add((Component)this.lblServiceName, null);
        this.add((Component)this.getSpSelectedAdapters(), null);
        this.add((Component)this.getBtnAddAdapter(), null);
        this.add((Component)this.getBtnRemoveAdapter(), null);
        this.add((Component)this.lblAdapterMessage, null);
        this.add((Component)this.getBtnConfigureAdapter(), null);
        this.add((Component)this.getBtnDispalyAdapterTemplateProps(), null);
        this.add((Component)this.lblSelectedAdapterId, null);
        this.refresh();
    }

    @Override
    public void refresh() {
        DefaultComboBoxModel<AdapterConfigurationDecorator> cbModel = new DefaultComboBoxModel<AdapterConfigurationDecorator>(AcmeGUI.getTemplateAdaptersDataModel());
        this.cbTemplateAdapters.setModel(cbModel);
        DefaultListModel<AdapterConfigurationDecorator> model = new DefaultListModel<AdapterConfigurationDecorator>();
        this.lstConfiguredAdapters.setModel(model);
        for (int i = 0; i < AcmeGUI.getSelectedAdaptersDataModel().size(); ++i) {
            AdapterConfigurationDecorator adapter = AcmeGUI.getSelectedAdaptersDataModel().get(i);
            model.addElement(adapter);
        }
    }

    private JScrollPane getSpSelectedAdapters() {
        if (this.spSelectedAdapters == null) {
            this.spSelectedAdapters = new JScrollPane();
            this.spSelectedAdapters.setBounds(new Rectangle(22, 130, 744, 272));
            this.spSelectedAdapters.setViewportView(this.getLstConfiguredAdapters());
        }
        return this.spSelectedAdapters;
    }

    private JList getLstConfiguredAdapters() {
        if (this.lstConfiguredAdapters == null) {
            this.lstConfiguredAdapters = new JList();
            this.lstConfiguredAdapters.setModel(new DefaultListModel());
            this.lstConfiguredAdapters.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    AdapterConfigurationDecorator selected = (AdapterConfigurationDecorator)AdaptersPanel.this.lstConfiguredAdapters.getSelectedValue();
                    if (selected == null) {
                        return;
                    }
                    AdaptersPanel.this.lblSelectedAdapterId.setText("Adapter Id: " + selected.getId());
                }
            });
        }
        return this.lstConfiguredAdapters;
    }

    private JButton getBtnAddAdapter() {
        if (this.btnAddAdapter == null) {
            this.btnAddAdapter = new JButton();
            this.btnAddAdapter.setBounds(new Rectangle(24, 91, 248, 28));
            this.btnAddAdapter.setText("Add Service/Adapter");
            this.btnAddAdapter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AdaptersPanel.this.cbTemplateAdapters.getSelectedItem() == null) {
                        AdaptersPanel.this.lblAdapterMessage.setText("Select a Valid Adapter First from the drop down");
                        return;
                    }
                    AdapterConfigurationDecorator selectedItem = (AdapterConfigurationDecorator)AdaptersPanel.this.cbTemplateAdapters.getSelectedItem();
                    AdapterConfigurationDecorator copy = selectedItem.clone();
                    copy.setId("" + (AcmeGUI.getSelectedAdaptersDataModel().size() + 1));
                    AcmeGUI.getSelectedAdaptersDataModel().add(copy);
                    DefaultListModel model = (DefaultListModel)AdaptersPanel.this.lstConfiguredAdapters.getModel();
                    model.addElement(copy);
                    AdaptersPanel.this.lblAdapterMessage.setText("added OK: adapterId: " + copy.getId());
                    AdaptersPanel.this.lblAdapterMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.btnAddAdapter;
    }

    private JButton getBtnRemoveAdapter() {
        if (this.btnRemoveAdapter == null) {
            this.btnRemoveAdapter = new JButton();
            this.btnRemoveAdapter.setBounds(new Rectangle(544, 90, 221, 27));
            this.btnRemoveAdapter.setText("Remove Service/Adapter");
            this.btnRemoveAdapter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AdaptersPanel.this.lstConfiguredAdapters.getSelectedValue() == null) {
                        AdaptersPanel.this.lblAdapterMessage.setText("select an adapter first from the list");
                        AdaptersPanel.this.lblAdapterMessage.setForeground(Color.RED);
                        return;
                    }
                    AdapterConfigurationDecorator selectedElement = (AdapterConfigurationDecorator)AdaptersPanel.this.lstConfiguredAdapters.getSelectedValue();
                    for (ExecutionUnitConfigurationDecorator eu : AcmeGUI.getConfiguredExecutionUnitsDataModel()) {
                        if (!eu.getAdapterId().equals(selectedElement.getId())) continue;
                        AdaptersPanel.this.lblAdapterMessage.setText("This adapter is assigned to an EU. Remove the EU first: eu:" + eu.getDescription());
                        AdaptersPanel.this.lblAdapterMessage.setForeground(Color.RED);
                        return;
                    }
                    DefaultListModel model = (DefaultListModel)AdaptersPanel.this.lstConfiguredAdapters.getModel();
                    model.removeElement(selectedElement);
                    AcmeGUI.getSelectedAdaptersDataModel().remove(selectedElement);
                    AdaptersPanel.this.lblAdapterMessage.setText("Removed OK. adapterId: " + selectedElement.getId());
                    AdaptersPanel.this.lblAdapterMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.btnRemoveAdapter;
    }

    private JButton getBtnConfigureAdapter() {
        if (this.btnConfigureAdapter == null) {
            this.btnConfigureAdapter = new JButton();
            this.btnConfigureAdapter.setText("Configure Selected Service Params");
            this.btnConfigureAdapter.setBounds(new Rectangle(242, 416, 284, 28));
            this.btnConfigureAdapter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdapterConfigurationDecorator selected = (AdapterConfigurationDecorator)AdaptersPanel.this.lstConfiguredAdapters.getSelectedValue();
                    if (selected == null) {
                        AdaptersPanel.this.lblAdapterMessage.setText("Select an adapter from the list first.");
                        AdaptersPanel.this.lblAdapterMessage.setForeground(Color.RED);
                        return;
                    }
                    AdaptersPanel.this.lblAdapterMessage.setText("update params ...");
                    AdaptersPanel.this.lblAdapterMessage.setForeground(Color.BLACK);
                    PropertiesDialog pd = new PropertiesDialog(selected);
                    pd.setModal(true);
                    pd.setVisible(true);
                    AdaptersPanel.this.lblAdapterMessage.setText("");
                }
            });
        }
        return this.btnConfigureAdapter;
    }

    private JButton getBtnDispalyAdapterTemplateProps() {
        if (this.btnDispalyAdapterTemplateProps == null) {
            this.btnDispalyAdapterTemplateProps = new JButton();
            this.btnDispalyAdapterTemplateProps.setBounds(new Rectangle(291, 44, 150, 32));
            this.btnDispalyAdapterTemplateProps.setText("Display Properties");
            this.btnDispalyAdapterTemplateProps.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdapterConfigurationDecorator selected = (AdapterConfigurationDecorator)AdaptersPanel.this.cbTemplateAdapters.getSelectedItem();
                    if (selected == null) {
                        return;
                    }
                    Set<String> keys = selected.getConfiguration().getParameters().keySet();
                    String params = "";
                    for (String key : keys) {
                        params = params + key + "=" + selected.getConfiguration().getParameterValue(key) + "\n\n";
                    }
                    JOptionPane.showMessageDialog(null, "Property Of the Service/Adapter: (you can change these once add/configure the service)\n\n" + params, "Property Of the Service/Adapter", 1);
                }
            });
        }
        return this.btnDispalyAdapterTemplateProps;
    }

    private JComboBox getCbTemplateAdapters() {
        if (this.cbTemplateAdapters == null) {
            this.cbTemplateAdapters = new JComboBox();
            this.cbTemplateAdapters.setToolTipText("A service adapter specifies the technology used to call the server.");
            this.cbTemplateAdapters.setBounds(new Rectangle(27, 48, 246, 29));
            this.cbTemplateAdapters.setName("");
        }
        return this.cbTemplateAdapters;
    }
}

