/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.stats;

import com.ibm.wssvt.acme.common.stats.ExceptionInfoStats;
import com.ibm.wssvt.acme.common.stats.ExecutionStatus;
import com.ibm.wssvt.acme.common.stats.ThreadInfoStats;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ExecutionStats {
    private static ExecutionStats instance = null;
    private Map<String, ExceptionInfoStats> exceptionInfoStatsMap = Collections.synchronizedMap(new HashMap());
    private Map<Integer, ThreadInfoStats> threadInfoStatsMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Long> serverRunInfo = Collections.synchronizedMap(new HashMap());
    private Map<String, Long> overallServerRunInfo = Collections.synchronizedMap(new HashMap());
    private long request;
    private long create;
    private long read;
    private long update;
    private long delete;
    private long find;

    private ExecutionStats() {
    }

    public static ExecutionStats getInstance() {
        if (instance == null) {
            instance = new ExecutionStats();
        }
        return instance;
    }

    public synchronized void reset() {
        this.exceptionInfoStatsMap.clear();
        this.threadInfoStatsMap.clear();
        this.serverRunInfo.clear();
        this.overallServerRunInfo.clear();
        this.create = 0L;
        this.read = 0L;
        this.update = 0L;
        this.delete = 0L;
        this.find = 0L;
        this.request = 0L;
    }

    public synchronized long getCRUDTotal() {
        return this.create + this.read + this.update + this.delete;
    }

    public synchronized long incrumentCreate(long a) {
        return this.create += a;
    }

    public synchronized long incrumentRead(long a) {
        return this.read += a;
    }

    public synchronized long incrumentUpdate(long a) {
        return this.update += a;
    }

    public synchronized long incrumentDelete(long a) {
        return this.delete += a;
    }

    public synchronized long incrumentFind(long a) {
        return this.find += a;
    }

    public synchronized long getCreate() {
        return this.create;
    }

    public synchronized long getDelete() {
        return this.delete;
    }

    public synchronized long getFind() {
        return this.find;
    }

    public synchronized long getRead() {
        return this.read;
    }

    public synchronized long getUpdate() {
        return this.update;
    }

    public synchronized long getRequest() {
        return this.request;
    }

    public synchronized long incrumentRequest(long a) {
        return this.request += a;
    }

    public synchronized ExceptionInfoStats getExceptionInfoStats(Exception exception) {
        return this.exceptionInfoStatsMap.get(exception.getClass().getName());
    }

    public synchronized long incrumentExceptionStatsCount(Exception exception, int threadId, Date date, String euDesc, int maxMsgSize, int exceptionMaxCount) {
        ExceptionInfoStats exInfoStats = this.exceptionInfoStatsMap.get(exception.getClass().getName());
        if (exInfoStats == null) {
            exInfoStats = new ExceptionInfoStats();
            exInfoStats.setCount(0L);
            exInfoStats.setName(exception.getClass().getName());
            this.exceptionInfoStatsMap.put(exception.getClass().getName(), exInfoStats);
        }
        exInfoStats.setCount(exInfoStats.getCount() + 1L);
        exInfoStats.addExceptionData(exInfoStats.getCount(), threadId, date, euDesc, exception.getMessage(), maxMsgSize, exceptionMaxCount);
        return exInfoStats.getCount();
    }

    public synchronized void setThreadStartTime(int threadId, Date value) {
        ThreadInfoStats threadStats = this.threadInfoStatsMap.get(threadId);
        threadStats.setThreadStartTime(value);
    }

    public synchronized void setThreadEndTime(int threadId, Date value) {
        ThreadInfoStats threadStats = this.threadInfoStatsMap.get(threadId);
        threadStats.setThreadEndTime(value);
    }

    public synchronized long incrumentThreadClockTime(int threadId, long value) {
        ThreadInfoStats threadStats = this.threadInfoStatsMap.get(threadId);
        threadStats.setExecutionClockTime(threadStats.getExecutionClockTime() + value);
        return threadStats.getExecutionClockTime();
    }

    public synchronized long incrumentThreadCPUTime(int threadId, long value) {
        ThreadInfoStats threadStats = this.threadInfoStatsMap.get(threadId);
        threadStats.setExecutionActiveTime(threadStats.getExecutionActiveTime() + value);
        return threadStats.getExecutionActiveTime();
    }

    public synchronized long incrumentThreadLoopCount(int threadId) {
        ThreadInfoStats threadStats = this.threadInfoStatsMap.get(threadId);
        threadStats.setLoopCount(threadStats.getLoopCount() + 1L);
        return threadStats.getLoopCount();
    }

    public synchronized ExecutionStatus getThreadExecutionStatus(int threadId) {
        ThreadInfoStats value = this.threadInfoStatsMap.get(threadId);
        return value.getExecutionStatus();
    }

    public synchronized void setThreadExecutionStatus(int threadId, ExecutionStatus status) {
        ThreadInfoStats threadStats = this.threadInfoStatsMap.get(threadId);
        threadStats.setExecutionStatus(status);
    }

    public synchronized Map<String, ExceptionInfoStats> getExceptionCount() {
        return this.exceptionInfoStatsMap;
    }

    public synchronized Map<Integer, ThreadInfoStats> getThreadInfoStatsMap() {
        return this.threadInfoStatsMap;
    }

    public synchronized Map<String, Long> getServerRunInfo() {
        return this.serverRunInfo;
    }

    public synchronized long incrumentServerRunInfo(String serverName, long value) {
        Long currentValue = this.serverRunInfo.get(serverName);
        if (currentValue == null) {
            currentValue = 0L;
        }
        this.serverRunInfo.put(serverName, currentValue + value);
        return value;
    }

    public synchronized Map<String, Long> getOverallServerRunInfo() {
        return this.overallServerRunInfo;
    }

    public synchronized long incrumentOverallServerRunInfo(String serverName, long value) {
        Long currentValue = this.overallServerRunInfo.get(serverName);
        if (currentValue == null) {
            currentValue = 0L;
        }
        this.overallServerRunInfo.put(serverName, currentValue + value);
        return value;
    }

    public synchronized void addThreadToStats(int threadId) {
        ThreadInfoStats value = this.threadInfoStatsMap.get(threadId);
        if (value == null) {
            value = ThreadInfoStats.newInstance(threadId, ExecutionStatus.RUNNING);
        }
        this.threadInfoStatsMap.put(threadId, value);
    }
}

