/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ifix.installer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IFixContentRepository {
    final Map<String, List<IFixBundle>> contentMap = new HashMap<String, List<IFixBundle>>();
    final Map<String, IFixBundle> pathMap = new HashMap<String, IFixBundle>();
    final Set<String> knownBundleContent = new HashSet<String>();
    final String ifixID;

    public void parse(InputStream is) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d = db.parse(is);
        NodeList nl = d.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Element && n.getNodeName().equalsIgnoreCase("libertyFixMetadata")) {
                NodeList fixElements = n.getChildNodes();
                int j = 0;
                while (j < fixElements.getLength()) {
                    Node subNode = fixElements.item(j);
                    if (subNode.getNodeName().equalsIgnoreCase("bundles")) {
                        NodeList fileNodes = subNode.getChildNodes();
                        int k = 0;
                        while (k < fileNodes.getLength()) {
                            Node fileNode = fileNodes.item(k);
                            if (fileNode instanceof Element) {
                                String name = ((Element)fileNode).getAttribute("id");
                                String symbolicName = ((Element)fileNode).getAttribute("symbolicName");
                                String version = ((Element)fileNode).getAttribute("version");
                                String isBase = ((Element)fileNode).getAttribute("isBaseBundle");
                                IFixBundle ifb = new IFixBundle();
                                ifb.fileName = name;
                                ifb.symbolicName = symbolicName;
                                ifb.version = version;
                                ifb.isBase = Boolean.parseBoolean(isBase);
                                List<IFixBundle> list = this.contentMap.get(symbolicName);
                                if (list == null) {
                                    list = new ArrayList<IFixBundle>();
                                    this.contentMap.put(symbolicName, list);
                                }
                                list.add(ifb);
                                this.knownBundleContent.add(name);
                                this.pathMap.put(name, ifb);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public IFixContentRepository(ZipFile ifixJar) throws Exception {
        StringBuilder ifixIDBuilder = new StringBuilder();
        HashSet<String> metadataNames = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = ifixJar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            String name = ze.getName();
            if (!name.startsWith("lib/fixes") || !name.endsWith(".lpmf")) continue;
            metadataNames.add(name);
            ifixIDBuilder.append(name.substring("lib/fixes/".length(), name.length() - ".lpmf".length()));
        }
        for (String metadataFile : metadataNames) {
            ZipEntry entry = ifixJar.getEntry(metadataFile);
            this.parse(ifixJar.getInputStream(entry));
        }
        this.ifixID = ifixIDBuilder.toString();
    }

    public String getIfixIdentifier() {
        return this.ifixID;
    }

    public boolean isStaticContent(String name) {
        boolean isNotStaticContent = name.startsWith("lib/fixes") && name.endsWith(".xml") || name.startsWith("lib/fixes") && name.endsWith(".lpmf") || name.startsWith("wlp/extract") || name.startsWith("org/apache") || name.startsWith("com/ibm") || name.startsWith("META-INF/") || this.knownBundleContent.contains(name);
        return !isNotStaticContent;
    }

    public boolean containsBaseBundle(String location, String symbolicName, String version) {
        if (this.contentMap.containsKey(symbolicName)) {
            Version test = Version.parseVersion(version);
            for (IFixBundle ifb : this.contentMap.get(symbolicName)) {
                Version ifbVersion = Version.parseVersion(ifb.version);
                if (!ifb.isBase || ifbVersion.getMajor() != test.getMajor() || ifbVersion.getMinor() != test.getMinor() || ifbVersion.getMicro() != test.getMicro() || !ifb.fileName.startsWith(location)) continue;
                return true;
            }
        }
        return false;
    }

    public String getSymbolicName(String name) {
        if (this.pathMap.containsKey(name)) {
            return this.pathMap.get((Object)name).symbolicName;
        }
        return null;
    }

    public String getVersion(String name) {
        if (this.pathMap.containsKey(name)) {
            return this.pathMap.get((Object)name).version;
        }
        return null;
    }

    public boolean ownsContent(String name) {
        return this.pathMap.containsKey(name);
    }

    public boolean containsBundle(String location, String symbolicName, VersionRange versionRange) {
        if (this.contentMap.containsKey(symbolicName)) {
            for (IFixBundle ifb : this.contentMap.get(symbolicName)) {
                Version ifbVersion = Version.parseVersion(ifb.version);
                if (!versionRange.includes(ifbVersion)) continue;
                return true;
            }
        }
        return false;
    }

    private static class IFixBundle {
        String fileName;
        String symbolicName;
        String version;
        boolean isBase;

        private IFixBundle() {
        }
    }
}

